#include "vlupo.h"

int vlupoio_nimin_segdata(unsigned int maddr){

  vread16(maddr+VLUPO_IO_NIMIN, (short *)(data+mp));
  mp += 1;
  segmentsize += 1;

  return segmentsize;
}

int vlupoio_nimcoin_segdata(unsigned int maddr){

  vread16(maddr+VLUPO_IO_NIMCOIN, (short *)(data+mp));
  mp += 1;
  segmentsize += 1;

  return segmentsize;
}

int vlupoio_lvdsin_segdata(unsigned int maddr){

  vread16(maddr+VLUPO_IO_LVDSIN, (short *)(data+mp));
  mp += 1;
  segmentsize += 1;

  return segmentsize;
}

int vlupoio_lvdscoin_segdata(unsigned int maddr){

  vread16(maddr+VLUPO_IO_LVDSCOIN, (short *)(data+mp));
  mp += 1;
  segmentsize += 1;

  return segmentsize;
}

void vlupoio_clear(unsigned int maddr){
  short val = 1;

  vread16(maddr+VLUPO_IO_CLEAR, &val); 
}

void vlupoio_enable_interrupt(unsigned int maddr){
  short val = 1;

  vwrite16(maddr+VLUPO_IO_INTENABLE, &val);

}

void vlupoio_disable_interrupt(unsigned int maddr){
  short val = 1;

  vwrite16(maddr+VLUPO_IO_INTDISABLE, &val);

}

void vlupoio_pulse(unsigned int maddr, short val){

  vwrite16(maddr+VLUPO_IO_PULSE, &val);
}

void vlupots_pulse(unsigned int maddr, short val){
  vlupoio_pulse(maddr, val);
}

void vlupoio_level(unsigned int maddr, short val){

  vwrite16(maddr+VLUPO_IO_LEVEL, &val);
}

void vlupoio_intdelay(unsigned int maddr, short val){

  vwrite16(maddr+VLUPO_IO_INTDELAY, &val);
}

void vlupoio_pulsewidth(unsigned int maddr, short val){

  vwrite16(maddr+VLUPO_IO_PULSEWIDTH, &val);
}


int vlupots_segts(unsigned int maddr){

  vread32(maddr+VLUPO_TS_DATA32L, (int *)(data+mp));
  mp += 2;
  vread32(maddr+VLUPO_TS_DATA32H, (int *)(data+mp));
  mp += 1;
  segmentsize += 3;
  
  memcpy((char *)&timestamp , (char *)(data+mp-3), 8);
  
  
  return segmentsize;
}

int vlupots_segtsfly(unsigned int maddr){
  vread32(maddr+VLUPO_TS_DATAFLY, (int *)(data+mp));
  mp += 2;
  segmentsize += 2;

  return segmentsize;
}

void vlupots_intdelay(unsigned int maddr, short val){

  vwrite16(maddr+VLUPO_TS_INTDELAY, &val);
}

void vlupots_pulsewidth(unsigned int maddr, short val){

  vwrite16(maddr+VLUPO_TS_PULSEWIDTH, &val);
}

void vlupots_clear(unsigned int maddr){
  short val = 1;

  vread16(maddr+VLUPO_TS_CLEAR, &val);
}

void vlupots_clear_counter(unsigned int maddr){
  short val = 1;

  vread16(maddr+VLUPO_TS_CLEARCOUNTER, &val);
}

int vlupots_segfifocnt(unsigned int maddr){
  int lval;
   
  vread32(maddr+VLUPO_TS_FIFOCNT, &lval);
  data[mp] = lval & 0x0000ffff;
  mp ++;
  segmentsize ++;

  return segmentsize;
}

int vlupots_segtrgcnt(unsigned int maddr){
  vread32(maddr+VLUPO_TS_TRGCOUNTER, (int *)(data+mp));
  mp +=2;
  segmentsize +=2;

  return segmentsize;
}

void vlupots_clkmode(unsigned int maddr, short val){

  vwrite16(maddr+VLUPO_TS_CLKMODE, &val);
}

void vlupots_enable_interrupt(unsigned int maddr){
  short val = 1;

  vwrite16(maddr+VLUPO_TS_INTENABLE, &val);

}

void vlupots_disable_interrupt(unsigned int maddr){
  short val = 1;

  vwrite16(maddr+VLUPO_TS_INTDISABLE, &val);

}
