      SUBROUTINE Loadgppacconf
      IMPLICIT NONE
      INTEGER ier, i, j
      CHARACTER*132 prmfile,confname

      INCLUDE 'numbers.fh'
      INCLUDE 'gppacconf.fh'
      INCLUDE 'gppacprm.fh'

      INTEGER ifcs,iordr,itype,n,preifcs
      INTEGER id,nlp,nofp
      REAL    zpos,prm(4,2)

      REAL    diffzpos(4,2) ! see ppacconf.prm
      DATA    diffzpos/-3.5,-18.7,18.7,-4.1, ! dzx
     &	                5.1,-10.1,10.1, 4.1/ ! dzy

      ier = 0

      CALL Getenv('GPPAC_CONFIG',prmfile)
      OPEN (UNIT=80, FILE=prmfile, STATUS='old',ERR=1001)

      preifcs = 0
      nofp = 0
      nlp = 0
      id = 0
      maxfcs = 0
      DO i = 1, 20
         maxnp(i) = 0
      ENDDO

      DO WHILE (ier.EQ.0)
         CALL Skip_comment(80)
         READ(80,*,END=1000)ifcs,iordr,zpos,itype,confname
         nlp = itype
         IF (itype.EQ.3) nlp = 1
         n = nlp*4
         OPEN (UNIT=90, FILE=confname, STATUS='old',ERR=1001)
         CALL Read_flt(90,prm,n,ier)
         CLOSE(90)
         IF (preifcs.NE.ifcs) nofp = 0
         IF (maxnp(ifcs).NE.0) nofp = maxnp(ifcs)
         DO i = 1, nlp, 1
            nofp = nofp + 1
            id = id + 1
            j = itype + i - 1
            IF(itype.EQ.1) j = 1
            IF(itype.EQ.3) j = 4
c            WRITE(*,*)ifcs,iordr,nlp,id,j
            ppaczpos(1,id) = zpos + diffzpos(j,1)
            ppaczpos(2,id) = zpos + diffzpos(j,2)
            ns2mm(igx,id) = 0.5 * prm(igx,i)
            ns2mm(igy,id) = 0.5 * prm(igy,i)
            inoffset(igx,id) = prm(igx+2,i)
            inoffset(igy,id) = prm(igy+2,i)
            ppacfcs(1,id) = ifcs
            ppacfcs(2,id) = nofp
            ppacid(nofp,ifcs) = id
c     WRITE(*,*)i,ppacfcs(1,id),ppacfcs(2,id),ppacid(nofp,ifcs)
         ENDDO
         maxnp(ifcs) = nofp
         preifcs = ifcs
         IF (preifcs.GT.maxfcs) maxfcs = preifcs
      ENDDO
      
 1000 WRITE(*,*)' ANAPAW-M : [Loadgppacconf] Loaded parameters.'

      CLOSE(80)
      RETURN

 1001 WRITE(*,'(2A)')' ANAPAW-E : [Loadgppacconf] Cannot open file.', 
     &     prmfile(1:Len_trim(prmfile))
      STOP
      RETURN

 1002 WRITE(*,*)
     &     ' ANAPAW-E : [Loadgppacconf] Error while reading parameters.'
      CLOSE(80)
      STOP
      RETURN

      END


