c Analyzer 11 : Encpid
      SUBROUTINE Encpid(val,nx,ny,naok)
c---------------------------------------------------------------------------
c ANALYZER 11 : PID
c---------------------------------------------------------------------------
c
c ----------
c ID =   1 : TOF & Beta
c            Word lists are defined in 'src/prm/pid/tof.prm'.
c TOF
c    W#: 1       2      3       4       5
c        ID      F3-F5  F3-F7   F7-F11  F9-F11
c        6       7      8       9       10
c        F3-F8   F8-F9  F8-F11  F5-F7
c
c Beta
c        21      22     23      24      25
c                F3-F5  F3-F7   F7-F11  F9-F11
c        26      27     28      29      30
c        F3-F8   F8-F9  F8-F11  F5-F7
c
c ----------
c ID =   2 : dE
c    W#: 1       2       3       4       5       6
c        ID      F7IC    F11IC   F7Pl    F11Pl   F3Pl
c
c ----------
c ID =  11 : F3-F5   position
c       12 : F3-F5   reconstruction
c       13 : F9-F11  position
c       14 : F9-F11  reconstruction
c       15 : F8-F9   position
c       16 : F8-F9   reconstruction
c
c    W#: 1       2       3      4      5     
c        ID      Brho    Beta   Z      AoQ   
c
c---------------------------------------------------------------------------
c

      IMPLICIT NONE
      INCLUDE 'analyslogic.fh'
      INCLUDE 'commonprm.fh'
      INCLUDE 'numbers.fh'
      INCLUDE 'fldata.fh'
      INCLUDE 'pid.fh'
      INCLUDE 'pidprm.fh'
      INCLUDE 'matrixdata.fh'
      INCLUDE 'fpdata.fh'
      INCLUDE 'physdata.fh'
      INTEGER nx, ny, naok
      REAL    val(nx,ny)

c for tree
      INCLUDE 'fortree.fh'
c

c local
      INTEGER i,j
      INTEGER staf,stak,stof,stok
      REAL    toffset,temp
c user vals
      REAL    tofval,flval,betaval,deval,brhoval
      REAL    zval,aoqval
      LOGICAL lcalc

c
      IF (initencflag(11)) THEN
         CALL Loadpidprm
         DO i = 1, ntof, 1
            DO j = 1, 3, 1
               ltof(INT(tfk(1,i)),INT(tfk(3,i)),j) = .FALSE.
            ENDDO
         ENDDO
         j = 1
         DO i = 1, ntof, 1
            staf = INT(tfk(1,i))
            stak = INT(tfk(2,i))
            stof = INT(tfk(3,i))
            stok = INT(tfk(4,i))
            IF (ltof(staf,stof,j)) j = j + 1
            ltof(staf,stof,j) = .TRUE.
            IF (lfltof) THEN
               fl(staf,stof,j) = 
     &              ( flfocus(stof) + flpla(stok,stof) ) -
     &              ( flfocus(staf) + flpla(stak,staf) )
            ELSE
               fl(staf,stof,j) = flfocus(stof)- flfocus(staf)
            ENDIF
c            WRITE(*,*)staf,stof
c            WRITE(*,*)fl(staf,stof,j)
         ENDDO
         initencflag(11) = .FALSE.
      ENDIF

c --------------------------------------------------------------------------
c
c for TOF. 
c 
c TOF(1st,2nd,j) are available, which are defined in 'src/prm/pid/tof.prm'.
c j is order (max : 3). If same TOF(1st,2nd) exist, j = j + 1.
c
      DO i = 1, ntof, 1
         DO j = 1, 3, 1
            ltof(INT(tfk(1,i)),INT(tfk(3,i)),j) = .FALSE.
         ENDDO
      ENDDO

      naok = 0

      j = 1
      naok = naok + 1
      val(1,naok) = 1

      DO i = 1, ntof
         staf = INT(tfk(1,i))
         stak = INT(tfk(2,i))
         stof = INT(tfk(3,i))
         stok = INT(tfk(4,i))
         toffset = tfk(5,i)
         IF (ltof(staf,stof,j)) j = j + 1
         tof(staf,stof,j) = -1000.
         betac(staf,stof,j) = -1000.
         IF (lfpdata(stak,2,staf) .AND. lfpdata(stok,2,stof)) THEN
            ltof(staf,stof,j) = .TRUE.
            tof(staf,stof,j) = 
     &           fpdata(stok,2,stof) - fpdata(stak,2,staf) + toffset
            IF (fl(staf,stof,j).GT.0.) THEN
               betac(staf,stof,j) = 
     &              fl(staf,stof,j)/tof(staf,stof,j)/clight
            ENDIF
         ENDIF
         val(i+1,naok) = tof(staf,stof,j)
         val(i+21,naok) = betac(staf,stof,j)
c for tree
         tofdata(i) = tof(staf,stof,j)
c         
      ENDDO
c for tree
      notof = ntof
c

c --------------------------------------------------------------------------
c
c for dE. 
c dek(1,i) : Focus ID
c            1 - nfocus
c dek(2,i) : Detector type
c            1 = I.C. 
c            2 = SSD
c            3 = Others : 1st plastic
c            4 = Others : 2nd plastic 
c
      naok = naok + 1
      val(1,naok) = 2
      DO i = 1, nde
         de(dek(2,i),dek(1,i)) = -1000.
         IF (lfpdata(dek(2,i),3,dek(1,i))) THEN
            de(dek(2,i),dek(1,i)) = fpdata(dek(2,i),3,dek(1,i))
         ENDIF
c         val(dek(1,i)+10,naok) = de(dek(2,i),dek(1,i))
         val(i+1,naok) = de(dek(2,i),dek(1,i))
      ENDDO
c --------------------------------------------------------------------------

      DO i = 1, nconfig, 1
         lcalc = .TRUE.
         tofval = -1000.
         flval  = -1000.
         betaval = -1000.
         brhoval = -1000.
         zval = -1000.
         aoqval = -1000.

         IF (lflcorrect .AND. 
     &        lmatrix(brcnf(1,i),brcnf(2,i),brcnf(3,i))) THEN
            fl(btcnf(1,i),btcnf(2,i),btcnf(3,i)) = 
     &           fl(btcnf(1,i),btcnf(2,i),btcnf(3,i)) + 
     &           rdfl(btcnf(1,i),btcnf(2,i),btcnf(3,i))
         ENDIF
c -----------------------------------
c calculation of dE
c
         IF (de(decnf(2,i),decnf(1,i)).GT.0.) THEN
            deval = de(decnf(2,i),decnf(1,i))
         ELSE
            lcalc = lcalc .AND. .FALSE.
         ENDIF

c -----------------------------------
c calculation of beta
c
         SELECT CASE (btcnf(4,i))
         CASE (1)
            IF (ltof(btcnf(1,i),btcnf(2,i),btcnf(3,i)) ) THEN
               tofval  = tof(btcnf(1,i),btcnf(2,i),btcnf(3,i))
               flval   = fl(btcnf(1,i),btcnf(2,i),btcnf(3,i))
               betaval = flval/tofval/clight
            ELSE
               lcalc = lcalc .AND. .FALSE.
            ENDIF
         CASE (2)
            IF ( ltof(tofcnf(1,i),tofcnf(2,i),tofcnf(3,i)) ) THEN
               CALL Rec_beta(
     &              brhon(btcnf(1,i),btcnf(2,i)),
     &              brhon(btpcnf(1,i),btpcnf(2,i)),
     &              fl(btcnf(1,i),btcnf(2,i),btcnf(3,i)),
     &              fl(btpcnf(1,i),btpcnf(2,i),btpcnf(3,i)),
     &              tof(tofcnf(1,i),tofcnf(2,i),tofcnf(3,i)),
     &              betaval,temp)
            ELSE
               lcalc = lcalc .AND. .FALSE.
            ENDIF
         CASE (3)
            IF ( ltof(tofcnf(1,i),tofcnf(2,i),tofcnf(3,i)) .AND.
     &           lmatrix(btcnf(1,i),btcnf(2,i),btcnf(3,i)) .AND.
     &           lmatrix(btpcnf(1,i),btpcnf(2,i),btpcnf(3,i)) ) THEN
               CALL Rec_beta(
     &              rbrho(btcnf(1,i),btcnf(2,i),btcnf(3,i)),
     &              rbrho(btpcnf(1,i),btpcnf(2,i),btpcnf(3,i)),
     &              fl(btcnf(1,i),btcnf(2,i),btcnf(3,i)),
     &              fl(btpcnf(1,i),btpcnf(2,i),btpcnf(3,i)),
     &              tof(tofcnf(1,i),tofcnf(2,i),tofcnf(3,i)),
     &              betaval,temp)
            ELSE
               lcalc = lcalc .AND. .FALSE.
            ENDIF
         CASE DEFAULT
            lcalc = lcalc .AND. .FALSE.
         END SELECT

c -----------------------------------
c calculation of Z
c
         IF (lcalc) CALL Z_calc(deval,betaval,
     &           ionpair(decnf(2,i),decnf(1,i)),
     &           zcoeff(1,decnf(2,i),decnf(1,i)),zval)

c -----------------------------------
c calculation of brho
c
         SELECT CASE (brcnf(4,i))
         CASE (1)
            IF (lmatrix(brcnf(1,i),brcnf(2,i),brcnf(3,i))) THEN
               brhoval = rbrho(brcnf(1,i),brcnf(2,i),brcnf(3,i))
            ELSE
               lcalc = lcalc .AND. .FALSE.
            ENDIF
         CASE (2)
            IF (lmatrix(brcnf(1,i),brcnf(2,i),0)) THEN
               brhoval = rbrho(brcnf(1,i),brcnf(2,i),0)
            ELSE
               lcalc = lcalc .AND. .FALSE.
            ENDIF
         CASE (3)
            brhoval = brhon(brcnf(1,i),brcnf(2,i))
         CASE DEFAULT
            lcalc = lcalc .AND. .FALSE.
         END SELECT
c         WRITE(*,*)idcnf(i),brcnf(1,i),brcnf(2,i),brcnf(3,i),brcnf(4,i)
c         WRITE(*,*)lmatrix(brcnf(1,i),brcnf(2,i),0)

c -----------------------------------
c calculation of AoQ
c
         IF (lcalc) CALL Aoq_calc(brhoval,betaval,aoqval)

c -----------------------------------
c Store event data
         naok = naok + 1
         val(1,naok) = idcnf(i)
         val(2,naok) = brhoval
         val(3,naok) = betaval
         val(4,naok) = zval
         val(5,naok) = aoqval
c for tree
         aoqdata(1,i) = brhoval
         aoqdata(2,i) = betaval
         aoqdata(3,i) = zval
         aoqdata(4,i) = aoqval
c
      ENDDO
c for tree
      noaoq = nconfig
c

      RETURN

      END
