/* functions */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#include "libskelgto.h"
#include "cmdselgtofunc.h"
#include "cmdselgto.h"

extern COMMAND comlist[];

char data[64] = {0};
char t[256] = {0};

const char *ofstr[] = {"off\0", "on\0"};

void showsel(int val);
void showdssel(int val);

char *findparam(char ena, SDGTOADV *adv){
  int i = 0;

  while(adv[i].param){
    if(ena == adv[i].val){
      return adv[i].param;
    }
    i++;
  }
  
  return NULL;
}

int chkupper(char c){
  if(isupper(c)){
    return 1;
  }else{
    return 0;
  }
}

int chkone(char c){
  if(c == '1'){
    return 1;
  }
  return 0;
}

int chkval(char *arg, SDGTOADV *adv){
  int i=0;
  while(adv[i].param){
    if(!strcmp(adv[i].param, arg)){
      return adv[i].val;
    }
    i++;
  }

  return -1;
}

char chkadv(char *arg, SDGTOADV *adv, SDGTOADV *radv){
  int i=0;
  while(adv[i].param){
    if(!strcmp(adv[i].param, arg)){
      memcpy((char *)radv, (char *)(adv+i), sizeof(SDGTOADV));
      return 1;
    }
    i++;
  }
  radv->param = NULL;
  radv->addr = -1;
  radv->val = -1;
  radv->disable = -1;
  return -1;
}

int noop(void){
  return gto_read(data);
}

int status(void){
  int i;
  int pt, rt;

  gto_read(data);


  printf("*** Status ***\n");

  // DS select
  for(i=0;i<8;i++){
    printf("Out[%2d] : ", i);
    memcpy((char *)&pt, data+i*4, sizeof(pt));
    showsel(pt);
    printf("\n");
  }
  printf("\n");
  for(i=0;i<8;i++){
    rt = 0; pt = 0;
    memcpy((char *)&pt, data+56+i, 1);
    memcpy((char *)&rt, data+32+i*3, 3);
    printf("DS [%2d] : ", i);
    printf(" rate=%8d / src=", rt);
    showdssel(pt);
    printf("\n");
  }

  printf("\n\n");

  return 1;
}

int read(void){
  gto_read(data);
  gto_dumpdata(data);
  //gto_dumpcdata(data);
  return 1;
}

int init(void){
  printf("Initialize\n");
  return gto_reset();
}

int eepr(void){
  printf("Parameters from EEPROM\n");
  gto_eepread();

  gto_read(data);
  gto_dumpdata(data);
  //gto_dumpcdata(data);
  return 1;
}

int eepw(void){
  printf("Current parameters to EEPROM\n");
  return gto_eepwrite();
}

void showsel(int val){
  int i=0;

  if(val == 0){
    printf(" none");
    return;
  }

  while(seladv[i].val != -1){
    if(val & seladv[i].val){
      printf(" %s", seladv[i].param);
    }
    i++;
  }

  return;
}

// Set output source
int out(char adr, char *args[]){
  int i=0, val=0, v;

  if(!args[0]) return 0;

  while(args[i]){
    if((v = chkval(args[i], seladv)) > -1){
      val |= v;
    }else{
      val = strtol(args[i], NULL, 0);
      printf("select value = 0x%08x\n", val);
    }
    i++;
  }

  printf("Selected inputs :");
  showsel(val);
  printf("\n");

  gto_write32(adr, val);

  status();

  return 1;
}

int out0(char *args[]){
  return out(adr_out0, args);
}

int out1(char *args[]){
  return out(adr_out1, args);
}

int out2(char *args[]){
  return out(adr_out2, args);
}

int out3(char *args[]){
  return out(adr_out3, args);
}

int out4(char *args[]){
  return out(adr_out4, args);
}

int out5(char *args[]){
  return out(adr_out5, args);
}

int out6(char *args[]){
  return out(adr_out6, args);
}

int out7(char *args[]){
  return out(adr_out7, args);
}

void showdssel(int val){
  int i=0;

  while(dsseladv[i].val != -1){
    if(val == dsseladv[i].val){
      printf(" %s", dsseladv[i].param);
      return;
    }
    i++;
  }

  printf(" Invalid");
  return;
}

// Set output source
int dssel(char adr, char *args[]){
  char val=0;

  if(!args[0]) return 0;

  if((val = (char)chkval(args[0], dsseladv)) > -1){
    printf("DS source selected %s\n", args[0]);
  }else{
    printf("Invalid DS source %s\n", args[0]);
    return 0;
  }

  gto_write(adr, val);

  status();

  return 1;
}

int dssel0(char *args[]){
  return dssel(adr_dssel0, args);
}

int dssel1(char *args[]){
  return dssel(adr_dssel1, args);
}

int dssel2(char *args[]){
  return dssel(adr_dssel2, args);
}

int dssel3(char *args[]){
  return dssel(adr_dssel3, args);
}

int dssel4(char *args[]){
  return dssel(adr_dssel4, args);
}

int dssel5(char *args[]){
  return dssel(adr_dssel5, args);
}

int dssel6(char *args[]){
  return dssel(adr_dssel6, args);
}

int dssel7(char *args[]){
  return dssel(adr_dssel7, args);
}

// Set output source
int dsrate(char adr, char *args[]){
  int val=0;

  if(!args[0]) return 0;

  val = strtol(args[0], NULL, 0);
  if(val < 0 || val > 16777215){
    printf("Invalid DS rate %d\n", val);
    return 0;
  }

  gto_write24(adr, val);
  rst();

  status();

  return 1;
}

int dsrate0(char *args[]){
  return dsrate(adr_dsrate0, args);
}

int dsrate1(char *args[]){
  return dsrate(adr_dsrate1, args);
}

int dsrate2(char *args[]){
  return dsrate(adr_dsrate2, args);
}

int dsrate3(char *args[]){
  return dsrate(adr_dsrate3, args);
}

int dsrate4(char *args[]){
  return dsrate(adr_dsrate4, args);
}

int dsrate5(char *args[]){
  return dsrate(adr_dsrate5, args);
}

int dsrate6(char *args[]){
  return dsrate(adr_dsrate6, args);
}

int dsrate7(char *args[]){
  return dsrate(adr_dsrate7, args);
}



int pulse(char *args[]){
  unsigned char val;

  if(!args[0]) return 0;

  val = (unsigned char)strtol(args[0], NULL, 0);
  
  gto_uwrite(uadr_pulse, val);

  return 1;
}

int rst(void){
  gto_uwrite(uadr_rst, 1);
  return 1;
}

int test(char *args[]){
  char v;

  if(!args[0]) return 0;

  if((v = (char)chkval(args[0], testadv)) < 0){
    return 0;
  }
  gto_uwrite(uadr_test, v);
  printf("Test LED %s\n", args[0]);

  return 1;
}

int help(void){
  int i;
  printf(" cmdselgto HOSTNAME COM [params] ...\n\n");
  printf(" COM = ");
  i = 0;
  while(comlist[i].com != NULL){
    printf(" %-8s : %s ", comlist[i].com, comlist[i].doc);
    if(comlist[i].param != NULL){
      printf("(%s)", comlist[i].param);
    }
    printf("\n       ");
    i++;
  }
  printf("\n");

  return 1;
}
