/* Parameters of SDGTO2 */

const char adr_out0      =  0;
const char adr_out1      =  4;
const char adr_out2      =  8;
const char adr_out3      = 12;
const char adr_out4      = 16;
const char adr_out5      = 20;
const char adr_out6      = 24;
const char adr_out7      = 28;
const char adr_dsrate0   = 32;
const char adr_dsrate1   = 35;
const char adr_dsrate2   = 38;
const char adr_dsrate3   = 41;
const char adr_dsrate4   = 44;
const char adr_dsrate5   = 47;
const char adr_dsrate6   = 50;
const char adr_dsrate7   = 53;
const char adr_dssel0    = 56;
const char adr_dssel1    = 57;
const char adr_dssel2    = 58;
const char adr_dssel3    = 59;
const char adr_dssel4    = 60;
const char adr_dssel5    = 61;
const char adr_dssel6    = 62;
const char adr_dssel7    = 63;
const char uadr_rst      =  0;
const char uadr_pulse    =  1;
const char uadr_test     =  2;


typedef struct {
  char *param;
  char  addr;
  int   val;
  char  disable;
} SDGTOADV;

SDGTOADV seladv[] = {
  {"in0\0",   -1, 0x00000001, -1},
  {"in1\0",   -1, 0x00000002, -1},
  {"in2\0",   -1, 0x00000004, -1},
  {"in3\0",   -1, 0x00000008, -1},
  {"in4\0",   -1, 0x00000010, -1},
  {"in5\0",   -1, 0x00000020, -1},
  {"in6\0",   -1, 0x00000040, -1},
  {"in7\0",   -1, 0x00000080, -1},
  {"in8\0",   -1, 0x00000100, -1},
  {"in9\0",   -1, 0x00000200, -1},
  {"in10\0",  -1, 0x00000400, -1},
  {"in11\0",  -1, 0x00000800, -1},
  {"in12\0",  -1, 0x00001000, -1},
  {"in13\0",  -1, 0x00002000, -1},
  {"in14\0",  -1, 0x00004000, -1},
  {"in15\0",  -1, 0x00008000, -1},
  {"in16\0",  -1, 0x00010000, -1},
  {"in17\0",  -1, 0x00020000, -1},
  {"in18\0",  -1, 0x00040000, -1},
  {"in19\0",  -1, 0x00080000, -1},
  {"ds0\0",   -1, 0x00100000, -1},
  {"ds1\0",   -1, 0x00200000, -1},
  {"ds2\0",   -1, 0x00400000, -1},
  {"ds3\0",   -1, 0x00800000, -1},
  {"ds4\0",   -1, 0x01000000, -1},
  {"ds5\0",   -1, 0x02000000, -1},
  {"ds6\0",   -1, 0x04000000, -1},
  {"ds7\0",   -1, 0x08000000, -1},
  {"1k\0",    -1, 0x10000000, -1},
  {"10k\0",   -1, 0x20000000, -1},
  {"level\0", -1, 0x40000000, -1},
  {"veto\0",  -1, 0x80000000, -1},
  {"none\0",  -1, 0x00000000, -1},
  {NULL, -1, -1, -1}
};

SDGTOADV dsseladv[] = {
  {"in0\0",   -1,  0, -1},
  {"in1\0",   -1,  1, -1},
  {"in2\0",   -1,  2, -1},
  {"in3\0",   -1,  3, -1},
  {"in4\0",   -1,  4, -1},
  {"in5\0",   -1,  5, -1},
  {"in6\0",   -1,  6, -1},
  {"in7\0",   -1,  7, -1},
  {"in8\0",   -1,  8, -1},
  {"in9\0",   -1,  9, -1},
  {"in10\0",  -1, 10, -1},
  {"in11\0",  -1, 11, -1},
  {"in12\0",  -1, 12, -1},
  {"in13\0",  -1, 13, -1},
  {"in14\0",  -1, 14, -1},
  {"in15\0",  -1, 15, -1},
  {"in16\0",  -1, 16, -1},
  {"in17\0",  -1, 17, -1},
  {"in18\0",  -1, 18, -1},
  {"in19\0",  -1, 19, -1},
  {"50M\0", -1, 20, -1},
  {NULL, -1, -1, -1}
};

SDGTOADV testadv[] = {
  {"on",  -1, 0x01, -1},
  {"off", -1, 0x00, -1},
  {NULL, -1, -1, -1}
};


