/*
 * last modified : 15/02/03 18:31:16 
 *
 * Hidetada Baba (RIKEN)
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "libskelgto.h"
#include "cmdselgtofunc.h"

COMMAND comlist[] = {
  {"status",    status,    "Read status", NULL},
  {"read",      read,      "Read parameters (for debug)", NULL},
  {"init",      init,      "Initialize all parameters to default value", NULL},
  {"eepr",      eepr,      "Load parameters from EEPROM", NULL},
  {"eepw",      eepw,      "Save current parameters to EEPROM", NULL},
  {"out0",      out0,      "Output0 select", "in0-in19, ds0-7, 1k, 10k, level, veto, none, 0xXXXXXXXX"},
  {"out1",      out1,      "Output1 select", "in0-in19, ds0-7, 1k, 10k, level, veto, none, 0xXXXXXXXX"},
  {"out2",      out2,      "Output2 select", "in0-in19, ds0-7, 1k, 10k, level, veto, none, 0xXXXXXXXX"},
  {"out3",      out3,      "Output3 select", "in0-in19, ds0-7, 1k, 10k, level, veto, none, 0xXXXXXXXX"},
  {"out4",      out4,      "Output4 select", "in0-in19, ds0-7, 1k, 10k, level, veto, none, 0xXXXXXXXX"},
  {"out5",      out5,      "Output5 select", "in0-in19, ds0-7, 1k, 10k, level, veto, none, 0xXXXXXXXX"},
  {"out6",      out6,      "Output6 select", "in0-in19, ds0-7, 1k, 10k, level, veto, none, 0xXXXXXXXX"},
  {"out7",      out7,      "Output7 select", "in0-in19, ds0-7, 1k, 10k, level, veto, none, 0xXXXXXXXX"},
  {"dssel0",    dssel0,    "Select the input source for DS0", "in0-in19, 50M"},
  {"dssel1",    dssel1,    "Select the input source for DS1", "in0-in19, 50M"},
  {"dssel2",    dssel2,    "Select the input source for DS2", "in0-in19, 50M"},
  {"dssel3",    dssel3,    "Select the input source for DS3", "in0-in19, 50M"},
  {"dssel4",    dssel4,    "Select the input source for DS4", "in0-in19, 50M"},
  {"dssel5",    dssel5,    "Select the input source for DS5", "in0-in19, 50M"},
  {"dssel6",    dssel6,    "Select the input source for DS6", "in0-in19, 50M"},
  {"dssel7",    dssel7,    "Select the input source for DS7", "in0-in19, 50M"},
  {"dsrate0",   dsrate0,   "Set downscale rate0", "0-16777215"},
  {"dsrate1",   dsrate1,   "Set downscale rate1", "0-16777215"},
  {"dsrate2",   dsrate2,   "Set downscale rate2", "0-16777215"},
  {"dsrate3",   dsrate3,   "Set downscale rate3", "0-16777215"},
  {"dsrate4",   dsrate4,   "Set downscale rate4", "0-16777215"},
  {"dsrate5",   dsrate5,   "Set downscale rate5", "0-16777215"},
  {"dsrate6",   dsrate6,   "Set downscale rate6", "0-16777215"},
  {"dsrate7",   dsrate7,   "Set downscale rate7", "0-16777215"},
  {"pulse",     pulse,     "Pulse output (8bit pattern)", "0xXX"},
  {"rst",       rst,       "Reset clock counter", NULL},
  {"test",      test,      "Test LED", "on/off"},
  {"noop",      noop,      "Dummy access to GTO", NULL},
  {"help",      help,      "Help", NULL},
  {NULL,        NULL,      NULL,   NULL} };

void quit(void){
  gto_close();
}

int main(int argc, char *argv[]){
  int i;

  if(argc < 3){
    help();
    return 0;
  }

  if(!gto_open(argv[1])){
    printf("Cannot connect %s\n", argv[1]);
    return 0;
  }

  gto_flush();

  i=0;
  while(comlist[i].com != NULL){
    if(!strcmp(comlist[i].com, argv[2])){
      if(!comlist[i].func(argv+3)){
	printf("Invalid argument %s\n\n", argv[3]);
	help();
      }
      break;
    }
    i++;
  }

  if(comlist[i].com == NULL){
    printf("Invalid function %s\n\n", argv[2]);
    help();
  }else{
    noop();
  }


  quit();

  return 0;
}
