<?php

function gtoread($hostname){
	$port = 10001;
	$errno;
	$errstr;
	$timeout = 2;
	$ret = '';
	$fp = fsockopen($hostname, $port, $errno, $errstr, $timeout);
	if(!$fp){
		$ret = "error:Can't connect to ".$hostname;
		return $ret;
	}else{
		socket_set_timeout($fp, $timeout);
		fputs($fp, '!!@@');
		$ret .= fgets($fp, 128);
		$stat = socket_get_status($fp);
		if($stat["timed_out"]){
			$ret = "error:Time out";
			return $ret;
		}
	}
	if($fp) fclose($fp);
	return "read:".$ret;
}

function gtowrite($hostname, $val){
	$port = 10001;
	$errno;
	$errstr;
	$timeout = 2;
	$ret = '';
	$fp = fsockopen($hostname, $port, $errno, $errstr, $timeout);
	if(!$fp) return "error:Can't connect to ".$hostname;

	socket_set_timeout($fp, $timeout);
	fputs($fp, $val);
	$stat = socket_get_status($fp);
	if($stat["timed_out"]){
		return "error:Time out";
	}

	if($fp) fclose($fp);
	return "noop:";
}

function gtogenread($hostname, $data){
  $port = 10001;
  $errno;
  $errstr;
  $timeout = 2;
  $ret = '';
  $fp = fsockopen($hostname, $port, $errno, $errstr, $timeout);
  if(!$fp){
    $ret = "error:Can't connect to ".$hostname;
    return $ret;
  }else{
    socket_set_timeout($fp, $timeout);
    fwrite($fp, $data, 4);
    $ret = fgets($fp, 65);
    $stat = socket_get_status($fp);
    if($stat["timed_out"]){
      $ret = "error:Time out";
      return $ret;
    }
  }
  if($fp) fclose($fp);

  return $ret;
}

function gtogenwrite($hostname, $data){
  $port = 10001;
  $errno;
  $errstr;
  $timeout = 2;
  $ret = '';
  $fp = fsockopen($hostname, $port, $errno, $errstr, $timeout);
  if(!$fp){
    $ret = "error:Can't connect to ".$hostname;
    return $ret;
  }else{
    socket_set_timeout($fp, $timeout);
    fwrite($fp, $data, 4);
    $stat = socket_get_status($fp);
    if($stat["timed_out"]){
      $ret = "error:Time out";
      return $ret;
    }
  }
  if($fp) fclose($fp);

  return $ret;
}

function gtoread2($hostname){
  $data = pack("C*", 0xc0, 0xc0, 0x00, 0x00);
  return "read:".gtogenread($hostname, $data);

}

function gtolatch2($hostname){
  $data = pack("C*", 0xc0, 0xc0, 0x00, 0x00);
  return "latch:".gtogenread($hostname, $data);
}

function gtowrite2($hostname, $addr, $val){
  $vaddr = 0x80 | $addr;
  $vval = ord($val);
  $data = pack("C*", 0xc0, 0xc0, $vaddr, $vval);
  gtogenwrite($hostname, $data);
}

function gtoeepread2($hostname){
  $data = pack("C*", 0xc0, 0xc0, 0x42, 0x00);
  gtogenwrite($hostname, $data);
  usleep(100000);
}

function gtoeepwrite2($hostname){
  $data = pack("C*", 0xc0, 0xc0, 0x60, 0x00);
  gtogenwrite($hostname, $data);
  usleep(100000);
}

?>
