/* v288.c
   from V288 User Manual

   July 8, 2002  H.Baba
*/
#include <unistd.h>

#include "nbbqvio.h"
#include "v288.h"


void v288_reset(void){
  vme_write16(v288addr+RESET,1);
}

int v288_read_data(unsigned short *datovme)
{
  ushort q=1;
  vme_read(v288addr,datovme);
  vme_read(v288addr+STATUS,&q);
  return((q == Q) ? TUTTOK : TIMEOUT);
}

/***---------------------------------------------------------------------
  Wait_resp
   ------------------------------------------------------------------***/
int v288_wait_resp(unsigned short *datovme)
{
  int i=0;
  ushort q=1;
  while(i!=TIMEOUT && q!=Q)
    {
      vme_read(v288addr,datovme);
      vme_read(v288addr+STATUS,&q);
      i++;
      usleep(1);
    }
  return((i == TIMEOUT) ? TIMEOUT : TUTTOK);
}

/***---------------------------------------------------------------------
  Send_comm
    -----------------------------------------------------------------***/
int v288_send_comm(unsigned long addr,unsigned short datovme)
{
  int i=0;
  ushort q=1;
  while(i!=TIMEOUT && q!=Q){
    if(!vme_write(addr,&datovme)){
      return E_BUSERR;
    }
    vme_read(v288addr+STATUS,&q);
    i++;
  }
  return((i == TIMEOUT) ? TIMEOUT : TUTTOK);
}

/***---------------------------------------------------------------------
  Caenet_read: Called by user programs to load "byte_count" bytes from
               CAENET into the buffer pointed by "*dest_buff".
               The VME address of V288, the CAENET crate number and the
               CAENET code are found in global variables.
               Caenet_read returns TUTTOK = 0 if everything has worked;
               It returns one from seven different errors (defined as
               positive constants in Vmcaenet.h) if it has received one
               error which strictly depends from V288 Module;
               It returns a negative error (depending from the CAENET slave
               module) if the CAENET communication has not worked.
     Remember: Module V288 can return three "general" negative errors
               related to the CAENET network that this routine does not
               handle separately from the "slave specific" ones.
 --------------------------------------------------------------------***/
int v288_caenet_read(unsigned short *dest_buff,int byte_count,
		unsigned short code, unsigned int craten)
{
  int i,esito;
  ushort mstident=V288,datatemp;
  short dato;

  if((esito=v288_send_comm(v288addr,mstident)) == TIMEOUT)
    return E_NO_Q_IDENT;
  else if(esito == E_BUSERR)
    return esito;
  /* Transmit Crate Number */
  if((esito=v288_send_comm(v288addr,(ushort)craten)) == TIMEOUT)
    return E_NO_Q_CRATE;
  else if(esito == E_BUSERR)
    return esito;
  /* Transmit Code       */
  if((esito=v288_send_comm(v288addr,(ushort)code)) == TIMEOUT)
    return E_NO_Q_CODE;
  else if(esito == E_BUSERR)
    return esito;
  /* Start Transmission        */
  if((esito=v288_send_comm(v288addr+TXMIT,mstident)) == TIMEOUT)
    return E_NO_Q_TX;
  else if(esito == E_BUSERR)
    return esito;
  if(v288_wait_resp(&dato) == TIMEOUT)
    return E_NO_Q_RX;
  if(dato == TUTTOK)                       /* Test on the operation     */
    for(i=0;i<byte_count;i++)
      {
	if(v288_read_data(&datatemp) == TIMEOUT && i<byte_count-1)
          return E_LESSDATA;
	dest_buff[i]   = datatemp;
#ifdef DEBUG
	printf("data : %c\n",datatemp);
#endif
      }
  return dato;
}

/***---------------------------------------------------------------------
 Caenet_write: Called by user programs to transfer "byte_count" bytes to
               CAENET from the buffer pointed by "*source_buff".
               The VME address of V288, the CAENET crate number and the
               CAENET code are found in global variables.
               Caenet_write returns TUTTOK = 0 if everything has worked;
               It returns one from seven different errors (defined as
               positive constants in Vmcaenet.h) if it has received one
               error which strictly depends from V288 Module;
               It returns a negative error (depending from the CAENET slave
               module) if the CAENET communication has not worked.
     Remember: Module V288 can return three "general" negative errors
               related to the CAENET network that this routine does not
               handle separately from the "slave specific" ones.
 --------------------------------------------------------------------***/
int v288_caenet_write(unsigned short *source_buff,
		 int byte_count, unsigned short code, unsigned int craten)
{
  int i,esito;
  ushort mstident=V288,datatemp;
  short dato;
  if((esito=v288_send_comm(v288addr,mstident)) == TIMEOUT)
    return E_NO_Q_IDENT;
  else if(esito == E_BUSERR)
    return esito;
  /* Transmit Crate Number */
  if((esito=v288_send_comm(v288addr,(ushort)craten)) == TIMEOUT)
    return E_NO_Q_CRATE;
  else if(esito == E_BUSERR)
    return esito;
  /* Transmit Code       */
  if((esito=v288_send_comm(v288addr,(ushort)code)) == TIMEOUT)
    return E_NO_Q_CODE;
  else if(esito == E_BUSERR)
    return esito;
  /* Transmit data       */
  for(i=0;i<byte_count;i++)
    {
      datatemp=source_buff[i];
      if((esito=v288_send_comm(v288addr,datatemp)) == TIMEOUT)
	return E_NO_Q_DATA;
      else if(esito == E_BUSERR)
	return esito;
    }
  /* Start transmission                 */
  if((esito=v288_send_comm(v288addr+TXMIT,mstident)) == TIMEOUT)
    return E_NO_Q_TX;
  else if(esito == E_BUSERR)
    return esito;
  if(v288_wait_resp(&dato) == TIMEOUT)
    return E_NO_Q_RX;
  return dato;
}

int v288_init(unsigned long addr){

  if(init_nbbqvio() < 0){
    return -1;
  }

  vme_amsr(A24);
  v288addr = addr;
  v288_reset();

  return 0;
}

int v288_release(void){
  vme_amsr(A32);
  release_nbbqvio();

  return 0;
}
