/* sy403.h
   Jul 16, 2002  H.Baba
*/

/* code */
#define IDENT           0x0000
#define READ_STATUS     0x0001
#define READ_PARAMETER  0x0002
#define READ_CHARACTER  0x0003
#define SET_V0          0x0010
#define SET_V1          0x0011
#define SET_I0          0x0012
#define SET_I1          0x0013
#define SET_VMAX        0x0014
#define SET_RAMPUP      0x0015
#define SET_RAMPDOWN    0x0016
#define SET_TRIP        0x0017
#define SET_FLAGS       0x0018
#define SET_NAME        0x0019
#define READ_BUSY       0x00ff

/* size */
#define IDENT_SIZE      12
#define STATUS_SIZE     4
#define PARAM_SIZE      17
#define CHAR_SIZE       24
#define BUSY_SIZE       1
#define NAME_SIZE       6

/* value */
#define VMAX            3000
#define IMAX            3000
#define RAMOMAX         999
#define TRIPMAX         1000
#define HV_OFF_VAL      0x0800
#define HV_ON_VAL       0x0808

#define MAKE_CODE(ch,cod) (((ch)<<8) | (cod))

#define   TUTTOK                                   0
#define   E_NO_Q_IDENT                             1
#define   E_NO_Q_CRATE                             2
#define   E_NO_Q_CODE                              3
#define   E_NO_Q_DATA                              4
#define   E_NO_Q_TX                                5
#define   E_NO_Q_RX                                6
#define   E_LESSDATA                               7
#define   E_BUSERR                                 8

char sy403_ident[IDENT_SIZE];

extern void v288_reset(void);
extern int v288_caenet_read(unsigned short *dest_buff,int byte_count,
                            unsigned short code, unsigned int craten);
extern int v288_caenet_write(unsigned short *source_buff, int byte_count,
                             unsigned short code, unsigned int craten);
