/* sy403.c
   Jul 16, 2002  H.Baba
*/

#include <stdio.h>
#include <string.h>

#include "sy403.h"

char *sy403_read_ident(char sy403_indent[IDENT_SIZE],unsigned int craten){
  int res,i;
  unsigned short tmpbuff[IDENT_SIZE];

  if((res=v288_caenet_read(tmpbuff,IDENT_SIZE,IDENT,craten)) 
     != TUTTOK && res != E_LESSDATA){
    printf(" Caenet_read: Error number %d received\n",res);
    return 0;
  }

  for(i=0;i<IDENT_SIZE-1;i++){
    sy403_ident[i] = (char)(tmpbuff[i] & 0x0000ffff);
  }
  sy403_ident[16] = '\0';

  return sy403_ident;
}

int sy403_read_param(unsigned short mode,unsigned short ch,unsigned short *val,
	       int size, unsigned int craten){
  int res;

  if((res=v288_caenet_read(val,size,MAKE_CODE(ch,mode),craten))
     != TUTTOK && res != E_LESSDATA){
    printf(" Caenet_read: Error number %d received\n",res);
    return 0;
  }
  
  return res;
}


int sy403_write_param(unsigned short mode,unsigned short ch,unsigned short val,
		unsigned int craten){
  int res;

  if((res=v288_caenet_write(&val,1,MAKE_CODE(ch,mode),craten)) != TUTTOK){
    printf(" Caenet_write: Error number %d received\n",res);
  }

  return res;
}

int sy403_write_nparam(unsigned short mode,unsigned short ch,
		       unsigned short *val,int size,unsigned int craten){
  int res;

  if((res=v288_caenet_write(val,size,MAKE_CODE(ch,mode),craten)) != TUTTOK){
    printf(" Caenet_write: Error number %d received\n",res);
  }

  return res;
}

int sy403_set_param(unsigned short mode,unsigned short ch, unsigned int craten){
  int res;
  unsigned short val;

  val = 0;

  if((res=v288_caenet_write(&val,0,MAKE_CODE(ch,mode),craten)) != TUTTOK){
    printf(" Caenet_write: Error number %d received\n",res);
  }

  return res;
}

int sy403_set_name(int ch,char name[12],int craten){
   unsigned short nbuff[6];
   int i;
   memset(nbuff,0,sizeof(nbuff));
   for(i=0;i<12;i+=2)
     {
	nbuff[i/2] = name[i]<<8 | name[i+1];
     }
   
      return sy403_write_nparam(SET_NAME,ch,nbuff,NAME_SIZE,craten);
}

int sy403_set_v0(int ch,unsigned short val,int craten){
  return sy403_write_param(SET_V0,ch,val,craten);
}

int sy403_set_vmax(int ch,unsigned short val,int craten){
  return sy403_write_param(SET_VMAX,ch,val,craten);
}

int sy403_hv_off(int ch, int craten)
{
   return sy403_write_param(SET_FLAGS,ch,HV_OFF_VAL,craten);
}

int sy403_hv_on(int ch, int craten)
{
   return sy403_write_param(SET_FLAGS,ch,HV_ON_VAL,craten);
}
