#include <stdio.h>
#include <readline/readline.h>
#include <readline/history.h>

#include "bbcpri.h"

typedef struct{
  char *name;
  Function *func;
  char *doc;
}COMMAND;

extern COMMAND commands[];

COMMAND *find_command();

int execute_line (char *line){
  register int i;
  COMMAND *command;
  char *word;

  cl_cur_end();

  i = 0;
  while (line[i] && whitespace (line[i]))
    i++;
  word = line + i;

  while (line[i] && !whitespace (line[i]))
    i++;

  if (line[i])
    line[i++] = '\0';

  command = find_command (word);

  if (!command)
    {
      cl_cur_end();
      fprintf (stderr, "%s: No such command.\n", word);
      return (-1);
    }

  while (whitespace (line[i]))
    i++;

  word = line + i;

  return ((*(command->func)) (word));
}

COMMAND *find_command (char *name){
  register int i;

  for (i = 0; commands[i].name; i++)
    if (strcmp (name, commands[i].name) == 0)
      return (&commands[i]);

  return ((COMMAND *)NULL);
}

char *stripwhite (char *string){
  register char *s, *t;

  for(s = string; whitespace (*s); s++);
    
  if (*s == 0)
    return (s);

  t = s + strlen (s) - 1;
  while (t > s && whitespace (*t))
    t--;
  *++t = '\0';

  return s;
}

int tab2space(char *buff){
  int i;
  for(i=0;i<strlen(buff);i++){
    if(buff[i] == '\t'){
      buff[i] = ' ';
    }
  }

  return 0;
}
