/* n568b.h
   Nov 27, 2001  H.Baba
*/

#define IDENT            0x0000
#define READ_ALL_PARAM   0x0001
#define READ_OFFSET      0x0002
#define READ_PARAM       0x0003
#define READ_MUX         0x0004
#define WRITE_FINE       0x0010
#define WRITE_COARSE     0x0011
#define WRITE_POLEZERO   0x0012
#define WRITE_SHAPE      0x0013
#define WRITE_POLARITY   0x0014
#define WRITE_CONFIG     0x0015
#define WRITE_OFFSET     0x0016
#define DISABLE_MULTI    0x0020
#define ENABLE_MULTI     0x0021

#define IDENT_SIZE       16
#define ALL_PARAM_SIZE   50
#define OFFSET_SIZE      1
#define PARAM_SIZE       3
#define MUX_SIZE         1

#define FINE_MASK        0x00ff
#define COARSE_MASK      0x0007
#define POLEZERO_MASK    0x00ff
#define SHAPE_MASK       0x0003
#define POLARITY_MASK    0x0001
#define CONFIG_MASK      0x0001
#define OFFSET_MASK      0x00ff
#define MUX_MASK         0x0001

#define MAKE_CODE(ch,cod) (((ch)<<8) | (cod))

#define   TUTTOK                                   0
#define   E_NO_Q_IDENT                             1
#define   E_NO_Q_CRATE                             2
#define   E_NO_Q_CODE                              3
#define   E_NO_Q_DATA                              4
#define   E_NO_Q_TX                                5
#define   E_NO_Q_RX                                6
#define   E_LESSDATA                               7
#define   E_BUSERR                                 8

char n568b_ident[IDENT_SIZE];

extern void v288_reset(void);
extern int v288_caenet_read(unsigned short *dest_buff,int byte_count,
			    unsigned short code, unsigned int craten);
extern int v288_caenet_write(unsigned short *source_buff, int byte_count,
			     unsigned short code, unsigned int craten);
