/* n568b.c
   Dec 4, 2001  H.Baba
*/

#include <stdio.h>
#include <string.h>

#include "n568b.h"

char *n568b_read_ident(char n568b_indent[IDENT_SIZE],unsigned int craten){
  int res,i;
  unsigned short tmpbuff[IDENT_SIZE];

  if((res=v288_caenet_read(tmpbuff,IDENT_SIZE,IDENT,craten)) 
     != TUTTOK && res != E_LESSDATA){
    printf(" Caenet_read: Error number %d received\n",res);
    return 0;
  }

  for(i=0;i<IDENT_SIZE-1;i++){
    n568b_ident[i] = (char)(tmpbuff[i] & 0x0000ffff);
  }
  n568b_ident[16] = '\0';

  return n568b_ident;
}

unsigned short *n568b_read_all_param(unsigned short *val, unsigned int craten){
  int res;

  if((res=v288_caenet_read(val,ALL_PARAM_SIZE,READ_ALL_PARAM,craten))
     != TUTTOK && res != E_LESSDATA){
    printf(" Caenet_read: Error number %d received\n",res);
    return 0;
  }
  
  return val;
}

int n568b_read_param(unsigned short mode,unsigned short ch,unsigned short *val,
	       int size, unsigned int craten){
  int res;

  if((res=v288_caenet_read(val,size,MAKE_CODE(ch,mode),craten))
     != TUTTOK && res != E_LESSDATA){
    printf(" Caenet_read: Error number %d received\n",res);
    return 0;
  }
  
  return res;
}


int n568b_write_param(unsigned short mode,unsigned short ch,unsigned short val,
		unsigned int craten){
  int res;

  if((res=v288_caenet_write(&val,1,MAKE_CODE(ch,mode),craten)) != TUTTOK){
    printf(" Caenet_write: Error number %d received\n",res);
  }

  return res;
}

int n568b_set_param(unsigned short mode,unsigned short ch, unsigned int craten){
  int res;
  unsigned short val;

  val = 0;

  if((res=v288_caenet_write(&val,0,MAKE_CODE(ch,mode),craten)) != TUTTOK){
    printf(" Caenet_write: Error number %d received\n",res);
  }

  return res;
}

int n568b_set_common(unsigned short offset,short mux,
		     unsigned int craten)
{
   n568b_write_param(WRITE_OFFSET,0,offset,craten);
   if(mux > 0)
     {
	n568b_set_param(ENABLE_MULTI,0,craten);
     }else
     {
	n568b_set_param(DISABLE_MULTI,0,craten);
     }
   
   return 0;
}


int n568b_set_all_param(unsigned short ch,unsigned short fine,
			unsigned short coa,unsigned short pole,
			unsigned short shape,unsigned short pola,
			unsigned short config,unsigned int craten)
{
   n568b_write_param(WRITE_FINE,ch,fine,craten);
   n568b_write_param(WRITE_COARSE,ch,coa,craten);
   n568b_write_param(WRITE_POLEZERO,ch,pole,craten);
   n568b_write_param(WRITE_SHAPE,ch,shape,craten);
   n568b_write_param(WRITE_POLARITY,ch,pola,craten);
   n568b_write_param(WRITE_CONFIG,ch,config,craten);

   return 0;
}

