/* cmdsa
   Console base CAEN N568b Controller with CAENET
*/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <ctype.h>
#include <math.h>
#include <termcap.h>
#include <ncurses.h>
#include <readline/readline.h>
#include <readline/history.h>

#include "cmdsa.h"
#include "bbcpri.h"
#include "cmdsa_com.h"
#include "cmdsa_com.c"

#define VER  "1.1"
#define AUTH "July 17, 2002  H.Baba"

extern int execute_line(char *line);
extern char *stripwhite(char *string);
extern int tab2space(char *buff);

unsigned long addr;
unsigned int craten,code;

char *line,*com;
char termtype[256],term_buffer[2048];
char muxstr[15];

int col,row,comx,comy,comxi;
int staty,pagen,pagef,pagec;
int nch = 16;
int mdflag;

char n568b_sig[] = "N568",
  shpstr[4][4] = {"0.2\0","1\0","3\0","6\0"},
  postr[2][9] = {"Pos.\0","Neg.\0"},
    costr[2][9] = {"Direct\0","Invert\0"};

char module_header[] = {
  "# N568b  CAENET Addr    Mux(   )   Offset(   )"};

char param_header[] = {
  "# Ch  Fine   Coarse    Pole-Zelo       Shaping    Pola.  Config."};
//"# 14   33    2(x4) 50(50.25us)  3(6us)   Pos   Direc.
// 1234567890123456789012345678901234567890

char tmpstr[256];
unsigned short val[256],offval,muxval;
double pole_step = 450./50.;

void quit(void){
  printf("Exit cmdsa.\n");
  v288_release();
  exit(0);
}

int isnums(char *tline)
{
   int ncol,i;
   ncol = strlen(tline);
   for(i=0;i<ncol;i++)
     {
	if(!isdigit(tline[i]))
	  {
	     if(tline[i] != '\n')
	       {
		  return 0;
	       }
	     
	  }
	
     }
   if(ncol == 0)
     {
	return 0;
     }
   
   return 1;
}


void print_warn(void)
{
   printf("You must select station number.\n");
}


void print_header(void){
  memset(muxstr,0,sizeof(muxstr));

   if((muxval&0x0080) != 0){
    sprintf(muxstr,"Enable ch=%02d",muxval&0x000f);
  }else{
    sprintf(muxstr,"Disable");
  }

 printf("# N568b  CAENET n=%02d  MUX(%12s)  Offset(%3d)\n",craten,muxstr,
	 offval);
}

void print_param_header(void)
{
  printf("%s\n",param_header);
}


void print_param(int ch,int of){
  printf("  %02d   %3d  %2d(x%2d)  %3d(%7.2f us)  %2d(%3s us)   %4s  %6s\n",
	 ch,val[of],val[of+2]&0x0007,(int)pow(2,(val[of+2]&0x0007)),
	 val[of+1],50.+val[of+1]*pole_step,(val[of+2]&0x0018)>>3,
	 shpstr[(val[of+2]&0x0018)>>3],postr[(val[of+2]>>6)&0x01],
	 costr[(val[of+2]>>5)&0x01]);
}

void make_menu(void){
  printf("\n\n");
  printf("---------------------------------------------------------------\n");
  printf(" cmdsa  %s         %s\n",VER,AUTH);
  printf(" Command line controller for 16 Channel Spectroscopy Amplifier\n");
  printf("---------------------------------------------------------------\n");
  printf("\n\n");
}

int select_n(void){
  char *tline;

  tline = readline("CAENET n (1-255) : ");
  craten = (unsigned short)strtoul(tline,NULL,0);
  if(craten < 1 || craten > 255){
    printf("1 < n < 255\n");
    return -1;
  }
  free(tline);

  n568b_read_ident(n568b_ident,craten);

  if(strncmp(n568b_ident,n568b_sig,4) != 0){
    printf("Invalid Station Number %d",craten);
    return -1;
  }else{
    printf("Identifier %s\n",n568b_ident);
     mdflag = 1;
     read_param();
     return 1;
  }
}

int read_param(void){
  int i;

   if(mdflag < 0)
     {
	print_warn();
	return -1;
     }

   n568b_read_all_param(val,craten);
  n568b_read_param(READ_OFFSET,0,&offval,OFFSET_SIZE,craten);
  n568b_read_param(READ_MUX,0,&muxval,MUX_SIZE,craten);

   mv_cur(0,0);
   cl_line();
   print_header();
   print_param_header();
   for(i=0;i<16;i++){
    print_param(i,i*3);
  }
   return 1;
}

int read_wch(void){
  int ret=-1;
  char *wcline;

   /* mv_cur(comy,comx); */
  cl_line();
  wcline = readline("Channel [0-15]/[16=Common] : ");
   if(isnums(wcline))
     {
	ret = strtol(wcline,NULL,0);
	if(ret < 0 || ret > 16){
	   ret = -1;
	}
     }
   free(wcline);

  return ret;
}

int write_param(void){
  short ch;
  unsigned short sval;
  char *tline,mm;

   if(mdflag < 0)
     {
	print_warn();
	return -1;
     }
   
   
  ch = 0;

  printf("Fine[f] Coarse[c] Pole Zelo[z] Shaping[s] Polarity[p]\n");
  tline = readline("Config[g] Offset[o] Mux Status[m] Quit[q] : ");
  memcpy(&mm,tline,1);
  free(tline);

  switch(mm){
  case 'f':
    if((ch = read_wch()) != -1){
      tline = readline("Fine Gain Value [0-255]: ");
     if(isnums(tline))
       {
	  sval = strtol(tline,NULL,0);
	if(sval <= FINE_MASK){
	  n568b_write_param(WRITE_FINE,ch,sval,craten);
	}else{
	  printf("Invalid Value.\n");
	}
      }
     free(tline);
    }else{
      printf("Invalid channel.\n");
    }
    break;
  case 'c':
    if((ch = read_wch()) != -1){
      tline = readline("Coarse Gain Value x2^[0-7]: ");
     if(isnums(tline))
       {
	  sval = strtol(tline,NULL,0);
	if(sval <= COARSE_MASK){
	  n568b_write_param(WRITE_COARSE,ch,sval,craten);
	}else{
	  printf("Invalid Value.\n");
	}
      }
     free(tline);
    }else{
      printf("Invalid channel.\n");
    }
    break;
  case 'z':
    if((ch = read_wch()) != -1){
      tline = readline("Pole Zero Value [0-255]=(50-500us) : ");
     if(isnums(tline))
       {
	  sval = strtol(tline,NULL,0);
	if(sval <= POLEZERO_MASK){
	  n568b_write_param(WRITE_POLEZERO,ch,sval,craten);
	}else{
	  printf("Invalid Value.\n");
	}
      }
     free(tline);
    }else{
      printf("Invalid channel.\n");
    }
    break;
  case 's':
    if((ch = read_wch()) != -1){
      tline = readline("Shaping Time Value [0-3]=(0.2,1,3,6 us) : ");
     if(isnums(tline))
       {
	  sval = strtol(tline,NULL,0);
	if(sval <= SHAPE_MASK){
	  n568b_write_param(WRITE_SHAPE,ch,sval,craten);
	}else{
	  printf("Invalid Value.\n");
	}
      }
     free(tline);
    }else{
      printf("Invalid channel.\n");
    }
    break;
  case 'p':
    if((ch = read_wch()) != -1){
      tline = readline("Output Polarity Value [0/1]=(Pos,Neg) : ");
     if(isnums(tline))
       {
	  sval = strtol(tline,NULL,0);
	if(sval <= POLARITY_MASK){
	  n568b_write_param(WRITE_POLARITY,ch,sval,craten);
	}else{
	  printf("Invalid Value.\n");
	}
      }
     free(tline);
    }else{
      printf("Invalid channel.\n");
    }
    break;
  case 'g':
    if((ch = read_wch()) != -1){
      tline = readline("Output Configuration Value [0/1]=(Direct,Invert) : ");
     if(isnums(tline))
       {
	  sval = strtol(tline,NULL,0);
	if(sval <= CONFIG_MASK){
	  n568b_write_param(WRITE_CONFIG,ch,sval,craten);
	}else{
	  printf("Invalid Value.\n");
	}
      }
       free(tline);
    }else{
      printf("Invalid channel.\n");
    }
    break;
  case 'o':
    tline = readline("Offset Value [0-255] (Common) : ");
     if(isnums(tline))
       {
	  sval = strtol(tline,NULL,0);
      if(sval <= OFFSET_MASK){
	n568b_write_param(WRITE_OFFSET,ch,sval,craten);
      }else{
	printf("Invalid Value.\n");
      }
    }
     free(tline);
    break;
  case 'm':
    tline = readline("MUX Status [0/1] (Enable,Disable) : ");

     if(isnums(tline))
       {
	  sval = strtol(tline,NULL,0);
      if(sval <= MUX_MASK){
	if(sval == 0){
	  n568b_set_param(ENABLE_MULTI,0,craten);
	}else{
	  n568b_set_param(DISABLE_MULTI,0,craten);
	}
      }else{
	printf("Invalid Value.\n");
      }
    }

     free(tline);
    break;
  case 'q':
    break;
  }

   cl_screen();
   read_param();
   
   return 1;
}


void get_terminfo(void){
  tgetent(term_buffer,termtype);
  row = tgetnum("li");
  col = tgetnum("co");

  comx = 0;
  comy = row - 3;
  comxi = 8;
  staty = comy - 1;
  pagen = nch/staty;
  if(nch%staty != 0){
    pagen++;
  }
  pagef = 1;
  pagec = 0;
}

int read_file(char *arg)
{
   
   FILE *fd;
   char buff[256], *ll;
   unsigned short tch,tfine,tcoa,tpole,tshape,tpola,tconfig,toffset;
     int tmux,tcraten,crateflag;

   craten = 0;
   crateflag = -1;
   
   if((fd = fopen(arg,"r")) == NULL)
     {
	printf("Can't open %s.\n",arg);
	return -1;
     }
   
   while(!feof(fd))
     {
	fgets(buff,sizeof(buff),fd);
	tab2space(buff);
	ll = stripwhite(buff);
	if(ll[0] == '#')
	  {
	     if(sscanf(ll+1,"%d %d %i",&tcraten,&tmux,(int *)&toffset) != 3)
	       {
		  printf("Error in file for station number\n");
	       }
	     craten = tcraten;
	     n568b_read_ident(n568b_ident,craten);
	     if(strncmp(n568b_ident,n568b_sig,4) != 0){
		printf("Invalid Station Number %d",craten);
		break;
	     }else{
		printf("N=%d Identifier %s\n",craten,n568b_ident);
		n568b_set_common(toffset,tmux,craten);
		crateflag = 1;
	     }
	  }
	else if(strncmp(ll,"\n",1) == 0 || strlen(ll) < 13)
	  {
	  }
	else if(ll[0] == 'c')
	  {
	  }
	
	else
	  {
	     if(crateflag < 0)
	       {
		  printf("Set station value\n");
		  break;
	       }
	     else
	       {
		  if(sscanf(ll,"%i %i %i %i %i %i %i",
			    (int *)&tch,(int *)&tfine,(int *)&tcoa,
			    (int *)&tpole,(int *)&tshape,(int *)&tpola,
			    (int *)&tconfig) != 7)
		    {
		       printf("Error in file\n");
		       break;
		    }
		  n568b_set_all_param(tch,tfine,tcoa,tpole,tshape,tpola,
				      tconfig,craten);
	       }
	  }
     }
   
   fclose(fd);

   read_param();
   
   return 0;
}


int main(int argc,char *argv[]){
  int ret;
  struct sigaction sa,osa;

  strcpy(termtype,getenv("TERM"));

  if(termtype == 0){
    printf("Can't get terminal type.\n");
    exit(0);
  }
  ret = tgetent(term_buffer,termtype);
  if(ret < 0){
    printf("Can't access the termcap data base.\n");
    exit(0);
  }else if(ret == 0){
    printf("Terminal type `%s' is not define.\n",termtype);
    exit(0);
  }

  get_terminfo();
  sa.sa_handler = (void *)get_terminfo;
  sa.sa_flags = 0;
  sigaction(SIGWINCH,&sa,&osa);
  cl_screen();


  signal(SIGINT,(void *)quit);

  memset(tmpstr,0,sizeof(tmpstr));
  memset(val,0,sizeof(val));

  if(argc == 2){
    addr = strtol(argv[1],NULL,0);
  }else{
    addr = 0x800000;
  }
  v288_init(addr);
  mdflag = -1;
   
  get_terminfo();
  /* signal(SIGALRM,(void *)com_getall); */
  //com_help();
  printf("\n");
  mv_cur(5,5);
  printf("Select station number of N568b S.A.\n");
   
  while(1){
    mv_cur(comy,comx);
    cl_line();
    line = readline("CMDSA : ");
    if(!line){
      break;
    }
    com = stripwhite(line);

     if(*com){
      add_history(com);
      execute_line(com);
    }
     free(line);
  }

  quit();

  return 0;
}
