/* cmdhv.h
   Jul16 2002,  H.Baba
*/

#define A503
/* #define A504 */

#define HVPAGE 16

struct sy403_status{
  char name[12];
  int ch;
  int craten;
  int vover;  /* 0:none, -1:under, 1:over */
  int iover;  /* 0:noen,  1:over */
  int updown; /* 0:none, -1:down , 1:up */
  int onoff;  /* 0:off, 1:on */
  unsigned int vmon;
  unsigned short imon;
  unsigned int v0set;
  unsigned int v1set;
  unsigned short i0set;
  unsigned short i1set;
  unsigned short vmax;
  unsigned short rup;
  unsigned short rdwn;
  unsigned short trip;
  unsigned short flag;
};

struct sy403_status hvstat[10][64];
float v0unit = 10.0;
float v1unit = 10.0;
float tripunit = 10.0;


/* code */
#define IDENT           0x0000
#define READ_STATUS     0x0001
#define READ_PARAMETER  0x0002
#define READ_CHARACTER  0x0003
#define SET_V0          0x0010
#define SET_V1          0x0011
#define SET_I0          0x0012
#define SET_I1          0x0013
#define SET_VMAX        0x0014
#define SET_RAMPUP      0x0015
#define SET_RAMPDOWN    0x0016
#define SET_TRIP        0x0017
#define SET_FLAGS       0x0018
#define SET_NAME        0x0019
#define READ_BUSY       0x00ff

/* size */
#define IDENT_SIZE      11
#define STATUS_SIZE     4
#define PARAM_SIZE      17
#define CHAR_SIZE       24
#define BUSY_SIZE       1

/* val */
#define HV_OFF_VAL      0x0800

/* value */
#define VMAX            3000
#define IMAX            3000
#define RAMPMAX         999
#define TRIPMAX         1000

char sy403_ident[IDENT_SIZE];

extern void v288_reset(void);
extern int v288_caenet_read(unsigned short *dest_buff,int byte_count,
                            unsigned short code, unsigned int craten);
extern int v288_caenet_write(unsigned short *source_buff, int byte_count,
                             unsigned short code, unsigned int craten);
/* v288 */
extern int v288_init(unsigned long addr);
extern int v288_release(void);

/* sy403 */
extern char *sy403_read_ident(char *sy403_indent,
			      unsigned int craten);
extern int sy403_read_param(unsigned short mode,unsigned short ch,
			    unsigned short *val,int size, unsigned int craten);
extern int sy403_write_param(unsigned short mode,unsigned short ch,
			     unsigned short val,unsigned int craten);
extern int sy403_write_nparam(unsigned short mode,unsigned short ch,
			     unsigned short *val,int size,unsigned int craten);
extern int sy403_set_param(unsigned short mode,unsigned short ch,
			   unsigned int craten);
extern int sy403_set_name(int ch,char name[12],int craten);
extern int sy403_set_v0(int ch,unsigned short val,int craten);
extern int sy403_hv_off(int ch, int craten);
extern int sy403_hv_on(int ch, int craten);

