/* cmdhv
   Console base CAEN SY403 Controller with CAENET
*/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <math.h>
#include <termcap.h>
#include <ncurses.h>
#include <readline/readline.h>
#include <readline/history.h>

#include "cmdhv.h"
#include "bbcpri.h"
#include "cmdhv_com.h"
#include "cmdhv_com.c"

#define VER  "1.0"
#define AUTH "July 16, 2002  H.Baba"

extern int execute_line(char *line);
extern char *stripwhite(char *string);
extern int tab2space(char *buff);

int read_all_param();

unsigned long addr;
unsigned int craten,code;

char *line,*com;
char termtype[256],term_buffer[2048];

int col,row,comx,comy,comxi;
int staty,pagen,pagef,pagec,pagep;
int nch = 64;
int mdflag;

char sy403_sig[] = "SY403";

char status_header[] = {
  "Channel       Vmon     Imon    HVmax   V0set     I0set     HV   Status  Ch"};

char tmpstr[256];
unsigned short val[256],offval,muxval;

char ofstr[2][4] = {"Off\0","On\0\0"};
char ststr[3][5] = {"    \0","Down\0","Up\0\0\0"};

void quit(void){
  printf("Exit cmdhv.\n");
  v288_release();
  exit(0);
}

void init_status(void){
  int i,j;
  for(i=0;i<10;i++){
    for(j=0;j<64;j++){
      memset(hvstat[i][j].name,0,sizeof(hvstat[i][j].name));
      hvstat[i][j].ch = j;
      hvstat[i][j].craten = i;
      hvstat[i][j].vover = 0;
      hvstat[i][j].iover = 0;
      hvstat[i][j].updown = 0;
      hvstat[i][j].onoff = 0;
    }
  }
}

void print_warn(void){
  printf("You must select crate number.\n");
}

void print_header(int page){
  cl_screen();
  printf("Crate %02d        Page %02d\n",craten,page+1);
  printf("%s\n",status_header);
}

void print_status(int page){
  int i;
  for(i=pagep*page;i<pagep+pagep*page;i++){
    printf("%12s %06.2f  %06d  %04d   %06.2f   %06d   %3s   %7s  %02d\n",
	   hvstat[craten][i].name,hvstat[craten][i].vmon/v0unit,
	   hvstat[craten][i].imon,hvstat[craten][i].vmax,
	   hvstat[craten][i].v0set/v0unit,hvstat[craten][i].i0set,
	   ofstr[hvstat[craten][i].onoff],ststr[hvstat[craten][i].updown],
	   hvstat[craten][i].ch);
  }
}

void make_menu(void){
  printf("\n\n");
  printf("---------------------------------------------------------------\n");
  printf(" cmdsa  %s         %s\n",VER,AUTH);
  printf(" Command line controller for CAEN H.V. SYSTEM\n");
  printf("---------------------------------------------------------------\n");
  printf("\n\n");
}

int select_n(void){
  char *tline;

  tline = readline("CAENET n (1-9) : ");
  craten = (unsigned short)strtoul(tline,NULL,0);
  if(craten < 1 || craten > 9){
    printf("1 < n < 9\n");
    return -1;
  }
  free(tline);

  sy403_read_ident(sy403_ident,craten);

  if(strncmp(sy403_ident,sy403_sig,4) != 0){
    printf("Invalid Station Number %d",craten);
    return -1;
  }else{
    printf("Identifier %s\n",sy403_ident);
     mdflag = 1;
     read_all_param();
     return 1;
  }
}

void store_param(int cr, int ch, unsigned short v[256]){
  memcpy(hvstat[cr][ch].name,(char *)v,8);
  hvstat[cr][ch].v0set = v[6]<<16 | v[7];
  hvstat[cr][ch].v1set = v[8]<<16 | v[9];
  hvstat[cr][ch].i0set = v[10];
  hvstat[cr][ch].i1set = v[11];
  hvstat[cr][ch].vmax = v[12];
  hvstat[cr][ch].rup = v[13];
  hvstat[cr][ch].rdwn = v[14];
  hvstat[cr][ch].trip = v[15];
  hvstat[cr][ch].flag = v[16];
}

void store_status(int cr, int ch, unsigned short v[256]){
  hvstat[cr][ch].vmon = v[0]<<16 | v[1];
  hvstat[cr][ch].imon = v[2];
  if((v[3] & 0x0200) > 0){
    hvstat[cr][ch].trip = 1;
  }else{
    hvstat[cr][ch].trip = 0;
  }
  if((v[3] & 0x0800) > 0){
    hvstat[cr][ch].vover = 1;
  }else{
    hvstat[cr][ch].vover = 0;
  }
  if((v[3] & 0x1000) > 0){
    hvstat[cr][ch].iover = 1;
  }else{
    hvstat[cr][ch].iover = 0;
  }
  if((v[3] & 0x4000) > 0){
    hvstat[cr][ch].updown = 2;
  }
   if((v[3] & 0x2000) > 0)
     {
	
    hvstat[cr][ch].updown = 1;
  }
   if((v[3] & 0x8000) > 0)
     {
	hvstat[cr][ch].onoff = 1;
     }
   else
     {
	hvstat[cr][ch].onoff = 0;
     }


}

int read_all_param(void){
  int i;

  if(mdflag < 0){
    print_warn();
    return -1;
  }

  for(i=0;i<nch;i++){
    memset(val,0,sizeof(val));
    sy403_read_param(READ_PARAMETER,i,val,PARAM_SIZE,craten);
    store_param(craten,i,val);
  }

   printf("%x\n",hvstat[craten][3].flag);
   
  return 1;
}

int read_status(int page){
  int i;

  for(i=pagep*page;i<=pagep+pagep*page;i++){
    memset(val,0,sizeof(val));
    sy403_read_param(READ_STATUS,i,val,STATUS_SIZE,craten);
    store_status(craten,i,val);
  }

  mv_cur(0,0);
  cl_line();
  print_header(page);

  for(i=pagep*page;i<pagep+pagep*page;i++){
    print_status(i);
  }

  return 1;
}

int read_page(void){
  if(mdflag < 0){
    print_warn();
    return -1;
  }
  read_status(pagec);
  pagec++;
  if(pagec == pagen){
    pagec = 0;
  }

  return 0;
}
  

int read_wch(void){
  int ret;
  char *tline;

  /* mv_cur(comy,comx); */
  cl_line();
  tline = readline("Channel [0-63]/[64=All] : ");
  if(sscanf(tline,"%i",&ret) > 0){
    if(ret < 0 || ret > 64){
      ret = -1;
    }
  }
  free(tline);

  return ret;
}

int hv_off(void)
{
   char *tline;
   int i;
   tline = readline("H.V. Off for All Channel? [y/n] : ");
   if(tline[0] == 'y')
     {
	for(i=0;i<nch;i++)
	  {
	     sy403_hv_off(i,craten);
	  }
	
     }
   free(tline);
   return 0;
}

int hv_on(void)
{
   char *tline;
   int i;
   tline = readline("H.V. On for All Channel? [y/n] : ");
   if(tline[0] == 'y')
     {
	for(i=0;i<nch;i++)
	  {
	     sy403_hv_on(i,craten);
	  }
	
     }
   free(tline);
   return 0;
}


int write_param(void){
  short ch;
  unsigned short sval;
  char *tline,mm;
  float fval;
  int i;

  if(mdflag < 0){
    print_warn();
    return -1;
  }

  ch = 0;

  tline = readline("Name[n] V0[v] I0[i] Vmax[m] Rup[u] Rdown[d] Trip[t] : ");
  memcpy(&mm,tline,1);
  free(tline);

  switch(mm){
  case 'n':
    if((ch = read_wch()) != -1){
      tline = readline("Name (max 7 char) : ");
       strncpy(hvstat[craten][ch].name,tline,sizeof(hvstat[craten][ch].name));
      sy403_write_nparam(SET_NAME,ch,(unsigned short *)hvstat[craten][ch].name,
			 sizeof(hvstat[craten][ch].name)/2,craten);
    }else{
      printf("Invalid channel.\n");
    }
    break;
  case 'v':
    if((ch = read_wch()) != -1){
      tline = readline("V0 (0.-3000. V) : ");
      if(sscanf(tline,"%f",&fval) > 0){
	if(fval <= VMAX){
	  sval = fval*v0unit;
	  if(ch == nch){
	    for(i=0;i<nch;i++){
	      sy403_write_param(SET_V0,i,sval,craten);
	    }
	  }else{
	    sy403_write_param(SET_V0,ch,sval,craten);
	  }
	}else{
	  printf("Invalid Value.\n");
	}
      }
    }else{
      printf("Invalid channel.\n");
    }
    break;
  case 'i':
    if((ch = read_wch()) != -1){
      tline = readline("I0 (0.-3000. uA) : ");
      if(sscanf(tline,"%f",&fval) > 0){
	if(fval <= IMAX){
	  if(ch == nch){
	    for(i=0;i<nch;i++){
	      sy403_write_param(SET_I0,i,sval,craten);
	    }
	  }else{
	    sy403_write_param(SET_I0,ch,sval,craten);
	  }
	}else{
	  printf("Invalid Value.\n");
	}
      }
    }else{
      printf("Invalid channel.\n");
    }
    break;
  case 'm':
    if((ch = read_wch()) != -1){
      tline = readline("Vmax (0-3000 V) : ");
      if(sscanf(tline,"%i",(int *)&sval) > 0){
	if(sval <= VMAX){
	  if(ch == nch){
	    for(i=0;i<nch;i++){
	      sy403_write_param(SET_VMAX,i,sval,craten);
	    }
	  }else{
	  sy403_write_param(SET_VMAX,ch,sval,craten);
	  }
	}else{
	  printf("Invalid Value.\n");
	}
      }
    }else{
      printf("Invalid channel.\n");
    }
    break;
  case 'u':
    if((ch = read_wch()) != -1){
      tline = readline("Ramp up (1-999 V/s) : ");
      if(sscanf(tline,"%i",(int *)&sval) > 0){
	if(sval <= RAMPMAX){
	  if(ch == nch){
	    for(i=0;i<nch;i++){
	      sy403_write_param(SET_RAMPUP,i,sval,craten);
	    }
	    sy403_write_param(SET_RAMPUP,ch,sval,craten);
	  }
	}else{
	  printf("Invalid Value.\n");
	}
      }
    }else{
      printf("Invalid channel.\n");
    }
    break;
  case 'd':
    if((ch = read_wch()) != -1){
      tline = readline("Ramp down (1-999 V/s) : ");
      if(sscanf(tline,"%i",(int *)&sval) > 0){
	if(sval <= RAMPMAX){
	  if(ch == nch){
	    for(i=0;i<nch;i++){
	      sy403_write_param(SET_RAMPDOWN,i,sval,craten);
	    }
	  }else{
	    sy403_write_param(SET_RAMPDOWN,ch,sval,craten);
	  }
	}else{
	  printf("Invalid Value.\n");
	}
      }
    }else{
      printf("Invalid channel.\n");
    }
    break;
  case 't':
    if((ch = read_wch()) != -1){
      tline = readline("Trip (0-999/1000 = const current) : ");
      if(sscanf(tline,"%i",(int *)&sval) > 0){
	if(sval <= TRIPMAX){
	  if(ch == nch){
	    for(i=0;i<nch;i++){
	      sy403_write_param(SET_TRIP,i,sval,craten);
	    }
	  }
	  sy403_write_param(SET_TRIP,ch,sval,craten);
	}else{
	  printf("Invalid Value.\n");
	}
      }
    }else{
      printf("Invalid channel.\n");
    }
    break;
  case 'q':
    break;
  }
  free(tline);

  cl_screen();

  return 1;
}

int read_file(char *arg){
  FILE *fd;
  char buff[256],tname[12], *ll;
  int tch, tval;

  if((fd = fopen(arg,"r")) == NULL){
    printf("Can't open %s.\n",arg);
    return -1;
  }
  while(!feof(fd)){
    fgets(buff,sizeof(buff),fd);
    tab2space(buff);
    ll = stripwhite(buff);
    if(sscanf(ll,"%d %12s %d",&tch,tname,&tval) != 3){
      printf("Error in file\n");
      break;
    }
    sy403_set_name(tch,tname,craten);
    sy403_set_v0(tch,tval,craten);
  }
  
  fclose(fd);
  pagec = 0;
  read_all_param();
  read_page();

  return 0;
}

void get_terminfo(void){
  tgetent(term_buffer,termtype);
  row = tgetnum("li");
  col = tgetnum("co");

  comx = 0;
  comy = row - 3;
  comxi = 8;
  staty = comy - 1;
  pagep = (int)HVPAGE*(staty/(int)HVPAGE);
  pagen = nch/pagep;
  pagef = 1;
  pagec = 0;

}

int main(int argc,char *argv[]){
  int ret;
  struct sigaction sa,osa;

  strcpy(termtype,getenv("TERM"));

  if(termtype == 0){
    printf("Can't get terminal type.\n");
    exit(0);
  }
  ret = tgetent(term_buffer,termtype);
  if(ret < 0){
    printf("Can't access the termcap data base.\n");
    exit(0);
  }else if(ret == 0){
    printf("Terminal type `%s' is not define.\n",termtype);
    exit(0);
  }

  get_terminfo();
  sa.sa_handler = (void *)get_terminfo;
  sa.sa_flags = 0;
  sigaction(SIGWINCH,&sa,&osa);
  cl_screen();


  signal(SIGINT,(void *)quit);

  memset(tmpstr,0,sizeof(tmpstr));
  memset(val,0,sizeof(val));

  addr = 0x800000;
  v288_init(addr);
  mdflag = -1;

  get_terminfo();
  /* signal(SIGALRM,(void *)com_getall); */
  //com_help();

  init_status();

  printf("\n");
  mv_cur(5,5);
  printf("Select craete number of SY403 CAEN H.V. SYSTEM\n");
   
  while(1){
    mv_cur(comy,comx);
    cl_line();
    line = readline("CMDHV : ");
    if(!line){
      break;
    }
    com = stripwhite(line);

    if(*com){
      add_history(com);
      execute_line(com);
    }
    free(line);
  }

  quit();

  return 0;
}
