#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <signal.h>
#include <math.h>

#include "cmdamp.h"

#define VER  "1.1"
#define AUTH "July 8, 2002  H.Baba"

char *lcr_ptr,*mm_ptr,*vic_ptr,*vec_ptr,*vme_ptr;
unsigned long addr;
unsigned int craten,code;

char n568b_sig[] = "N568",
  shpstr[4][4] = {"0.2\0","1\0","3\0","6\0"},
  postr[2][9] = {"Positive\0","Negative\0"},
    costr[2][9] = {"Direct\0","Inverted\0"};

int com;
char tmpstr[256];
unsigned short val[256];
double pole_step = 450./50.;

void exit_sig(void){
  printf("Exit cmdamp.\n");
  v288_release();
  exit(0);
}

void print_param(int of){
  printf("Fine Gain       : %2d\n",val[of]);
  printf("Coarse Gain     : %2d (x%d)\n",
	 val[of+2]&0x0007,(int)pow(2,(val[of+2]&0x0007)));
  printf("Pole Zero       : %2d (%2.2f us)\n",
	 val[of+1],50.+val[of+1]*pole_step);
  printf("Shaping Time    : %2d (%s us)\n",
	 (val[of+2]&0x0018)>>3,shpstr[(val[of+2]&0x0018)>>3]);
  printf("Output Polarity : %s\n",postr[(val[of+2]>>6)&0x01]);
  printf("Output Config.  : %s\n",costr[(val[of+2]>>5)&0x01]);
}

void make_menu(void){
  printf("\n\n");
  printf("---------------------------------------------------------------\n");
  printf(" cmdamp %s         %s\n",VER,AUTH);
  printf(" Command line controller for 16 Channel Spectroscopy Amplifier\n");
  printf("---------------------------------------------------------------\n");
  printf("\n\n");
}

int select_n(void){
  printf("\n");
  printf("### Select Station Number n (1-255), or Exit Program (n<1 or 255>n) ###\n");
  printf("Station Number ? : ");
  scanf("%s",tmpstr);
  craten = (unsigned short)strtoul(tmpstr,NULL,0);
  if(craten < 1 || craten > 255){
    exit_sig();
  }

  n568b_read_ident(n568b_ident,craten);

  if(strncmp(n568b_ident,n568b_sig,4) != 0){
    printf("Invalid Station Number %d",craten);
    return -1;
  }else{
    printf("Identifier %s\n",n568b_ident);
    return 1;
  }
}

int select_com(void){

  printf("\n### Menu ###\nread[r] write[w] quit[q] : ");
  scanf("%s",tmpstr);
  switch(tmpstr[0]){
  case 'r':
    return 1;
    break;
  case 'w':
    return 2;
    break;
  case 'h':
    return 3;
    break;
  case 'q':
    return -1;
    break;
  }

  return 0;
}

void read_menu(void){
  int ro,i,ch;

  ro = 1;
  while(ro>0){
    printf("\n### Read Menu ###\n");
    printf("All[a] Channel[c] Offset[o] Mux[m] Help[h] Quit[q] : ");
    scanf("%s",tmpstr);
    switch(tmpstr[0]){
    case 'a':
      printf("Read All Channel Paramters\n");
      n568b_read_all_param(val,craten);
      for(i=0;i<16;i++){
	printf("Channel         : %d\n",i);
	print_param(i*3);
	printf("\n");
      }
      break;
    case 'o':
      printf("Read Offset Value\n");
      n568b_read_param(READ_OFFSET,0,val,OFFSET_SIZE,craten);
      printf("Offset %d\n",val[0]);
      break;
    case 'c':
      printf("Channel         : ");
      if(scanf("%i",&ch) > 0){
	if(ch < 0 || ch > 15){
	  printf("Invalid channel.\n");
	}else{
	  n568b_read_param(READ_PARAM,ch,val,PARAM_SIZE,craten);
	  print_param(0);
	}
      }else{
	printf("Invalid channel.\n");
      }
      break;
    case 'm':
      printf("MUX Status\n");
      n568b_read_param(READ_MUX,0,val,MUX_SIZE,craten);
      printf("Last Access Channel : %d\n",val[0]&0x000f);
      if((val[0]&0x0080) != 0){
	printf("MUX Enable\n");
      }else{
	printf("MUX Disable\n");
      }
      break;
    case 'h':
      printf("\n--------- HELP for Read Commands ---------\n");
      printf("# ALL[a]\n");
      printf("  Read all Parameters for all Channels + Offset Value.\n\n");
      printf("# Offset[o]\n");
      printf("  Read Offset Value (Common Channel).\n\n");
      printf("# Channel[c]\n");
      printf("  Read all Parameters for Selected Channel.\n\n");
      printf("# Mux[m]\n");
      printf("  Read MUX Enable Status & Last Accessed Channel\n\n");
      break;
    case 'q':
      ro = -1;
      printf("Exit Read Mode\n");
      break;
    }
  }
}

int read_wch(void){
  int ret;

  printf("Channel [0-15]/[16=Common] : ");
  if(scanf("%i",&ret) > 0){
    if(ret < 0 || ret > 16){
      ret = -1;
    }
  }

  return ret;
}
void write_menu(void){
  int ro;
  short ch;
  unsigned short sval;

  ro = 1;
  ch = 0;

  while(ro > 0){
    printf("\n### Write Menu ###\n");
    printf("Fine[f] Coarse[c] Pole Zelo[z] Shaping[s] Polarity[p]\n");
    printf("Config[g] Offset[o] Mux Status[m] Help[h] Quit[q] : ");
    scanf("%s",tmpstr);
    switch(tmpstr[0]){
    case 'f':
      if((ch = read_wch()) != -1){
	printf("Fine Gain Value [0-255]: ");
	if(scanf("%i",(int *)&sval) > 0){
	  if(sval <= FINE_MASK){
	    n568b_write_param(WRITE_FINE,ch,sval,craten);
	  }else{
	    printf("Invalid Value.\n");
	  }
	}
      }else{
	printf("Invalid channel.\n");
      }
      break;
    case 'c':
      if((ch = read_wch()) != -1){
	printf("Coarse Gain Value x2^[0-7]: ");
	if(scanf("%i",(int *)&sval) > 0){
	  if(sval <= COARSE_MASK){
	    n568b_write_param(WRITE_COARSE,ch,sval,craten);
	  }else{
	    printf("Invalid Value.\n");
	  }
	}
      }else{
	printf("Invalid channel.\n");
      }
      break;
    case 'z':
      if((ch = read_wch()) != -1){
	printf("Pole Zero Value [0-255]=(50-500us) : ");
	if(scanf("%i",(int *)&sval) > 0){
	  if(sval <= POLEZERO_MASK){
	    n568b_write_param(WRITE_POLEZERO,ch,sval,craten);
	  }else{
	    printf("Invalid Value.\n");
	  }
	}
      }else{
	printf("Invalid channel.\n");
      }
      break;
    case 's':
      if((ch = read_wch()) != -1){
	printf("Shaping Time Value [0-3]=(%s,%s,%s,%s) : ",
	       shpstr[0],shpstr[1],shpstr[2],shpstr[3]);
	if(scanf("%i",(int *)&sval) > 0){
	  if(sval <= SHAPE_MASK){
	    n568b_write_param(WRITE_SHAPE,ch,sval,craten);
	  }else{
	    printf("Invalid Value.\n");
	  }
	}
      }else{
	printf("Invalid channel.\n");
      }
      break;
    case 'p':
      if((ch = read_wch()) != -1){
	printf("Output Polarity Value [0/1]=(%s,%s) : ",
	       postr[0],postr[1]);
	if(scanf("%i",(int *)&sval) > 0){
	  if(sval <= POLARITY_MASK){
	    n568b_write_param(WRITE_POLARITY,ch,sval,craten);
	  }else{
	    printf("Invalid Value.\n");
	  }
	}
      }else{
	printf("Invalid channel.\n");
      }
      break;
    case 'g':
      if((ch = read_wch()) != -1){
	printf("Output Configuration Value [0/1]=(%s,%s) : ",
	       costr[0],costr[1]);
	if(scanf("%i",(int *)&sval) > 0){
	  if(sval <= CONFIG_MASK){
	    n568b_write_param(WRITE_CONFIG,ch,sval,craten);
	  }else{
	    printf("Invalid Value.\n");
	  }
	}
      }else{
	printf("Invalid channel.\n");
      }
      break;
    case 'o':
      printf("Offset Value [0-255] (Common) : ");
      if(scanf("%i",(int *)&sval) > 0){
	if(sval <= OFFSET_MASK){
	  n568b_write_param(WRITE_OFFSET,ch,sval,craten);
	}else{
	  printf("Invalid Value.\n");
	}
      }
      break;
    case 'm':
      printf("MUX Status [0/1] (Enable,Disable) : ");
      if(scanf("%i",(int *)&sval) > 0){
	if(sval <= MUX_MASK){
	  if(sval == 0){
	    n568b_set_param(ENABLE_MULTI,0,craten);
	  }else{
	    n568b_set_param(DISABLE_MULTI,0,craten);
	  }
	}else{
	  printf("Invalid Value.\n");
	}
      }
      break;
    case 'q':
      ro = -1;
      break;
    }
  }
}


int main(int argc,char *argv[]){
  int rom;

  signal(SIGINT,(void *)exit_sig);

  memset(tmpstr,0,sizeof(tmpstr));
  memset(val,0,sizeof(val));

  addr = 0x800000;
  v288_init(addr);
  make_menu();

  while(1){
    if((rom = select_n()) == 1){
      while(rom >= 0){
	switch(select_com()){
	case 1:
	  read_menu();
	  break;
	case 2:
	  write_menu();
	  break;
	case -1:
	  rom = -1;
	  break;
	}
      }
    }
  }

  exit_sig();

  return 0;
}
