#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <signal.h>
#include <ncurses.h>
#include <readline/readline.h>

#include "bbcaenhv.h"

//#define NOCAEN

#define MONINT 6

unsigned int addr = 0x800000;

int read_all_param();
void store_param();
int read_status();
int y2ch();
void mvcursol();
int sy_ver = 0;

char sy403_sig[] = "SY403";
unsigned short val[256],offval,muxval;
char ofstr[2][4] = {"Off\0","On\0\0"};
char ststr[3][5] = {"    \0","Down\0","Up\0\0\0"};

int bgcolor,first = 0;
int key,flag,monitor = 0;
int x,y,ox,oy,lines;
int craten = 1;
int page = 0, npage = 1;
char buff[256];
attr_t redstr,bluestr,greenstr,cyanstr,magentastr,yellowstr;

#define CELLN 7
int cellw[CELLN] = {3,12,8,8,8,8,8};
int cellx[CELLN] = {0,5,20,30,40,50,60};

#define CELL_CH    0
#define CELL_NAME  1
#define CELL_HV    2
#define CELL_HVSET 3
#define CELL_HVMAX 4
#define CELL_CURR  5
#define CELL_STAT  6


void store_param(int cr, int ch, unsigned short v[256])
{
   char tn[12];
   int ii;

   //if((sy_ver < 145 && first == 0) || sy_ver >= 145)
   if((sy_ver < 145 ) || sy_ver >= 145)
     {
	memset(tn,0,sizeof(tn));
	for(ii=0;ii<12;ii+=2)
	  {
	     tn[ii] = (v[ii/2]&0xff00) >> 8;
	     tn[ii+1] = v[ii/2]&0x00ff;
	  }
	memcpy(hvstat[cr][ch].name,tn,sizeof(tn));
     }
   
  hvstat[cr][ch].v0set = v[6]<<16 | v[7];
  hvstat[cr][ch].v1set = v[8]<<16 | v[9];
  hvstat[cr][ch].i0set = v[10];
  hvstat[cr][ch].i1set = v[11];
  hvstat[cr][ch].vmax = v[12];
  hvstat[cr][ch].rup = v[13];
  hvstat[cr][ch].rdwn = v[14];
  hvstat[cr][ch].trip = v[15];
  hvstat[cr][ch].flag = v[16];
   if(v[16]&0x2000)
     {
	hvstat[cr][ch].rdwn = 1;
     }
   else
     {
	hvstat[cr][ch].rdwn = 0;
     }
   
}
 
void store_status(int cr, int ch, unsigned short v[256])
{
   hvstat[cr][ch].vmon = v[0]<<16 | v[1];
  hvstat[cr][ch].imon = v[2];

  hvstat[cr][ch].flag = v[3];
   if(v[3]&0x8000)
     {
	hvstat[cr][ch].onoff = 1;
	if(v[3]&0x4000)
	  {
	     hvstat[cr][ch].updown = 1;
	  }
	else if(v[3]&0x2000)
	  {
	     hvstat[cr][ch].updown = -1;
	  }
	else
	  {
	     hvstat[cr][ch].updown = 0;
	  }
	
     }
   
}


int read_status(void){
  int i;
   for(i=y2ch(2);i<y2ch(LINES-1);i++){
      memset(val,0,sizeof(val));
#ifndef NOCAEN
    sy403_read_param(READ_STATUS,i,val,STATUS_SIZE,craten);
    store_status(craten,i,val);
#endif
  }
  return 1;
}

int read_all_param(void){
  int i;

  for(i=y2ch(2);i<y2ch(LINES-1);i++){
    memset(val,0,sizeof(val));
#ifndef NOCAEN
    sy403_read_param(READ_PARAMETER,i,val,PARAM_SIZE,craten);
    store_param(craten,i,val);
#endif
  }
   
  return 1;
}



int tab2space(char *buff){
  int i;
  for(i=0;i<strlen(buff);i++){
    if(buff[i] == '\t'){
      buff[i] = ' ';
    }
  }

  return 0;
}

char *stripwhite (char *string){
  register char *s, *t;

  for(s = string; whitespace (*s); s++);
    
  if (*s == 0)
    return (s);

  t = s + strlen (s) - 1;
  while (t > s && whitespace (*t))
    t--;
  *++t = '\0';

  return s;
}


void quit(void){
  flag = -1;
#ifndef NOCAEN
  v288_release();
#endif
  clear();
  endwin();
  exit(0);
}

int y2ch(int yy){
  return (LINES-3)*page+yy-2;
}

int init_stat(void){
  int i,j;
  for(i=0;i<HVCNMAX;i++){
    for(j=0;j<HVCHMAX;j++){
      hvstat[i][j].ch = j;
      strcpy(hvstat[i][j].name,"--------\0");
      hvstat[i][j].v0set = 0;
      hvstat[i][j].vmax = 0;
      hvstat[i][j].vmon = 0;
      hvstat[i][j].imon = 0;
      hvstat[i][j].onoff = 0;
      hvstat[i][j].updown = 0;
    }
  }

  return 0;
}

int yn(void){
  int tkey;
  echo();
  tkey = getch();
  noecho();
  if(tkey == 'y'){
    return 1;
  }else{
    return -1;
  }
}

int update_cell(int yy,int xx,int rev){
  if(y2ch(yy) >= HVCHMAX || y2ch(yy) < 0){
    y = 2;
    yy = 2;
  }

  if(rev == 1){
    attron(A_REVERSE);
  }
  switch(xx){
  case 0:
    mvprintw(yy,cellx[0],"%03d",hvstat[craten][y2ch(yy)].ch);
    break;
  case 1:
    mvprintw(yy,cellx[1],"%s",hvstat[craten][y2ch(yy)].name);
    break;
  case 2:
     //mvprintw(yy,cellx[2],"%04d",hvstat[craten][y2ch(yy)].vmon/10);
     mvprintw(yy,cellx[2],"%04d.%01d",hvstat[craten][y2ch(yy)].vmon/10
	      ,hvstat[craten][y2ch(yy)].vmon%10);
    break;
  case 3:
    //mvprintw(yy,cellx[3],"%04d",hvstat[craten][y2ch(yy)].v0set/10);
     mvprintw(yy,cellx[3],"%04d.%01d",hvstat[craten][y2ch(yy)].v0set/10
	      ,hvstat[craten][y2ch(yy)].v0set%10);
    break;
  case 4:
    mvprintw(yy,cellx[4],"%04d",hvstat[craten][y2ch(yy)].vmax);
    break;
  case 5:
    mvprintw(yy,cellx[5],"%04d",hvstat[craten][y2ch(yy)].imon);
    break;
  case 6:
     if(hvstat[craten][y2ch(yy)].onoff == 0){
	mvprintw(yy,cellx[6],"off");
	if(hvstat[craten][y2ch(yy)].updown == -1
	   || hvstat[craten][y2ch(yy)].rdwn == 1
	   || hvstat[craten][y2ch(yy)].vmon > 100)
	  {
	     attron(redstr);
	     mvprintw(yy,cellx[6]+4,"Down");
	     attroff(redstr);
	  }
     }else{ 
	attron(magentastr);
	mvprintw(yy,cellx[6]," on");
	attroff(magentastr);
	attron(redstr);
	attron(A_BOLD);
	if(hvstat[craten][y2ch(yy)].updown == 1)
	  {
	     mvprintw(yy,cellx[6]+4,"Up");
	  }else if(hvstat[craten][y2ch(yy)].updown == -1
		   || hvstat[craten][y2ch(yy)].rdwn == 1)
	       {
		  mvprintw(yy,cellx[6]+4,"Down");
	       }
	attroff(A_BOLD);
	attroff(redstr);
     }
     break;
  }
   
   if(rev == 1){
      attroff(A_REVERSE);
   }

  return 0;
}

int update_scr(int mode){
  int i,yy;
   
  npage = HVCHMAX/lines;
   if(HVCHMAX%lines != 0)
     {
	npage++;
     }
   
#ifndef NOCAEN
   if(mode == 1)
     {
	read_all_param();
	read_status();
     }
   else if(mode == 2)
     {
	read_status();
     }
   
#endif
  clear();
  mvprintw(0,0,"CRATE %02d",craten);
  mvprintw(0,11,"PAGE %d/%d",page+1,npage);
  mvprintw(1,cellx[0],"#ch");
  mvprintw(1,cellx[1],"name");
  mvprintw(1,cellx[2],"hv");
  mvprintw(1,cellx[3],"hv set");
  mvprintw(1,cellx[4],"hv max");
  mvprintw(1,cellx[5],"current");
  mvprintw(1,cellx[6],"status");

   for(i=0;i<lines;i++){
      yy = y2ch(i+2);
      if(yy < HVCHMAX){
	 mvprintw(i+2,cellx[0],"%03d",hvstat[craten][yy].ch);
	 mvprintw(i+2,cellx[1],"%s",hvstat[craten][yy].name);
	 //mvprintw(i+2,cellx[2],"%04d",hvstat[craten][yy].vmon/10);
	 mvprintw(i+2,cellx[2],"%04d.%01d",hvstat[craten][yy].vmon/10
	 	       ,hvstat[craten][yy].vmon%10);
	 //mvprintw(i+2,cellx[3],"%04d",hvstat[craten][yy].v0set/10);
	 mvprintw(i+2,cellx[3],"%04d.%01d",hvstat[craten][yy].v0set/10
	 	       ,hvstat[craten][yy].v0set%10);
	 mvprintw(i+2,cellx[4],"%04d",hvstat[craten][yy].vmax);
	 mvprintw(i+2,cellx[5],"%04d",hvstat[craten][yy].imon);
	 if(hvstat[craten][yy].onoff == 0){
	    mvprintw(i+2,cellx[6],"off");
	    if(hvstat[craten][yy].updown == -1
	       || hvstat[craten][yy].rdwn == 1
	       || hvstat[craten][yy].vmon > 100)
	      {
		 attron(redstr);
		 mvprintw(i+2,cellx[6]+4,"Down");
		 attroff(redstr);
	      }
	 }else{ 
	    attron(magentastr);
	    mvprintw(i+2,cellx[6]," on");
	    attroff(magentastr);
	    attron(redstr);
	    attron(A_BOLD);
	    if(hvstat[craten][yy].updown == 1)
	      {
	         mvprintw(i+2,cellx[6]+4,"Up");
	      }else if(hvstat[craten][yy].updown == -1
		       || hvstat[craten][yy].rdwn == 1)
		   {
		      mvprintw(i+2,cellx[6]+4,"Down");
		   }
	    attroff(A_BOLD);
	    attroff(redstr);
	 }
      }
   }

  attron(greenstr);
  attron(A_BOLD);
  mvprintw(0,22,"C");
  attroff(A_BOLD);
  attroff(greenstr);
  mvprintw(0,23,"rate");

  attron(greenstr);
  attron(A_BOLD);
  mvprintw(0,28,"P");
  attroff(A_BOLD);
  attroff(greenstr);
  mvprintw(0,29,"age");

  attron(greenstr);
  attron(A_BOLD);
  mvprintw(0,33,"E");
  attroff(A_BOLD);
  attroff(greenstr);
  mvprintw(0,34,"dit");

  attron(greenstr);
  attron(A_BOLD);
  mvprintw(0,38,"L");
  attroff(A_BOLD);
  attroff(greenstr);
  mvprintw(0,39,"oad");

   attron(greenstr);
  attron(A_BOLD);
  mvprintw(0,43,"S");
  attroff(A_BOLD);
  attroff(greenstr);
  mvprintw(0,44,"ave");

  attron(greenstr);
  attron(A_BOLD);
  mvprintw(0,48,"O");
  attroff(A_BOLD);
  attroff(greenstr);
  mvprintw(0,49,"n/");
  attron(greenstr);
  attron(A_BOLD);
  mvprintw(0,51,"O");
  attroff(A_BOLD);
  attroff(greenstr);
  mvprintw(0,52,"ff");
   /*
  attron(greenstr);
  attron(A_BOLD);
  mvprintw(0,55,"Z");
  attroff(A_BOLD);
  attroff(greenstr);
  mvprintw(0,56,"ero");
    */
   attron(greenstr);
  attron(A_BOLD);
  mvprintw(0,55,"U");
  attroff(A_BOLD);
  attroff(greenstr);
  mvprintw(0,56,"pdate");

  if(monitor == 0){
    attron(cyanstr);
    attron(A_BOLD);
    mvprintw(0,62,"M");
    attroff(A_BOLD);
    attroff(cyanstr);
  }else{
    attron(magentastr);
    attron(A_BOLD);
    mvprintw(0,62,"M");
    attroff(A_BOLD);
    attroff(magentastr);
  }
  mvprintw(0,63,"onitor");

  attron(redstr);
  attron(A_BOLD);
  mvprintw(0,70,"Q");
  attroff(A_BOLD);
  attroff(redstr);
  mvprintw(0,71,"uit");

  return 0;
}

int chkchar(int ch,int mode){
  int ret = -1;

  if(mode == 0){
    if(isalnum(ch) != 0){
      ret = 1;
    }else if(ch==' ' || ch=='_' || ch=='-'){
      ret = 1;
    }
  }else if(mode == 1){
     if(isdigit(ch) != 0){
	ret = 1;
     }
  }
   else if(mode == 2)
     {
	if(isdigit(ch) != 0 || ch == '.')
	  {
	     ret = 1;
	  }
	
     }

  return ret;
}

int hv_crate(void){
  int tcrate;
  char line[256],ver[4];

   memset(ver,0,sizeof(ver));
  mvhline(LINES-1,0,' ',COLS);
  attron(redstr);
  mvprintw(LINES-1,0,"*");
  memset(line,0,sizeof(line));
  attroff(redstr);
  echo();
  mvprintw(LINES-1,1," input crate number (0<N<10) : "); 
  getstr(line);
  tcrate = strtol(line,NULL,0);
  if(tcrate < 1 || tcrate >= HVCNMAX){
    mvprintw(LINES-1,0,"*");
    return -1;
  }else{
#ifndef NOCAEN
    sy403_read_ident(sy403_ident,tcrate);
    if(strncmp(sy403_ident,sy403_sig,4) != 0){
      mvhline(LINES-1,0,' ',COLS);
      mvprintw(LINES-1,0,"* Invalid Station Number %d",tcrate);
      return -1;
    }else{
#endif    
      mvhline(LINES-1,0,' ',COLS);
       ver[0] = sy403_ident[7];
       ver[1] = sy403_ident[9];
       ver[2] = sy403_ident[10];
       printf("* Identifier %s\n",sy403_ident);
       sy_ver = strtol(ver,NULL,0);
       craten = tcrate;
      update_scr(1);
#ifndef NOCAEN
    }
#endif
  }


  return 0;
}

int hv_load(void){
  FILE *fd;
  char name[256],line[256],tname[12],*ll;
  int tch,tval,tmax,tcrate,tflag;

  tflag = 0;

  mvhline(LINES-1,0,' ',COLS);
  attron(redstr);
  mvprintw(LINES-1,0,"*");
  memset(name,0,sizeof(name));
  attroff(redstr);
  echo();
  mvprintw(LINES-1,1," input file name : "); 
  getstr(name);
  mvprintw(LINES-1,0,"*");

  if((fd = fopen(name,"r")) == NULL){
    mvhline(LINES-1,0,' ',COLS);
    mvprintw(LINES-1,0,"* input file name : ");
    attron(redstr);
    printw("Can't open.");
    attroff(redstr);
    return -1;
  }
  while(!feof(fd)){
    fgets(line,sizeof(line),fd);
    if(line[0] != 'c' && line[0] != 'C' && line[0] != '#'){
      tab2space(line);
      ll = stripwhite(line);
      if(sscanf(ll,"%d %d %12s %d %d",
		&tcrate,&tch,tname,&tval,&tmax) != 5){
	tflag = 1;
      break;
      }
      if(tcrate >= HVCNMAX || tch >= HVCHMAX){
	tflag = 2;
	break;
      }
      hvstat[tcrate][tch].v0set = tval*10;
      hvstat[tcrate][tch].vmax = tmax;
      strcpy(hvstat[tcrate][tch].name,tname);
#ifndef NOCAEN
       if(sy_ver >= 145)
	 {
	    sy403_set_name(tch,tname,tcrate);
	 }
       
      sy403_set_v0(tch,tval*10,tcrate);
      sy403_set_vmax(tch,tmax,tcrate);
#endif
    }
  }

  update_scr(1);

  if(tflag == 1){
    mvhline(LINES-1,0,' ',COLS);
    mvprintw(LINES-1,0,"* input file name : ");
    attron(redstr);
    printw("Error in file.");
    attroff(redstr);
  }else if(tflag == 2){
    mvhline(LINES-1,0,' ',COLS);
    mvprintw(LINES-1,0,"* input file name : ");
    attron(redstr);
    printw("Error in file (crate or channel).");
    attroff(redstr);
  }

  noecho();

  return 0;
}

int hv_save(void){
  FILE *fd;
  char name[256];
   int i,j;
   
   attron(redstr);
  mvprintw(LINES-1,0,"*");
  memset(name,0,sizeof(name));
  attroff(redstr);
  echo();
  mvprintw(LINES-1,1," input file name : "); 
  getstr(name);
  mvprintw(LINES-1,0,"*");

  if((fd = fopen(name,"w")) == NULL){
    mvhline(LINES-1,0,' ',COLS);
    mvprintw(LINES-1,0,"* input file name : ");
    attron(redstr);
    printw("Can't open.");
    attroff(redstr);
    return -1;
  }
   for(i=0;i<HVCNMAX;i++)
     {
	for(j=0;j<HVCHMAX;j++)
	  {
	     if(hvstat[i][j].v0set != 0)
	       {
		  fprintf(fd,"%2d %2d %8s %4d %4d\n",i,j,
			  hvstat[i][j].name,hvstat[i][j].v0set/10,
			  hvstat[i][j].vmax);
	       }
	     
	  }
	
     }
   fclose(fd);
  noecho();

  return 0;
}

int hv_zero(void){
  int j;

  mvhline(LINES-1,0,' ',COLS);
  attron(redstr);
  mvprintw(LINES-1,0,"*");
  attroff(redstr);
  mvprintw(LINES-1,1," set all ch. ZERO? (y/n) : "); 
  if(yn() == 1){
    for(j=0;j<HVCHMAX;j++){
      hvstat[craten][j].onoff = 0;
#ifndef NOCAEN
      sy403_hv_off(j,craten);
#endif
    }
    mvprintw(LINES-1,0,"*");
    update_scr(1);
    return 1;
  }else{
    mvprintw(LINES-1,0,"*");
    return -1;
  }
}

int hv_update(void){
  if(monitor == 1){
     update_scr(2);
     mvcursol();
     refresh();
     alarm(MONINT);
  }

  return 0;
}

int hv_monitor(void){
  if(monitor == 0){
    monitor = 1;
    hv_update();
  }else{
    monitor = 0;
     update_scr(1);
  }
  
  return 0;
}

int edit_cell(void){
  int tflag = 1,tkey,i,chk,idx = 0;

  if(x==0||x==2||x==5){
    return -1;
  }
  memset(buff,0,sizeof(buff));
  move(y,cellx[x]);
  for(i=0;i<cellw[x];i++){
    printw(" ");
  }
  move(y,cellx[x]);
  while(1){
    noecho();
    chk = -1;
    tkey = getch();
    switch(tkey){
    case 27:
      tflag = -1;
      update_cell(y,x,1);
      break;
    case 7:
    case 8:
    case KEY_DC:
      if(idx > 0){
	idx--;
	buff[idx] = '\0';
	mvprintw(y,cellx[x]+idx," ");
	move(y,cellx[x]+idx);
      }
      break;
    case '\n':
      tflag = -1;
      if(strlen(buff) > 0){
	switch(x){
	case CELL_NAME:
	  strcpy(hvstat[craten][y2ch(y)].name,buff);
#ifndef NOCAEN
	   if(sy_ver >= 145)
	     {
		sy403_set_name(y2ch(y),hvstat[craten][y2ch(y)].name,craten);
	     }
	   
#endif
	  break;
	case CELL_HVSET:
	  hvstat[craten][y2ch(y)].v0set = (int)(strtod(buff,NULL)*10.0);
#ifndef NOCAEN
	  sy403_set_v0(y2ch(y),hvstat[craten][y2ch(y)].v0set,craten);
#endif
	  break;
	case CELL_HVMAX:
	  hvstat[craten][y2ch(y)].vmax = strtol(buff,NULL,0);
#ifndef NOCAEN
	  sy403_set_vmax(y2ch(y),hvstat[craten][y2ch(y)].vmax,craten);
#endif
	  break;
	}
      }
      update_cell(y,x,1);
      break;
    default:
      if(x == 1){
	if(idx < 8){
	  chk = chkchar(tkey,0);
	}
      }
       else if(x == 3)
	 {
	    if(idx < 6)
	      {
		 chk = chkchar(tkey,2);
	      }
	 }else{
	if(idx < 4){
	  chk = chkchar(tkey,1);
	}
      }
      if(chk == 1){
	buff[idx] = tkey;
	idx++;
	printw("%c",tkey);
      }
      break;
    }
    if(tflag == -1){
      break;
    }
  }
    
  return 0;
}

void mvcursol(void){
  update_cell(oy,ox,0);
  move(y,cellx[x]);
  update_cell(y,x,1);
}

int main(int argc,char *argv[]){
  if(argc == 2){
    addr = strtol(argv[1],NULL,0);
  }else{
    addr = 0x800000;
  }

  flag = 1;
#ifndef NOCAEN
  if(v288_init(addr) == -1){
    exit(0);
  }
#endif
  initscr();

  start_color();
  if(use_default_colors() == ERR){
    bgcolor = COLOR_BLACK;
  }
  init_pair(1,COLOR_BLUE,bgcolor);
  bluestr = COLOR_PAIR(1);
  init_pair(2,COLOR_RED,bgcolor);
  redstr = COLOR_PAIR(2);
  init_pair(3,COLOR_GREEN,bgcolor);
  greenstr = COLOR_PAIR(3);
  init_pair(4,COLOR_CYAN,bgcolor);
  cyanstr = COLOR_PAIR(4);
  init_pair(5,COLOR_YELLOW,bgcolor);
  yellowstr = COLOR_PAIR(5);
  init_pair(6,COLOR_MAGENTA,bgcolor);
  magentastr = COLOR_PAIR(6);

  keypad(stdscr,TRUE);

  init_stat();
  lines = LINES -3;

  signal(SIGINT,(void *)quit);

  x = 0;
  y = 2;
  ox = 0;
  oy = 2;
  move(y,cellx[x]);

  if(hv_crate() == -1){
    printf("crate number 0<N<10\n");
    quit();
  }
   first = 1;
  signal(SIGALRM,(void *)hv_update);
  mvcursol();
   
  while(1){
    noecho();
    key = getch();
    switch(key){
    case 'q':
    case 'Q':
      flag = -1;
      quit();
      break;
    case 'p':
    case 'P':
      page++;
      if(page >= npage){
	page = 0;
      }
      update_scr(1);
      update_cell(y,x,1);
      break;
    case 'e':
    case 'E':
      if(x != CELL_STAT){
	edit_cell();
      }
      break;
    case 'o':
    case 'O':
      if(x == CELL_STAT){
	if(hvstat[craten][y2ch(y)].onoff == 0){
	  hvstat[craten][y2ch(y)].onoff = 1;
#ifndef NOCAEN
	  sy403_hv_on(y2ch(y),craten);
#endif
	}else{
	  hvstat[craten][y2ch(y)].onoff = 0;
#ifndef NOCAEN
	  sy403_hv_off(y2ch(y),craten);
#endif
	}
	update_cell(y,x,1);
      }
      break;
    //case 'z':
    //case 'Z':
      //hv_zero();
      //mvcursol();
      //break;
    case 'c':
    case 'C':
      hv_crate();
      mvcursol();
      break;
    case 'l':
    case 'L':
      hv_load();
      mvcursol();
      break;
    case 's':
    case 'S':
      hv_save();
      mvcursol();
      break;
    case 'm':
    case 'M':
      hv_monitor();
      mvcursol();
      break;
    case 'u':
     case 'U':
      update_scr(2);
      mvcursol();
      break;
    case KEY_UP:
    case 16:
      oy = y;
      ox = x;
      y--;
      if(y<2){
	if(page == npage-1){
	  y = HVCHMAX % lines + 1;
	}else{
	  y=lines+1;
	}
      }
      mvcursol();
      break;
    case KEY_DOWN:
    case 14:
    case '\n':
      oy = y;
      ox = x;
      y++;
      if(y>=lines+2){y=2;}
      mvcursol();
      break;
    case KEY_LEFT:
    case 2:
      ox = x;
      oy = y;
      x--;
      if(x<0){x=CELL_STAT;}
      mvcursol();
      break;
    case KEY_RIGHT:
    case 6:
    case 9:
      ox = x;
      oy = y;
      x++;
      if(x>=CELLN){x=CELL_CH;}
      mvcursol();
      break;
    case 1:
      ox = x;
      oy = y;
      x = CELL_CH;
      mvcursol();
      break;
    case 5:
      ox = x;
      oy = y;
      x = CELL_STAT;
      mvcursol();
      break;
    case 12:
      update_scr(1);
      mvcursol();
      break;
    case KEY_RESIZE:
      lines = LINES-3;
       x = 0;
       y = 2;
       npage = HVCHMAX/lines;
   if(HVCHMAX%lines != 0)
     {
	npage++;
     }
       if(page >= npage){
	page = 0;
      }
      update_scr(1);
      mvcursol();
      break;
    default:
      break;
    }
    if(lines != LINES - 3){
      lines = LINES-3;
      update_scr(1);
      mvcursol();
    }
    if(flag == -1){
      break;
    }
  }

  return 0;
}
