/* segmonitor.c
   Mar 26, 2002
   Monitor of segment
*/

#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>

#include "dataclient.h"
#include "segdata.h"

#define         NORMAL_EVT      0
#define         END_BLK         1
#define         COMMENT_BLK     2
#define         ERROR_BLK       3

extern void *nari_getevt__(unsigned short *blkbuf,
	   unsigned short *evtbuf, unsigned short *blkflag);

unsigned short blkdata[BLKSIZE/2],evtdata[512];
unsigned short blkflag;
int flag,i,j,showseg[SEGSIZE],tmp;
char modestr[3][6];
int bgcolor = -1;
int mode,stopflag = 0;
/* mode 0 : Hex
        1 : Oct
        2 : Deg
*/

struct segdata segment[SEGSIZE];

void sigint(void){
  exit(0);
}

void printdata(int val){
  if(mode == 0){
    printf("%04x ",val);
  }else if(mode == 1){
    printf("%06o ",val);
  }else if(mode == 2){
    printf("%6d ",val);
  }
}

void update_screen(void){
  for(j=0;j<SEGNUM;j++){
    if(showseg[j] == 1){
      segsplit(evtdata,&segment[j]);

      printf("SEGMENT-%d : %2d word\n",j,segment[j].size);
      for(i=0;i<segment[j].size;i++){
	printdata(segment[j].data[i]);
	if(i != 0 && i%8 == 0){
	  printf("\n");
	}
      }
      printf("\n\n");
    }
  }
}

void showdata(void){
  if(stopflag == 0){
    getData(blkdata,&flag);
    if(flag == 0 && stopflag == 0){
      nari_getevt__(blkdata,evtdata,&blkflag);
      if(blkflag == NORMAL_EVT){
	update_screen();
      }
    }else{
    }
  }
  alarm(2);
}

int main(int argc,char *argv[]){
  int com;

  for(i=0;i<SEGNUM;i++){
    segment[i].id = i;
    showseg[i] = -1;
  }

  for(i=1;i<argc;i++){
    tmp = strtol(argv[i],NULL,0);
    if(tmp>0 && tmp<SEGNUM){
      showseg[tmp] = 1;
    }
  }

  memcpy(modestr[0],"%04x \0",6);
  memcpy(modestr[1],"%06o \0",6);
  memcpy(modestr[2],"%6d \0\0",6);

  /* Signal */
  signal(SIGINT,(void *)sigint);
  signal(SIGALRM,(void *)showdata);

  initDataClient();
  mode = 0;

  /* Get Data per 2s */
  alarm(2);

  while(1){
    com = getchar();
    switch((char)com){
    case 'q':
      exit(0);
      break;
    case 'x':
      mode = 0;
      update_screen();
      break;
    case 'o':
      mode = 1;
      update_screen();
      break;
    case 'd':
      mode = 2;
      update_screen();
      break;
    case 's':
      if(stopflag == 0){
	stopflag = 1;
      }else{
	stopflag = 0;
      }
      break;
    }
  }

  return 0;
}
