#include	<stdio.h>
#include	<stdlib.h>

#include "dataclient.h"

#define		NORMAL_EVT	0
#define		END_BLK		1
#define		COMMENT_BLK	2
#define		ERROR_BLK	3
#define		YES		1
#define		NO		0
#define		BUF_SIZE	(BLKSIZE/(sizeof(short)))

void *nari_getevt__(unsigned short *blkbuf,unsigned short *evtbuf,unsigned short *blkflag)
{
  int i;
  static int begin_flag = YES;
  static unsigned int buf_pt,event_size;
  if(begin_flag)	{
    /* Comment Block */
    if(0x0000 != blkbuf[0])	{
      /* Read a Comment */
      begin_flag = YES;
      *blkflag = COMMENT_BLK;
      return;
    }
    buf_pt = 4;
    /* Event Block */
    if((0x8000==(blkbuf[buf_pt]&0xf000)) && (0x0001 == blkbuf[buf_pt+1]))
      {
	/* Event is Exist */
	event_size = (blkbuf[buf_pt] & 0x0fff);
	if((event_size == 0) || ((buf_pt+event_size)>BUF_SIZE))	{
	  begin_flag = YES;
	  *blkflag = ERROR_BLK;
	  return;
	}
	/* Copy Event Data */
	for(i = 0;i < event_size;i++,buf_pt++)	{
	  *(evtbuf+i) = blkbuf[buf_pt];
	}
	begin_flag = NO;
	*blkflag = NORMAL_EVT;

	return;
      }
    else	{
      /* Event is not Exist */
      begin_flag = YES;
      *blkflag = ERROR_BLK;
      return;
    }
  }
  
  if((0x8000==(blkbuf[buf_pt]&0xf000)) && (0x0001==blkbuf[buf_pt+1]))	{
    /* Event is Exist */
    event_size = (blkbuf[buf_pt]&0x0fff);
    if((event_size == 0) || ((buf_pt+event_size)>BUF_SIZE))	{
      /* Abnormal Data */
      begin_flag = YES;
      *blkflag = ERROR_BLK;
      return;
    }
    /* Normal Data */
    /* Copy Event Data */
    for(i = 0;i < event_size;i++,buf_pt++)	{
      *(evtbuf+i) = blkbuf[buf_pt];
    }
    begin_flag = NO;
    *blkflag = NORMAL_EVT;
    return;
  }
  else{
    if((0xffff==blkbuf[buf_pt]) && (0xffff==blkbuf[buf_pt+1])){
      begin_flag = YES;
      *blkflag = END_BLK;
      return;
    }
    if((0x8000==(blkbuf[buf_pt]&0xf000)) && (0x7f00==blkbuf[buf_pt+1]))
      {
	/* Event is Scaler */
	begin_flag = YES;
	*blkflag = END_BLK;
	return;
      }
    else	{
      /* Event is not Exist */
      begin_flag = YES;
      *blkflag = ERROR_BLK;
      return;
    }
  }
  
  fprintf(stderr,"this is a bug!\n");
  exit(255);
}


