/* nbbqvio.c
   VME I/O Interface Driver
   H.Baba
   last modified : 11/08/04 19:56:35 
*/

#include <linux/version.h>
#if LINUX_VERSION_CODE >=  0x020600
#if defined(USE_MODVERSIONS) && USE_MODVERSIONS
#  define MODVERSIONS
#  include <config/modversions.h>
#endif
#endif

#include <linux/module.h>
#include <linux/kernel.h>
#if LINUX_VERSION_CODE >=  0x020600
#include <linux/init.h>
#endif
#include <linux/ioctl.h>
#include <linux/mm.h>
#include <linux/fs.h>
#include <linux/sched.h>
#if LINUX_VERSION_CODE <  0x020600
#include <linux/config.h>
#endif
#include <linux/pci.h>
#include <linux/errno.h>
#include <linux/poll.h>
#include <asm/io.h>
#include <asm/uaccess.h>
#include <linux/string.h>
#include "common.h"
#include "vioctrl.h"
#include "nbbqvio.h"

#if LINUX_VERSION_CODE >=  0x020410
MODULE_LICENSE("GPL");
#endif
#if LINUX_VERSION_CODE >=  0x020600
MODULE_AUTHOR("Hidetada Baba");
#ifndef MOD_IN_USE
#define MOD_IN_USE module_refcount(THIS_MODULE)
#endif
#ifndef MOD_INC_USE_COUNT
#define MOD_INC_USE_COUNT
#endif
#ifndef MOD_DEC_USE_COUNT
#define MOD_DEC_USE_COUNT
#endif
#endif


static int nbbqvio_major = NBBQVIO_MAJOR;
static const char *nbbqvio_name = "nbbqvio";
//static char *irq_name = "irq_nbbqvio";

ssize_t nbbqvio_read(struct file *file,char *buff,size_t count,loff_t *pos);
static int nbbqvio_open(struct inode* inode, struct file* filep);
static int nbbqvio_release(struct inode* inode, struct file* filep);
static int nbbqvio_ioctl(struct inode *inode, struct file *filep,
			 unsigned int cmd, unsigned long arg);
static unsigned int nbbqvio_poll(struct file *file,poll_table *wait);
//static void nbbqvio_interrupt(int irq,void *dev_id,struct pt_regs* regs);


static int chkbuff,chkblk;
#if LINUX_VERSION_CODE >=  0x020400
wait_queue_head_t nbbqvio_wait_queue;
#else
struct wait_queue *nbbqvio_wait_queue = NULL;
#endif

#if LINUX_VERSION_CODE >=  0x020600
static struct file_operations nbbqvio_fops = {
  .read = nbbqvio_read,
  .poll = nbbqvio_poll,
  .ioctl = nbbqvio_ioctl,
  .open = nbbqvio_open,
  .release = nbbqvio_release,
};
#else
#if LINUX_VERSION_CODE >=  0x020400
static struct file_operations nbbqvio_fops = {
  read: nbbqvio_read,
  poll: nbbqvio_poll,
  ioctl: nbbqvio_ioctl,
  open: nbbqvio_open,
  release: nbbqvio_release,
};
#else
static struct file_operations nbbqvio_fops = {
  NULL,             // loff_t  llseek
  nbbqvio_read,     // ssize_t read
  NULL,             // ssize_t write
  NULL,             // int     readdir
  nbbqvio_poll,     // uint    poll
  nbbqvio_ioctl,    // int     ioctl
  NULL,             // int     mmap
  nbbqvio_open,     // int     open
  NULL,             // int     flush
  nbbqvio_release,  // int     release
};
#endif
#endif

#if LINUX_VERSION_CODE >= 0x020600
int nbbqvio_init_module(void){
#else
int init_module(void){
#endif
  int ret;

  ret = register_chrdev(nbbqvio_major,nbbqvio_name,&nbbqvio_fops);
  if(ret < 0){
    printk("%s : can't regist.\n",nbbqvio_name);
    return ret;
  }
  if(nbbqvio_major == 0) {
    nbbqvio_major = ret;
  }

  //girq = get_irq();
  chkbuff = 0;

#if LINUX_VERSION_CODE >=  0x020400
  init_waitqueue_head(&nbbqvio_wait_queue);
#endif

  printk("%s : nbbqvio was installed.\n",nbbqvio_name);

  return 0;
}

#if LINUX_VERSION_CODE >= 0x020600
void nbbqvio_cleanup_module(void){
#else
void cleanup_module(void){
#endif
  unregister_chrdev(nbbqvio_major,nbbqvio_name);
  printk("%s: nbbqvio was unregistered.\n", nbbqvio_name);
}

static int nbbqvio_open(struct inode* inode, struct file* filep){

  if(MOD_IN_USE){
    return -EBUSY;
  }

  chkblk = 0;

  /* ret = request_irq(girq,nbbqvio_interrupt,SA_INTERRUPT,nbbqvio_name,irq_name); */

  MOD_INC_USE_COUNT;

  return 0;
}

static int nbbqvio_release(struct inode* inode, struct file* filep){

  MOD_DEC_USE_COUNT;

  return 0;
}

ssize_t nbbqvio_read(struct file *file,char *buff,size_t count,loff_t *pos){

  /* copy_to_user(buff,data,sizeof(data)); */

  return 1;
}


static int nbbqvio_ioctl(struct inode* inode, struct file *filep,
			 unsigned int cmd, unsigned long arg){
  unsigned short sval=0;
  unsigned int addr, lval=0, x;
#ifdef ISERIES
  unsigned int dn = 0;
#endif

  /* printk("filep->f_version     : %lu \n",filep->f_version); */
  /* printk("MINOR(inode->i_rdev) : %d \n",MINOR(inode->i_rdev)); */

  //printk("nbbqvio_ioctl cmd=%d\n", cmd);

  switch(cmd){
  case NBBQVIO_AMSR:
    /* int am */
    x = copy_from_user(&lval,(void *)arg,4);
    set_amsr((char)lval);
    break;
  case NBBQVIO_READ16:
    /* ulong addr, ushort data */
    x =copy_from_user(&addr,(void *)arg,4);
    vread16(addr,&sval);
    x = copy_to_user((void *)arg+4,&sval,2);
    break;
  case NBBQVIO_READ32:
  case NBBQVIO_READ32B:   // com=9, some linuxes can't use com=2
    /* ulong addr, ulong data */
    x = copy_from_user(&addr,(void *)arg,4);
    vread32(addr,&lval);
    x = copy_to_user((void *)arg+4,&lval,4);
    break;
  case NBBQVIO_WRITE16:
    /* ulong addr, ushort data */
    x = copy_from_user(&addr,(void *)arg,4);
    x = copy_from_user(&sval,(void *)arg+4,2);
    vwrite16(addr,&sval);
    break;
  case NBBQVIO_WRITE32:
    /* ulong addr, ulong data */
    x = copy_from_user(&addr,(void *)arg,4);
    x = copy_from_user(&lval,(void *)arg+4,4);
    vwrite32(addr,&lval);
    break;
  case NBBQVIO_DMAR16:
    break;
  case NBBQVIO_DMAR32:
    break;
  case NBBQVIO_DMAW16:
    break;
  case NBBQVIO_DMAW32:
    break;
#ifdef ISERIES
    /* i-seriese */
  case NBBQVIO_AMSR_I:
    /* int am */
    x = copy_from_user(&lval,(void *)arg,4);
    x = copy_from_user(&dn,(void*)arg+4,4);
    set_amsr_i((char)lval,dn);
    break;
  case NBBQVIO_READ16_I:
    /* ulong addr, ushort data */
    x = copy_from_user(&addr,(void *)arg,4);
    x = copy_from_user(&dn,(void *)arg+4,4);
    vread16_i(addr,&sval,dn);
    x = copy_to_user((void *)arg+8,&sval,2);
    break;
  case NBBQVIO_READ32_I:
    /* ulong addr, ulong data */
    x = copy_from_user(&addr,(void *)arg,4);
    x = copy_from_user(&dn,(void *)arg+4,4);
    vread32_i(addr,&lval,dn);
    x = copy_to_user((void *)arg+8,&lval,4);
    break;
  case NBBQVIO_WRITE16_I:
    /* ulong addr, ushort data */
    x = copy_from_user(&addr,(void *)arg,4);
    x = copy_from_user(&sval,(void *)arg+4,2);
    x = copy_from_user(&dn,(void *)arg+8,4);
    vwrite16_i(addr,&sval,dn);
    break;
  case NBBQVIO_WRITE32_I:
    /* ulong addr, ulong data */
    x = copy_from_user(&addr,(void *)arg,4);
    x = copy_from_user(&lval,(void *)arg+4,4);
    x = copy_from_user(&dn,(void *)arg+8,4);
    vwrite32_i(addr,&lval,dn);
    break;
  case NBBQVIO_DMAR16_I:
    break;
  case NBBQVIO_DMAR32_I:
    break;
  case NBBQVIO_DMAW16_I:
    break;
  case NBBQVIO_DMAW32_I:
    break;
#endif
  default:
    return -EINVAL;
    break;
  }
  return 0;
}

static unsigned int nbbqvio_poll(struct file *file,poll_table *wait){
  poll_wait(file,&nbbqvio_wait_queue,wait);
  if(chkbuff == 1){
    return POLLIN;
  }else{
    return 0;
  }
}

/*
  static void nbbqvio_interrupt(int irq, void* dev_id, struct pt_regs* regs){
  wake_up_interruptible(&nbbqvio_wait_queue);
  }
*/

#if LINUX_VERSION_CODE >= 0x020600
module_init(nbbqvio_init_module);
module_exit(nbbqvio_cleanup_module);
#endif
