#!/usr/bin/perl

$input;
$cp = '/bin/cp';
$drv = '/usr/nbbq/nbbqdrv';

# initialize
$bbrl = -1;
$bbdaq = -1;
$CC7700 = -1;
$CCNET = -1;
$K2915 = -1;
$MAXBUFF = '0x1e00';
$LAMN  = -1;
$LAMA  = -1;
$LAMFC = -1;
$LAMEN = -1;
$LAMDA = -1;
$OPRN     = -1;
$OPBUSYCL = -1;
$READ1N  = -1;
$READ1L  = -1;
$READ1AR = -1;
$READ1FR = -1;
$READ1AC = -1;
$READ1FC = -1;
$READ2N  = -1;
$READ2L  = -1;
$READ2AR = -1;
$READ2FR = -1;
$READ2AC = -1;
$READ2FC = -1;
$READ3N  = -1;
$READ3L  = -1;
$READ3AR = -1;
$READ3FR = -1;
$READ3AC = -1;
$READ3FC = -1;


if($ARGV[0]){
  $input = $ARGV[0];
}else{
  $input = stdin;
  print "nbbqsetup filename\n";
  exit(0);
}

open(IN,"< $input");
@data = <IN>;
close(IN);

foreach $line (@data){
  if($line =~ /^\#/ or $line =~ /^\n/){
  }else{
    $line =~ s/ //g;
    $line =~ s/\n//g;
    ($com,$val) = split(/:/,$line);
    $$com = $val;
  }
}

if($bbrl == -1 && $bbdaq == -1){
  print "error, daq mode (bbrl or bbdaq)\n";
  exit(0);
}

if($CC7700 == -1 && $K2915 == -1 && $CCNET == -1){
  print "error, select crate controller (CC7700 or CCNET or K2915)\n";
  exit(0);
}

if($bbdaq != -1){
  $daqmode = 'BBDAQ';
}elsif($bbrl != -1){
  $daqmode = 'BBRL';
}

if($CC7700 != -1){
  $ccmode = 'cc77';
}elsif($K2915 != -1){
  $ccmode = 'k2915';
}elsif($CCNET != -1){
  $ccmode = 'ccnet';
}

if($LAMN == -1){
  print "error, LAMN is not define.\n";
  exit(0);
}
if($LAMA == -1){
  print "error, LAMA is not define.\n";
  exit(0);
}
if($LAMFC == -1){
  print "error, LAMFC is not define.\n";
  exit(0);
}
if($LAMEN == -1){
  print "error, LAMEN is not define.\n";
  exit(0);
}
if($LAMDA == -1){
  print "error, LAMDA is not define.\n";
  exit(0);
}

if($OPRN != -1 and $OPBUSYCL == -1){
  print "OPRN is defined, but OPBUSYCL is not define\n";
  exit(0);
}

open(OUT,"> bbmodules.h");
print OUT "#define $daqmode\n";
print OUT "#define MAXBUFF $MAXBUFF\n";
print OUT "#define CAMAC\n";
print OUT "#define CAMACINT\n";
if($ccmode eq 'cc77'){
  print OUT "#define CC7700\n";
}elsif($ccmode eq 'k2915'){
  print OUT "#define K2915\n";
}else{
  print OUT "#define CCNET\n";
}

print OUT "\n";
print OUT "#define LAMN    $LAMN\n";
print OUT "#define LAMA    $LAMA\n";
print OUT "#define LAMFC   $LAMFC\n";
print OUT "#define LAMEN   $LAMEN\n";
print OUT "#define LAMDA   $LAMDA\n";
print OUT "\n";
if($OPRN != -1){
  print OUT "#define OPRN     $OPRN\n";
  print OUT "#define OPBUSYCL $OPBUSYCL\n";
}
if($READ1N != -1){
print OUT "#define READ1N  $READ1N\n";
print OUT "#define READ1L  $READ1L\n";
print OUT "#define READ1AR $READ1AR\n";
print OUT "#define READ1FR $READ1FR\n";
print OUT "#define READ1AC $READ1AC\n";
print OUT "#define READ1FC $READ1FC\n";
}
if($READ2N != -1){
print OUT "#define READ1N  $READ2N\n";
print OUT "#define READ1L  $READ2L\n";
print OUT "#define READ1AR $READ2AR\n";
print OUT "#define READ1FR $READ2FR\n";
print OUT "#define READ1AC $READ2AC\n";
print OUT "#define READ1FC $READ2FC\n";
}
if($READ3N != -1){
print OUT "#define READ1N  $READ3N\n";
print OUT "#define READ1L  $READ3L\n";
print OUT "#define READ1AR $READ3AR\n";
print OUT "#define READ1FR $READ3FR\n";
print OUT "#define READ1AC $READ3AC\n";
print OUT "#define READ1FC $READ3FC\n";
}
close(OUT);

print "setup file to bbmodules.h complete.\n";

system("$cp $drv/startup.c.auto ./startup.c");
system("$cp $drv/evt.c.auto ./evt.c");
system("$cp $drv/clear.c.auto ./clear.c");
system("$cp $drv/stop.c.auto ./stop.c");
system("$cp $drv/sca.c.auto ./sca.c");
system("$cp $drv/nbbqdrv.c ./");
system("$cp $drv/nbbqctrl.h ./");
system("$cp $drv/bbrl.c ./");
system("$cp $drv/bbdaq.c ./");
system("$cp $drv/nbbqdrv.h ./");
system("$cp $drv/nbbqio.h ./");
system("$cp $drv/def-*.h ./");
system("$cp $drv/bb-*.h ./");
system("$cp $drv/common.h ./");
system("$cp $drv/Makefile ./");

system("make clean;make");

exit(0);
