/* nbbqcom.c
   NBBQ User Control Application

   Feb24, 2002  H.Baba
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <time.h>
#include <ncurses.h>
#include <pthread.h>

#define BBRLMODE  1
#define BBDAQMODE 2

#include "multisender2.c"
#include "nbbqio.h"

#ifndef NCURSES_VERSION
#define attr_t long
#define getnstr(s,n) getstr(s)
#endif

#define RUNINFO "runinfo.txt"
#define RUNCNT  "runcounter.txt"


unsigned short data[0x2000];
char filename[256],buffer[80],header[256],anahost[256];
int fd,mode;
fd_set fdset;
FILE *rdffd;
int i,size,runnumber;
volatile int savemode,startflag,wthflag;
char flag;
attr_t cyanstr,magentastr,redstr,greenstr;
time_t starttime,stoptime,nowtime;
pthread_t daqthread;

void daq_start(void);
void daq_stop(void);
void open_drv(void);
void sig(void);

void sig(void){
  if(startflag == 0){
    printf("exit\n");
    exit(0);
  }else{
    printf("Now running...\n");
  }
}

void print_help(void){
  printf("#############     HELP     ##############\n");
  printf("# wth / header : Write Header           #\n");
  printf("# start        : Run Start (save mode)  #\n");
  printf("# nssta        : No save mode run Start #\n");
  printf("# stop         : Run Stop               #\n");
  printf("# status       : Print Status           #\n");
  printf("# exit         : Exit COM               #\n");
  printf("#########################################\n");
}

void update_log(void){
  FILE *logfd,*cntfd;

  if((logfd = fopen(RUNINFO,"a")) == NULL){
    perror("Can't open runinfo.txt.\n");
  }else{
    fprintf(logfd,"RUN%04d\n",runnumber);
    fprintf(logfd,"START : %s",ctime(&starttime));
    fprintf(logfd,"STOP  : %s\n\n",ctime(&stoptime));
    fclose(logfd);
  }
  if((cntfd = fopen(RUNCNT,"w")) == NULL){
    perror("Can't open runcounter.txt.\n");
  }else{
    fprintf(cntfd,"%d",runnumber);
    fclose(cntfd);
  }
}

void read_runcnt(void){
  FILE *cntfd;

  if((cntfd = fopen(RUNCNT,"r")) == NULL){
  }else{
    fscanf(cntfd,"%d",&runnumber);
    fclose(cntfd);
  }
}

void print_mode(void){
  if(mode == BBRLMODE){
    printw("BBRL MODE");
    refresh();
    printf("\n");
  }else{
    printw("BBDAQ MODE");
    refresh();
    printf("\n");
  }
}

void print_status(void){
  time(&nowtime);
  print_mode();
  attron(A_BOLD);
  if(startflag == 0){
    attron(greenstr);
    printw("Now stopping...  %s",ctime(&nowtime));
    refresh();
    attroff(greenstr);
    printf("\n");
    printw("Next run is %04d",runnumber+1);
    refresh();
  }else if(startflag == 1){
    attron(redstr);
    printw("%04d running... %s",runnumber,ctime(&starttime));
    attroff(redstr);
    refresh();
  }else if(startflag == 2){
    attron(redstr);
    printw("No save mode running... %s\n",ctime(&starttime));
    attroff(redstr);
    refresh();
  }else if(startflag == 3){
    attron(redstr);
    printw("%04d stoped",runnumber);
    refresh();
    printf("\n");
    printw("start : %s",ctime(&starttime));
    refresh();
    printf("\n");
    printw("stop  : %s",ctime(&stoptime));
    attroff(redstr);
    refresh();
  }
  attroff(A_BOLD);
  printf("\n");
}


int exec_com(void){
  if(strncmp(buffer,"start",5) == 0){
    if(startflag == 0){
      if(wthflag == 1){
	savemode = 1;
	startflag = 1;
	runnumber += 1;
	time(&starttime);
	stoptime = 0;
	print_status();
	open_file();
	open_drv();
	pthread_create(&daqthread,NULL,(void *)&daq_start,NULL);
      }else{
	printf("No header.\n");
      }
    }else{
      printf("Now running...\n");
    }
    return 1;
  }else if(strncmp(buffer,"nssta",5) == 0){
    if(startflag == 0){
      startflag = 2;
      savemode = 0;
      time(&starttime);
      stoptime = 0;
      print_status();
      open_drv();
      pthread_create(&daqthread,NULL,(void *)&daq_start,NULL);
    }else{
      printf("Now running...\n");
    }
  }else if(strncmp(buffer,"stop",4) == 0){
    if(startflag != 0){
      startflag = 0;
      wthflag = 0;
      /* pthread_exit(NULL); */
      daq_stop();
      if(savemode == 1){
	update_log();
      }
      savemode = 0;
    }else{
      printf("Not running...\n");
    }
  }else if(strncmp(buffer,"exit",4) == 0){
    if(startflag == 0){
      printf("exit\n");
      return -1;
    }else{
      printf("Now running...\n");
    }
  }else if(strncmp(buffer,"status",6) == 0){
    print_status();
  }else if(strncmp(buffer,"help",4) == 0){
    print_help();
  }else if(strncmp(buffer,"wth",3) == 0 ||
	   strncmp(buffer,"header",6) == 0){
    attron(A_BOLD);
    printw("Header: ");
    attron(magentastr);
    getnstr(header,256);
    attroff(magentastr);
    attroff(A_BOLD);
    printw("\n");
    printf("\n");
    wthflag = 1;

    return 1;
  }else{
    printf("%s : Command not fount.\n",buffer);
  }
  return 1;
}


new_command(char *buffer, int length, attr_t cyanstr){
    int code;

    attron(A_BOLD);
    printw("Command: ");
    attron(cyanstr);
    code = getnstr(buffer,length);
    attroff(cyanstr);
    attroff(A_BOLD);
    printw("\n");

    return code;
}

void open_drv(void){
#ifndef DEBUG
  if((fd = open("/dev/nbbqdrv",O_RDWR)) < 0){
    perror("Can't open /dev/nbbqdrv.\n");
    exit(1);
  }
#endif
}

void daq_start(void){
  FD_ZERO(&fdset);
  FD_SET(fd,&fdset);

#ifndef DEBUG
  while(startflag == 1 || startflag == 2){
    if(select(fd+1,&fdset,NULL,NULL,NULL) != 0){
      read(fd,(char *)data,sizeof(data));
      if(data[2] != 0){
	size = data[2]+3;
      }else{
	size = 0x2000;
      }
      multisend((char *)data,size);
      if(savemode == 1){
	fwrite(data,2,size,rdffd);
      }
    } 
  }
#endif
  pthread_exit(NULL);
}

void daq_stop(void){
#ifndef DEBUG
  ioctl(fd,NBBQ_STOP,&flag);
  if(flag == 1){
    if(select(fd+1,&fdset,NULL,NULL,NULL) != 0){
      read(fd,(char *)data,sizeof(data));
      if(data[2] != 0){
	size = data[2]+3;
      }else{
	size = 0x2000;
      }
      multisend((char *)data,size);
      if(savemode == 1){
	fwrite(data,2,size,rdffd);
      }
    }
  }
  if(savemode == 1){
    fclose(rdffd);
  }
  close(fd);
#endif

  time(&stoptime);
  startflag = 3;
  print_status();
  startflag = 0;
}


int open_file(void){
  if(mode == BBRLMODE){
    sprintf(filename,"%04d.rdf",runnumber);
  }else{
    sprintf(filename,"%04d.dat",runnumber);
  }
#ifndef DEBUG
  if((rdffd = fopen(filename,"w")) == NULL){
    printf("Can't open data file.\n");
    return -1;
  }
#endif
  return 0;
}

int main(int argc,char *argv[]){
  FILE *cfd;

  memset(filename,0,sizeof(filename));

  if(strcmp(argv[0],"bbdaqcom") == 0){
    mode = BBDAQMODE;
  }else{
    mode = BBRLMODE;
  }

  starttime = 0;
  stoptime = 0;
  signal(SIGINT,(void *)sig);

  read_runcnt();
  multisender();
  if((cfd = fopen("clihosts.txt","r")) != NULL){
    while(fscanf(cfd,"%s\n",anahost) > 0){
      /* printf("%s\n",anahost); */
      if(addclient(anahost,mode) == -1){
        printf("No such host %s\n",anahost);
        exit(0);
      }
    }
    fclose(cfd);
  }else{
    addclient("localhost",mode);
  }

  filter();
  (void) newterm((char *) 0, stdout, stdin);
  cbreak();
  keypad(stdscr, TRUE);

  if (has_colors()) {
    int background = -1;
    start_color();
    if (use_default_colors() == ERR){
      background = COLOR_BLACK;
    }
    init_pair(1, COLOR_CYAN, background);
    cyanstr = COLOR_PAIR(1);
    init_pair(2, COLOR_MAGENTA, background);
    magentastr = COLOR_PAIR(2);
    init_pair(3, COLOR_RED, background);
    redstr = COLOR_PAIR(3);
    init_pair(4, COLOR_GREEN, background);
    greenstr = COLOR_PAIR(4);
  } else {
    cyanstr = A_UNDERLINE;
  }

  print_mode();
  touchwin(stdscr);
  erase();
  refresh();

  while(new_command(buffer,sizeof(buffer)-1,cyanstr) != ERR){
    reset_shell_mode();
    printf("\n");
    fflush(stdout);
    /* Command */
    if(exec_com() == -1){
      break;
    }
    fflush(stdout);
    reset_prog_mode();
    touchwin(stdscr);
    erase();
    refresh();
  }
  printw("done");
  refresh();
  endwin();

  return 0;
}
