/* nbbqcom2.c
   NBBQ User Control Application
   Double buffering mode

   last modified : 10/04/07 11:33:14 
   H.Baba
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <string.h>
#include <time.h>

#ifndef NOREADLINE
#include <readline/readline.h>
#include <readline/history.h>
#endif

#ifdef NOREADLINE
#define readline(NULL) gets(buffer)
#endif

#define BBRLMODE  1
#define BBDAQMODE 2

#define HDLISTFILE "hdlist.txt"
#define MAXHD      10

#include "bbcpri.h"
#include "nbbqio.h"
#include "multisender.h"

#define RUNINFO "runinfo.txt"
#define RUNCNT  "runcounter.txt"

#include "./common.h"
#ifndef BLKSIZE
#define BLKSIZE 0x4000
#endif

unsigned short *data;
char filename[MAXHD][256],buffer[256],header[256],anahost[256];
char fdir[MAXHD][256];
char ender[256],header2[80],ender2[80];
int fd,mode;
fd_set fdset;
FILE *rdffd[MAXHD];
int i,size,runnumber;
volatile int savemode,startflag,wthflag;
char flag,stbuff[256],comment[100];
time_t starttime,stoptime,nowtime,ttime;
struct tm *strtime;
char chrunnumber[7],chstart[18],chstop[18],chprint[18],chdate[14];
char *line;
int blksize = BLKSIZE;

void daq_start(void);
void daq_stop(void);
void open_drv(void);
void sig(void);
int open_file(void);
int make_comment(int md);

void sig(void){
  if(startflag == 0){
    printf("exit\n");
    free(data);
    exit(0);
  }else{
    printf("Now running...\n");
  }
}

void print_help(void){
  printf("#############     HELP     ##############\n");
  printf("# wth / header : Write Header           #\n");
  printf("# start        : Run Start (save mode)  #\n");
  printf("# nssta        : No save mode run Start #\n");
  printf("# stop         : Run Stop               #\n");
  printf("# status       : Print Status           #\n");
  printf("# exit         : Exit COM               #\n");
  printf("#########################################\n");
}

void update_log(void){
  FILE *logfd,*cntfd;

  if((logfd = fopen(RUNINFO,"a")) == NULL){
    perror("Can't open runinfo.txt.\n");
  }else{
    fprintf(logfd,"RUN%04d\n",runnumber);
    fprintf(logfd,"START : %s",ctime(&starttime));
    fprintf(logfd,"STOP  : %s",ctime(&stoptime));
    fprintf(logfd,"%s\n",header);
    fprintf(logfd,"%s\n\n\n",ender);
    fclose(logfd);
  }
  if((cntfd = fopen(RUNCNT,"w")) == NULL){
    perror("Can't open runcounter.txt.\n");
  }else{
    fprintf(cntfd,"%d",runnumber);
    fclose(cntfd);
  }
}

void read_runcnt(void){
  FILE *cntfd;

  if((cntfd = fopen(RUNCNT,"r")) == NULL){
  }else{
    fscanf(cntfd,"%d",&runnumber);
    fclose(cntfd);
  }
}

void read_fdir(void){
  int hdi;
  FILE *flistfd;

  memset(fdir, 0, sizeof(fdir));
  for(hdi=0;hdi<MAXHD;hdi++){
    rdffd[hdi] = NULL;
  }

  if((flistfd = fopen(HDLISTFILE, "r")) == NULL){
    printf("without hdlist.txt\n");
    strcpy(fdir[0], "./");
    printf("fdir %s\n", fdir[0]);
  }else{
    hdi = 0;
    while(!feof(flistfd)){
      fscanf(flistfd, "%s\n", fdir[hdi]);
      if(strlen(fdir[hdi]) > 0){
	hdi++;
      }else{
	fdir[hdi][0] = 0;
      }
    }
  }

}

void print_mode(void){
  if(mode == BBRLMODE){
    cprintf(AT_BOLD,"BBRL MODE\n");
  }else{
    cprintf(AT_BOLD,"BBDAQ MODE\n");
  }
}

void print_status(void){
  time(&nowtime);

  if(startflag == 0){
    print_mode();
    ccprintf(AT_BOLD,FG_RED,"Now stopping...  %s\n",ctime(&nowtime));
    ccprintf(AT_BOLD,FG_GREEN,"Next run is RUN%04d",runnumber+1);
  }else if(startflag == 1){
    ccprintf(AT_BOLD,FG_RED,"RUN%04d running... %s",runnumber,ctime(&starttime));
  }else if(startflag == 2){
    ccprintf(AT_BOLD,FG_RED,"No save mode running... %s\n",ctime(&starttime));
  }else if(startflag == 3){
    if(savemode == 1){
      ccprintf(AT_BOLD,FG_RED,"RUN%04d stoped",runnumber);
    }else{
      ccprintf(AT_BOLD,FG_RED,"No save run stoped");
    }
    printf("\n");
    cprintf(AT_BOLD,"start : %s",ctime(&starttime));
    cprintf(AT_BOLD,"stop  : %s",ctime(&stoptime));
  }
  printf("\n");
}


int exec_com(void){
  if(strncmp(buffer,"start",5) == 0){
    if(startflag == 0){
      if(wthflag == 1){
#ifndef DEBUG2
	open_drv();	
#endif
	savemode = 1;
	startflag = 1;
	runnumber += 1;
	time(&starttime);
	stoptime = 0;
	print_status();
	open_file();
	daq_start();
	/* pthread_create(&daqthread,NULL,(void *)&daq_start,NULL); */
      }else{
	printf("No header.\n");
      }
    }else{
      printf("Now running...\n");
    }
    return 1;
  }else if(strncmp(buffer,"nssta",5) == 0){
    if(startflag == 0){
#ifndef DEBUG2
      open_drv();
#endif
      startflag = 2;
      savemode = 0;
      time(&starttime);
      stoptime = 0;
      print_status();
      daq_start();
      /* pthread_create(&daqthread,NULL,(void *)&daq_start,NULL); */
    }else{
      printf("Now running...\n");
    }
  }else if(strncmp(buffer,"exit",4) == 0){
    if(startflag == 0){
      printf("exit\n");
      return -1;
    }else{
      printf("Now running...\n");
    }
  }else if(strncmp(buffer,"status",6) == 0){
    print_status();
  }else if(strncmp(buffer,"help",4) == 0){
    print_help();
  }else if(strncmp(buffer,"wth",3) == 0 ||
	   strncmp(buffer,"header",6) == 0){
    cprintf(AT_BOLD,"Header: ");
    line = readline(NULL);
    strncpy(header,line,256);
    printf("\n");
    wthflag = 1;
#ifndef NOREADLINE
    free(line);
#endif

    return 1;
  }else{
    printf("%s : Command not fount.\n",buffer);
  }
  return 1;
}


int new_command(char *buffer){

    ccprintf(AT_BOLD,FG_CYAN,"Command: ");
    line = readline(NULL);
    strncpy(buffer,line,256);
#ifndef NOREADLINE
    free(line);
#endif

    return 1;
}

void open_drv(void){
#ifndef DEBUG
  if((fd = open("/dev/nbbqdrv",O_RDWR)) < 0){
    perror("Can't open /dev/nbbqdrv.\n");
    exit(1);
  }
#endif
}

void daq_start(void){
  int eiflag, hdi;

  printf("[Enter stop] : \n");

  while(startflag == 1 || startflag == 2){
    FD_ZERO(&fdset);
    FD_SET(fd,&fdset);
    FD_SET(0,&fdset);
    if(select(fd+1,&fdset,NULL,NULL,NULL) != 0){
      if(FD_ISSET(0,&fdset)){
	memset(stbuff,0,256);
	line = readline(NULL);
	strncpy(stbuff,line,256);
#ifndef NOREADLINE
	free(line);
#endif
	if(strcmp(stbuff,"stop") == 0){
	  daq_stop();
	  printf("\n");
	}
      }
#ifndef DEBUG
      else{
	read(fd,(char *)data,BLKSIZE);
	if(mode == BBDAQMODE){
	  size = data[2]+3;
	}else{
	  size = blksize/2;
	}
	multisend((char *)data,size*2);
	if(savemode == 1){
	  for(hdi=0;hdi<MAXHD;hdi++){
	    if(rdffd[hdi]){
	      fwrite(data,2,size,rdffd[hdi]);
	    }
	  }
	}
	ioctl(fd,NBBQ_EI,&eiflag);
      }
#endif
    }
  }

#ifndef DEBUG2
#ifndef DEBUG
  close(fd);
#endif
#endif
}

void daq_stop(void){
  int i, hdi;

  startflag = 3;
#ifndef DEBUG
  ioctl(fd,NBBQ_STOPB,&flag);
  FD_ZERO(&fdset);
  FD_SET(fd,&fdset);

#ifndef DEBUG2
  for(i=0;i<flag;i++){
    if(select(fd+1,&fdset,NULL,NULL,NULL) != 0){
      read(fd,(char *)data,BLKSIZE);
      if(mode == BBDAQMODE){
	size = data[2]+3;
      }else{
	size = blksize/2;
      }
      multisend((char *)data,size*2);
#endif
      if(savemode == 1){
	for(hdi=0;hdi<MAXHD;hdi++){
	  if(rdffd[hdi]){
	    fwrite(data,2,size,rdffd[hdi]);
	  }
	}
      }
#ifndef DEBUG2
    }
  }
#endif
  if(savemode == 1){
    cprintf(AT_BOLD,"Ender: ");
    line = readline(NULL);
    strncpy(ender,line,256);
    printf("\n");
#ifndef NOREADLINE
    free(line);
#endif
    if(mode == BBRLMODE){
      make_comment(1);
    }
    for(hdi=0;hdi<MAXHD;hdi++){
      if(rdffd[hdi]){
	fclose(rdffd[hdi]);
      }
    }
  }
#endif

  time(&stoptime);
  print_status();
  startflag = 0;
  wthflag = 0;
  /* pthread_exit(NULL); */
  if(savemode == 1){
    update_log();
  }
  savemode = 0;
}


int make_comment(int md){
  /* md == 0 : Header
     md == 1 : Ender  */
  int i,stlen, hdi;

  if(md == 0){
    ttime = starttime;
  }else{
    ttime = stoptime;
  }
  strtime = localtime(&ttime);
  sprintf(chrunnumber,"RUN-%04d",runnumber);
  if(md == 0){
    strftime(chstart,18,"START => %X",strtime);
    strftime(chstop,18," STOP => XX:XX:XX",strtime);
  }else{
    strftime(chstop,18," STOP => %X ",strtime);
  }
  sprintf(chprint,"Print -> XX:XX:XX ");
  strftime(chdate,14," %d-%b-%y",strtime);
  memset(comment,0x20,sizeof(comment));
  if(md == 0){
    comment[0] = 0x01;
    comment[1] = 0x00;
  }else{
    comment[0] = 0xff;
    comment[1] = 0xff;
  }
  for(i=2;i<20;i++){
    comment[i] = 0;
  }
  memcpy(comment+20,chrunnumber,8);
  memcpy(comment+30,chstart,17);
  memcpy(comment+48,chstop,17);
  memcpy(comment+68,chprint,18);
  memcpy(comment+86,chdate,10);
  memset(comment+96,0,4);

  memset(data,0,BLKSIZE);
  memcpy(data,comment,sizeof(comment));


  if(md == 0){
    memset(header2,' ',sizeof(header2));
    memset(ender2,' ',sizeof(ender2));
    stlen = strlen(header);
    if(stlen > sizeof(header2)){
      stlen = sizeof(header2);
    }
    memcpy(header2,header,stlen);
  }else{
    stlen = strlen(ender);
    if(stlen > sizeof(header2)){
      stlen = sizeof(header2);
    }
    strncpy(ender2,ender,stlen);
  }

  memcpy(data+50,header2,sizeof(header2));
  memcpy(data+90,ender2,sizeof(ender2));

  for(hdi=0;hdi<MAXHD;hdi++){
    if(rdffd[hdi]){
      fwrite(data,2,blksize/2,rdffd[hdi]);
    }
  }


  return 0;
}


int open_file(void){
  int hdi;

  memset(filename, 0, sizeof(filename));
  for(hdi=0;hdi<MAXHD;hdi++){
    if(strlen(fdir[hdi]) > 0){
      if(mode == BBRLMODE){
	sprintf(filename[hdi],"%s/%04d.rdf",fdir[hdi], runnumber);
      }else{
	sprintf(filename[hdi],"%s/%04d.dat",fdir[hdi], runnumber);
      }
#ifndef DEBUG
      if((rdffd[hdi] = fopen(filename[hdi],"w")) == NULL){
	printf("Can't open data file %s (dir[%d]=%s).\n", filename[hdi],hdi,fdir[hdi]);
	return -1;
      }
    }
  }

  if(mode == BBRLMODE){
    make_comment(0);
  }
#endif
  return 0;
}

int main(int argc,char *argv[]){
  FILE *cfd;

  memset(filename,0,sizeof(filename));

  data = malloc(BLKSIZE);
  if(data == NULL){
    printf("Can't allocate memory.");
    exit(0);
  }

  memset(data, 0, BLKSIZE);

  if(strcmp(argv[0],"bbdaqcom") == 0){
    mode = BBDAQMODE;
  }else{
    mode = BBRLMODE;
  }

  starttime = 0;
  stoptime = 0;
  signal(SIGINT,(void *)sig);

  read_runcnt();
  read_fdir();
  for(i=0;i<MAXHD;i++){
    if(strlen(fdir[i]) > 0){
      printf("output dir[%d] : %s\n", i, fdir[i]);
    }
  }

  multisender();
  if((cfd = fopen("clihosts.txt","r")) != NULL){
    while(fscanf(cfd,"%s\n",anahost) > 0){
      /* printf("%s\n",anahost); */
      if(addclient(anahost,mode) == -1){
        printf("No such host %s\n",anahost);
        exit(0);
      }
    }
    fclose(cfd);
  }else{
    addclient("localhost",mode);
  }

  print_mode();

  while(new_command(buffer) != -1){
    printf("\n");
    /* Command */
    if(exec_com() == -1){
      break;
    }
  }

  return 0;
}
