/* multisender2.c
   This program transfer Data to multi client with UDP.
   Nov 5, 2002
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include <string.h>

#define BBRLMODE  1
#define BBDAQMODE 2

#include "./common.h"

/* for multi client */
struct sockaddr_in cliaddr[10];
static int clinum;
int multisock;

int multisend(char *buf,int size){
  int i,ret = 0;
  for(i=0;i<clinum;i++){
    ret = sendto(multisock,buf,size,0,(struct sockaddr *)&cliaddr[i],sizeof(cliaddr[i]));
  }
  return ret;
}

void multiclose(void){
  shutdown(multisock,2);
  close(multisock);
}

void multisender(void){
  clinum = 0;

  if((multisock = socket(AF_INET,SOCK_DGRAM,0)) < 0){
    perror("Can't make Socket. Error in multisender");
    exit(1);
  }
}

int addclient(char *host,int mode){
  struct hostent *hp;
  int ret = 0;

  if((hp = gethostbyname(host)) == NULL){
    //perror("No such host");
    //exit(1);
    ret = 2;
  }else if(clinum < 10){
    /* bcopy(hp->h_addr,&cliaddr[clinum].sin_addr,hp->h_length); */
    memcpy(&cliaddr[clinum].sin_addr,hp->h_addr,hp->h_length);
    cliaddr[clinum].sin_family = AF_INET;
    if(mode == BBRLMODE){
      cliaddr[clinum].sin_port = htons(ANAPORT);
    }else{
      cliaddr[clinum].sin_port = htons(MONITORPORT);
    }
    clinum++;
    ret = 1;
  }

  return ret;
}
