/* nbbqccio.c
   CAMAC I/O Interface Driver

   last modified : 08/06/28 21:21:33 
*/

#include <linux/version.h>
#if LINUX_VERSION_CODE >=  0x020600
#if defined(USE_MODVERSIONS) && USE_MODVERSIONS
#  define MODVERSIONS
#  include <config/modversions.h>
#endif
#endif

#include <linux/module.h>
#include <linux/kernel.h>
#if LINUX_VERSION_CODE >=  0x020600
#include <linux/init.h>
#endif
#include <linux/ioctl.h>
#include <linux/mm.h>
#include <linux/fs.h>
#include <linux/sched.h>
#if LINUX_VERSION_CODE <  0x020600
#include <linux/config.h>
#endif
#include <linux/pci.h>
#include <linux/errno.h>
#include <linux/poll.h>
#include <asm/io.h>
#include <asm/uaccess.h>

#include "common.h"
#include "ccioctrl.h"
#include "nbbqccio.h"

#if LINUX_VERSION_CODE >=  0x020410
  MODULE_LICENSE("GPL");
#endif
#if LINUX_VERSION_CODE >=  0x020600
MODULE_AUTHOR("Hidetada Baba");
#ifndef MOD_IN_USE
#define MOD_IN_USE module_refcount(THIS_MODULE)
#endif
#ifndef MOD_INC_USE_COUNT
#define MOD_INC_USE_COUNT
#endif
#ifndef MOD_DEC_USE_COUNT
#define MOD_DEC_USE_COUNT
#endif
#endif

static int nbbqccio_major = NBBQCCIO_MAJOR;
static const char *nbbqccio_name = "nbbqccio";

ssize_t nbbqccio_read(struct file *file,char *buff,size_t count,loff_t *pos);
static int nbbqccio_open(struct inode* inode, struct file* filep);
static int nbbqccio_release(struct inode* inode, struct file* filep);
static int nbbqccio_ioctl(struct inode *inode, struct file *filep,
			 unsigned int cmd, unsigned long arg);
static unsigned int nbbqccio_poll(struct file *file,poll_table *wait);


#define CNAFGEN(c,n,a,f) (0x00073fff & (c<<16 | (n-1)<<9 | a <<5 | f))
#define CNAFCCNET(x) (((x&0x1f)|((x&0x1e0)<<3)|(((x+0x0200)&0xfe00)<<7))&0x00ffffff)


static int girq,chkbuff,chkblk;
#if LINUX_VERSION_CODE >=  0x020400
wait_queue_head_t nbbqccio_wait_queue;
#else
struct wait_queue *nbbqccio_wait_queue = NULL;
#endif

#if LINUX_VERSION_CODE >=  0x020600
static struct file_operations nbbqccio_fops = {
  .read = nbbqccio_read,
  .poll = nbbqccio_poll,
  .ioctl = nbbqccio_ioctl,
  .open = nbbqccio_open,
  .release = nbbqccio_release,
};
#else 
#if LINUX_VERSION_CODE >=  0x020400
static struct file_operations nbbqccio_fops = {
  read: nbbqccio_read,
  poll: nbbqccio_poll,
  ioctl: nbbqccio_ioctl,
  open: nbbqccio_open,
  release: nbbqccio_release,
};
#else
static struct file_operations nbbqccio_fops = {
  NULL,             // loff_t  llseek
  nbbqccio_read,     // ssize_t read
  NULL,             // ssize_t write
  NULL,             // int     readdir
  nbbqccio_poll,     // uint    poll
  nbbqccio_ioctl,    // int     ioctl
  NULL,             // int     mmap
  nbbqccio_open,     // int     open
  NULL,             // int     flush
  nbbqccio_release,  // int     release
};
#endif
#endif

#if LINUX_VERSION_CODE >= 0x020600
int nbbqccio_init_module(void){
#else
int init_module(void){
#endif
  int ret;

  ret = register_chrdev(nbbqccio_major,nbbqccio_name,&nbbqccio_fops);
  if(ret < 0){
    printk("%s : can't regist.\n",nbbqccio_name);
    return ret;
  }
  if(nbbqccio_major == 0) {
    nbbqccio_major = ret;
  }

  girq = get_irq();
  chkbuff = 0;

#if LINUX_VERSION_CODE >=  0x020400
  init_waitqueue_head(&nbbqccio_wait_queue);
#endif

  printk("%s : nbbqccio was installed (irq %d).\n",nbbqccio_name,girq);

  return 0;
}

#if LINUX_VERSION_CODE >= 0x020600
void nbbqccio_cleanup_module(void){
#else
void cleanup_module(void){
#endif
  unregister_chrdev(nbbqccio_major,nbbqccio_name);
  printk("%s: nbbqccio was unregistered.\n", nbbqccio_name);
}

static int nbbqccio_open(struct inode* inode, struct file* filep){

  if(MOD_IN_USE){
    return -EBUSY;
  }

  chkblk = 0;


  MOD_INC_USE_COUNT;

  return 0;
}

static int nbbqccio_release(struct inode* inode, struct file* filep){

  MOD_DEC_USE_COUNT;

  return 0;
}

ssize_t nbbqccio_read(struct file *file,char *buff,size_t count,loff_t *pos){

  /* copy_to_user(buff,data,sizeof(data)); */

  return 0;
}


static int nbbqccio_ioctl(struct inode* inode, struct file *filep,
			 unsigned int cmd, unsigned long arg){

  unsigned short sval=0,ssval[2];
  unsigned long lval=0, cnaf=0, x;

  switch(cmd){
  case NBBQCCIO_CTRL:
    /* int cnaf */
    x = copy_from_user(&cnaf,(void *)arg,4);
#ifdef CCIO_K2915
    cnaf += 0x00000200;
#endif
#ifdef CCIO_CCNET
    cnaf = CNAFCCNET(cnaf);
#endif

    control(cnaf);
    break;
  case NBBQCCIO_READ16:
    /* int cnaf, ushort data */
    x = copy_from_user(&cnaf,(void *)arg,4);
#ifdef CCIO_K2915
    cnaf += 0x00000200;
#endif
#ifdef CCIO_CCNET
    cnaf = CNAFCCNET(cnaf);
#endif
    read16(cnaf,&sval);
    x = copy_to_user((void *)arg+4,&sval,2);
    break;
  case NBBQCCIO_READ24:
    /* int cnaf, ulong data */
    x = copy_from_user(&cnaf,(void *)arg,4);
#ifdef CCIO_K2915
    cnaf += 0x00000200;
#endif
#ifdef CCIO_CCNET
    cnaf = CNAFCCNET(cnaf);
#endif
    read24(cnaf,ssval);
    x = copy_to_user((void *)arg+4,ssval,4);
    break;
  case NBBQCCIO_WRITE16:
    /* ulong addr, ushort data */
    x = copy_from_user(&cnaf,(void *)arg,4);
    x = copy_from_user(&sval,(void *)arg+4,2);
#ifdef CCIO_K2915
    cnaf += 0x00000200;
#endif
#ifdef CCIO_CCNET
    cnaf = CNAFCCNET(cnaf);
#endif
    write16(cnaf,&sval);
    break;
  case NBBQCCIO_WRITE24:
    /* ulong addr, ulong data */
    x = copy_from_user(&cnaf,(void *)arg,4);
    x = copy_from_user(&lval,(void *)arg+4,4);
#ifdef CCIO_K2915
    cnaf += 0x00000200;
#endif
#ifdef CCIO_CCNET
    cnaf = CNAFCCNET(cnaf);
#endif
    write24(cnaf,(int *)&lval);
    break;
  case NBBQCCIO_Z:
    x = copy_from_user(&cnaf,(void *)arg,4);
    crate_z(cnaf);
    break;
  case NBBQCCIO_C:
    x = copy_from_user(&cnaf,(void *)arg,4);
    crate_c(cnaf);
    break;
  case NBBQCCIO_SETI:
    x = copy_from_user(&cnaf,(void *)arg,4);
    crate_seti(cnaf);
    break;
  case NBBQCCIO_DELI:
    x = copy_from_user(&cnaf,(void *)arg,4);
    crate_deli(cnaf);
    break;
  }

  return 1;
}

static unsigned int nbbqccio_poll(struct file *file,poll_table *wait){
  poll_wait(file,&nbbqccio_wait_queue,wait);
  if(chkbuff == 1){
    return POLLIN;
  }else{
    return 0;
  }
}

#if LINUX_VERSION_CODE >= 0x020600
module_init(nbbqccio_init_module);
module_exit(nbbqccio_cleanup_module);
#endif
