#!/bin/bash
#
#	/etc/rc.d/init.d/nbbq
#
# Starts the NBBQ

# Source function library.
. /etc/init.d/functions

#test -x /usr/nbbq/nbbqvio/nbbqvio.o || exit 0

RETVAL=0
DIR=/usr/nbbq
INSM=/sbin/insmod
RMM=/sbin/rmmod
LSM=/sbin/lsmod

start() {
	$INSM $DIR/bb-cc77/bb-cc77.o
	$INSM $DIR/bb-k2915/bb-k2915.o
	$INSM $DIR/nbbqvio/nbbqccio.o
	return $RETVAL
}

stop() {
	$RMM nbbqccio
	$RMM bb-cc77
	$RMM bb-k2915
        return $RETVAL
}


restart() {
	stop
	start
}	

reload() {
	restart
}	

status_at() {
	$LSM
}

case "$1" in
start)
	start
	;;
stop)
	stop
	;;
reload|restart)
	restart
	;;
status)
	status_at
	;;
*)
	echo $"Usage: $0 {start|stop|restart|status}"
	exit 1
esac

exit $?
exit $RETVAL
