/* cmdcc for NBBQ
   command line CAMAC Controller

   cmdcc -n c n a f
   cmdcc -r c n a f
   cmdcc -w c n a f val
   cmdcc -c c [z/c/seti/deli]
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <ctype.h>

#include "nbbqccio.h"

#define CNAFGEN(c,n,a,f) (0x00073fff & (c<<16 | (n-1)<<9 | a <<5 | f))

void err(void){
  printf("cmdcc -n/r/w c n a f [val]\n      -c [z/c/seti/deli]\n");
  exit(0);
}

int main(int argc, char *argv[]){
  int fd,arg[10];
  unsigned short sval;
  /* unsigned long lval; */
  int mode,c,n,a,f;

  memset(arg,0,sizeof(arg));
  mode = -1;
  c=-1;n=-1;a=-1;f=-1;sval=-1;

  /* Check argv.... */
  if(argc < 4){
    err();
  }
  if(strcmp(argv[1],"-n") == 0){
    mode = NBBQCCIO_CTRL;
  }else if(strcmp(argv[1],"-r") == 0){
    mode = NBBQCCIO_READ16;
  }else if(strcmp(argv[1],"-w") == 0){
    mode = NBBQCCIO_WRITE16;
  }else if(strcmp(argv[1],"-c") == 0){
    mode = NBBQCCIO_Z;
  }else{
    err();
  }

  if(!isdigit(argv[2][0])){
    err();
  }
  c = strtol(argv[2],NULL,0);
  if(c < 0 || c > 9){
    err();
  }

  if(mode == NBBQCCIO_Z){
    if(strcmp(argv[3],"z") == 0){
      mode = NBBQCCIO_Z;
    }else if(strcmp(argv[3],"c") == 0){
      mode = NBBQCCIO_C;
    }else if(strcmp(argv[3],"seti") == 0){
      mode = NBBQCCIO_SETI;
    }else if(strcmp(argv[3],"deli") == 0){
      mode = NBBQCCIO_DELI;
    }else{
      err();
    }
  }else{
    if(argc < 6){
      err();
    }
    if(!isdigit(argv[3][0]) || !isdigit(argv[4][0]) || !isdigit(argv[5][0])){
      err();
    }else{
      n = strtol(argv[3],NULL,0);
      a = strtol(argv[4],NULL,0);
      f = strtol(argv[5],NULL,0);
      if(n > 50 || a > 50 || f > 256){
	err();
      }
    }
    if(mode == NBBQCCIO_WRITE16){
      if(argc < 7){
	err();
      }
      if(!isdigit(argv[6][0])){
	err();
      }else{
	sval = strtol(argv[6],NULL,0);
      }
    }
  }
  /* end of check argv... */

  /* fill cnaf ... */
  switch(mode){
  case NBBQCCIO_CTRL:
  case NBBQCCIO_READ16:
    arg[0] = CNAFGEN(c,n,a,f);
    break;
  case NBBQCCIO_WRITE16:
    arg[0] = CNAFGEN(c,n,a,f);
    arg[1] = sval;
    break;
  case NBBQCCIO_Z:
  case NBBQCCIO_C:
  case NBBQCCIO_SETI:
  case NBBQCCIO_DELI:
    arg[0] = c;
    break;
  }

#ifndef DEBUG
  if((fd = open("/dev/nbbqccio",O_RDWR)) < 0){
    perror("Can't open /dev/nbbqccio\n");
    exit(1);
  }
  ioctl(fd,mode,arg);
  close(fd);
#endif

  if(mode == NBBQCCIO_READ16){
    printf("Hex     /  Dec\n");
    printf("0x%04x  /  %d\n",arg[1],arg[1]);
  }

  return 0;
}
