/* blkmonitor.c
   Sep 10, 2000
   Monitor of rowdata from analyzer
*/

#include <signal.h>
#include <stdlib.h>
#include <pthread.h>
#include <ncurses/curses.h>
#include <string.h>
#include <unistd.h>

#include "dataclient.h"

void update_screen(void);

unsigned short blkdata[BLKSIZE/2];
int flag,i,j,chflag,idx;
int evtflag,evthead,segflag,seghead;
attr_t redstr,bluestr,greenstr,cyanstr,bluecstr,whiterstr;
char modestr[3][6];
int bgcolor = -1;
int mode,stopflag = 0;
/* mode 0 : Hex
        1 : Oct
        2 : Deg
*/



void init_strcolor(void){
  init_pair(1,COLOR_BLUE,bgcolor);
  bluestr = COLOR_PAIR(1);
  init_pair(2,COLOR_RED,bgcolor);
  redstr = COLOR_PAIR(2);
  init_pair(3,COLOR_GREEN,bgcolor);
  greenstr = COLOR_PAIR(3);
  init_pair(4,COLOR_CYAN,bgcolor);
  cyanstr = COLOR_PAIR(4);
  init_pair(5,COLOR_BLUE,COLOR_CYAN);
  bluecstr = COLOR_PAIR(5);
  init_pair(6,bgcolor,COLOR_RED);
  whiterstr = COLOR_PAIR(6);
}

void sigint(void){
  endwin();
  exit(0);
}

void show_status(void){
  if(stopflag == 1){
    attron(A_BOLD);
    attron(redstr);
    mvprintw(1,25,"Now Stopping...");
    attroff(redstr);
    attroff(A_BOLD);
  }
}

void change_screen(void){
  clear();
  attron(bluecstr);
  mvprintw(0,13,"----------- blkmonitor (H.Baba) -----------");
  attroff(bluecstr);
  show_status();
  mvprintw(LINES-1,0,"COM : ");
}

void command(void){
  int com;

  while(1){
    mvprintw(LINES-1,0,"COM : ");
    com = getch();
    chflag = 1;
    move(LINES-1,0);
    deleteln();
    mvprintw(0,0,"%c",com);
    switch(com){
    case 'q':
      sigint();
      break;
    case 'x':
      mode = 0;
      update_screen();
      break;
    case 'o':
      mode = 1;
      update_screen();
      break;
    case 'd':
      mode = 2;
      update_screen();
      break;
    case 's':
      if(stopflag == 0){
	stopflag = 1;
      }else{
	stopflag = 0;
      }
      update_screen();
      break;
    }
  }
}

void update_screen(void){
  idx = 0;
  evthead = 4;
  seghead = 7;
  if(chflag == 1){
    change_screen();
    chflag = 0;
  }
  for(i=2;i<LINES-1;i++){
    move(i,0);
    //deleteln();
    mvprintw(i,0,"%06o ",(i-2)*8);
    for(j=0;j<8;j++){
      if(idx == evthead){
	evthead = (blkdata[idx] & 0x7fff) + idx;
	attron(bluestr);
	attron(A_BOLD);
	evtflag = 1;
	seghead = idx + 3;
      }
      if(idx == seghead){
	seghead = blkdata[idx] + idx;
	attron(greenstr);
	segflag = 1;
      }
      if(segflag == 2){
	//attron(cyanstr);
	attron(redstr);
	segflag = 3;
      }
      printw(modestr[mode],blkdata[idx]);
      if(evtflag == 1){
	attroff(bluestr);
	attroff(A_BOLD);
	evtflag = 0;
      }
      if(segflag == 1){
	attroff(greenstr);
	segflag = 2;
      }
      if(segflag == 3){
	//attroff(cyanstr);
	attroff(redstr);
	segflag = 0;
      }
      idx++;
    }
  }
  move(LINES-1,6);
  refresh();
}

void showdata(void){
  getData(blkdata,&flag);
  if(flag == 0 && stopflag == 0){
    update_screen();
 }else{
    /*
      mvprintw(1,1,"No Data\n");
      refresh();
    */
  }
}

int main(int argc,char *argv[]){
  pthread_t comthread;

  memcpy(modestr[0],"%04x \0",6);
  memcpy(modestr[1],"%06o \0",6);
  memcpy(modestr[2],"%6d \0\0",6);

  /* Signal */
  signal(SIGINT,(void *)sigint);

  initDataClient();

  initscr();
  start_color();
  use_default_colors();
  init_strcolor();

  if(LINES < 20){
    mvprintw(0,0,"Terminal is too short!!");
    getch();
    endwin();
    exit(0);
  }

  /* Thread */
  pthread_create(&comthread,NULL,(void *)&command,NULL);

  change_screen();
  //showdata();

  /* Get Data per 2s */
  while(1){
    sleep(2);
    showdata();
  }


  endwin();

  return 0;
}
