/* vmemm.h
 * Header for VMEMM / PCIADA
 *
 * May 12, 2002
 * H.Baba
 *
 */

/* VENDOR ID */
#define VMEMM_VENDOR_ID      0x10B5
#define VMEMM_DEVICE_ID      0x9050

/* Common */
#define VME_PAGE             0x1000
#define A32                  0x09
#define A24                  0x39

/* PCIADA */
#define PCIADA_LCRBASE       0x0
#define PCIADA_MAP_SIZE      0x80

/* Address */
#define PCIADA_INTCSR        0x4c
#define PCIADA_CNTRL         0x50

/* Bit */
#define PCIADA_EN_VMEMM_BIT  0x4184
#define PCIADA_DIS_VMEMM_BIT 0x4084
#define PCIADA_OK_VMEMM_BIT  0x4984


/* VMEMM */
#define VMEMM_CSRBASE        0x0
#define VMEMM_VICBASE        0x0400
#define VMEMM_VECBASE        0x0800
#define VMEMM_VMEBASE        0x1000
#define VMEMM_MAP_SIZE       0x2000

/* Address */
#define VMEMM_STAT           0x0000
#define VMEMM_REG            0x0000
#define VMEMM_IRQSTAT        0x0004
#define VMEMM_RESET          0x0004
#define VMEMM_ADDRSTAT       0x0008  /* lword */
#define VMEMM_ADDR           0x0008  /* lword */

/* Bit */
#define VMEMM_GLORST_BIT     0x000a
#define VMEMM_INTRST_BIT     0x0005


/* vic68 */
/* Offsets */
#define VIC68_VIICR   0x03
#define VIC68_VICR(i) (0x07+4*(i-1))
#define VIC68_DMASICR 0x23
#define VIC68_LICR(i) (0x27+4*(i-1))
#define VIC68_ICGSICR 0x43 
#define VIC68_ICMSICR 0x47
#define VIC68_EGICR   0x4B
#define VIC68_ICGSVBR 0x4F
#define VIC68_ICMSVBR 0x53
#define VIC68_LIVBR   0x57 
#define VIC68_EGIVBR  0x5B
#define VIC68_ICSR    0x5F
#define VIC68_ICR(i)  (0x63+4*(i))
#define VIC68_VIRSR   0x83
#define VIC68_VIVBR(i) (0x87+4*(i-1))
#define VIC68_TTR     0xA3
#define VIC68_LBTR    0xA7
#define VIC68_BDTR    0xAB
#define VIC68_ARCR    0xB3
#define VIC68_AMSR    0xB7
#define VIC68_BESR    0xBB
#define VIC68_DMASR   0xBF
#define VIC68_RCR     0xD3
#define VIC68_BTCR    0xD7
#define VIC68_BTLR1   0xDB
#define VIC68_BTLR0   0xDF
#define VIC68_SRR     0xE3

/* Masks */
#define VIC68_AMSR_MASK    0x3F
#define VIC68_BERR_MASK    0x20
#define VIC68_VMETO_MASK   0x10

/* Bits */
#define VIC68_SYSFAIL_BIT  0x80

#if LINUX_VERSION_CODE >= 0x020600
static const struct pci_device_id vmemm_device_id_table[] = {
  {PCI_DEVICE(VMEMM_VENDOR_ID, VMEMM_DEVICE_ID), .driver_data = 0,},
  { }
};
#endif
