/*
 * Wiener VMEMM / PCIADA
 * PCI-VME
 * 
 * H.baba
 * Jun 26, 2003
 */

#include "vmemm.h"

int vmemm_init_register(int irq,unsigned long lcr,unsigned long vmemm);
int vmemm_enable_vmemm(void);
void vmemm_clr_sysfail(void);
void vmemm_set_amsr(unsigned char am);
void vmemm_vread16(unsigned long addr,short *data);
void vmemm_vread32(unsigned long addr,long *data);
void vmemm_vwrite16(unsigned long addr,short *data);
void vmemm_vwrite32(unsigned long addr,long *data);
void vmemm_define_intlevel(int level);
void vmemm_enable_interrupt(void);
void vmemm_disable_interrupt(void);
int vmemm_check_interrupt(void);
int vmemm_read_intvector(void);
void vmemm_dma_vread32_start(unsigned long addr,int size);
int vmemm_dma_vread32_store(char *data,int size);

struct vpci_struct{
  unsigned long irq;
  unsigned long lcr_addr;
  unsigned long vmemm_addr;
};

struct vpci_struct vpci_table[] ={
  {0, 0, 0}
};

struct vpci_reg{
  char *lcr;
  char *csr;
  char *vic;
  char *vec;
  char *vme;
};

struct vpci_reg vreg[]={
  {0, 0, 0, 0, 0}
};

volatile static int intlevel;
volatile static short intleveln;

int vmemm_init_register(int irq,unsigned long lcr,unsigned long vmemm){

  vpci_table->irq = (unsigned int)irq;
  vpci_table->lcr_addr = (unsigned int)lcr;
  vpci_table->vmemm_addr = (unsigned int)vmemm;
  
  vreg->lcr = ioremap(lcr,PCIADA_MAP_SIZE);
  vreg->csr = ioremap(vmemm,VMEMM_MAP_SIZE);
  vreg->vic = vreg->csr + VMEMM_VICBASE;
  vreg->vec = vreg->csr + VMEMM_VECBASE;
  vreg->vme = vreg->csr + VMEMM_VMEBASE;

  if(vmemm_enable_vmemm() != PCIADA_OK_VMEMM_BIT){
    /*
      printk("PC-VME not connect.\n");
      return -1;
    */
  }

  vmemm_set_amsr(A32);
  intlevel = 0;

  return 0;
}

int vmemm_enable_vmemm(void){
  short ret;

  writew(PCIADA_EN_VMEMM_BIT,vreg->lcr+PCIADA_CNTRL);
  ret = readw(vreg->lcr+PCIADA_CNTRL);

  return ret;
}

void vmemm_clr_sysfail(void){
  writeb(VIC68_SYSFAIL_BIT,vreg->vic + VIC68_ICR(7));
}

void vmemm_set_amsr(unsigned char am){
  writeb(am,vreg->vic + VIC68_AMSR);
}

void vmemm_set_vmeaddr(unsigned long addr){
  writel(addr,vreg->csr+VMEMM_ADDR);
}

void vmemm_vread16(unsigned long addr,short *data){
  unsigned short off;

  off = addr & (VME_PAGE-1);
  addr -= off;

  vmemm_set_vmeaddr(addr);
  *data = readw(vreg->vme+off);
}

void vmemm_vread32(unsigned long addr,long *data){
  unsigned short off;

  off = addr & (VME_PAGE-1);
  addr -= off;

  vmemm_set_vmeaddr(addr);
  *data = readl(vreg->vme+off);
}

void vmemm_vwrite16(unsigned long addr,short *data){
  unsigned short off;

  off = addr & (VME_PAGE-1);
  addr -= off;

  vmemm_set_vmeaddr(addr);
  writew(*data,vreg->vme+off);
}

void vmemm_vwrite32(unsigned long addr,long *data){
  unsigned short off;

  off = addr & (VME_PAGE-1);
  addr -= off;

  vmemm_set_vmeaddr(addr);
  writel(*data,vreg->vme+off);
}

void vmemm_define_intlevel(int level){
  intleveln = level;
  intlevel = (level<<1) & 0x000e;
}

void vmemm_enable_interrupt(void){
  unsigned short val;

  val = 0x0043;
  writew(val,vreg->lcr+PCIADA_INTCSR);
}
  
void vmemm_disable_interrupt(void){
  unsigned short val;

  val = 0x0000;
  writew(val,vreg->lcr+PCIADA_INTCSR);
}

int vmemm_check_interrupt(void){
  unsigned short val;

  if(readw(vreg->lcr+PCIADA_INTCSR) & 0x0004){
    val = readw(vreg->vic+VMEMM_IRQSTAT);
    if(intlevel == (val & 0x000e)){
      return 1;
    }
  }

  return 0;
}

int vmemm_read_intvector(void){


  return 0;
}

void vmemm_dma_vread32_start(unsigned long addr,int size){
}

int vmemm_dma_vread32_store(char *data,int size){
  return 0;
}

