/*
 * Wiener VMEMM / PCIADA PCI-VME
 * VME Access Module
 * Hidetada Baba (RIKEN)
 * June 2, 2008
 */

#include <linux/version.h>
#if LINUX_VERSION_CODE >=  0x020600
#if defined(USE_MODVERSIONS) && USE_MODVERSIONS
#  define MODVERSIONS
#  include <config/modversions.h>
#endif
#endif

#include <linux/module.h>
#include <linux/kernel.h>
#if LINUX_VERSION_CODE >=  0x020600
#include <linux/init.h>
#endif
#include <linux/ioctl.h>
#include <linux/sched.h>
#if LINUX_VERSION_CODE <  0x020600
#include <linux/config.h>
#endif
#include <linux/pci.h>
#include <linux/errno.h>
#include <asm/io.h>
#include <asm/delay.h>

#if LINUX_VERSION_CODE <  0x020400
#include <linux/malloc.h>
#endif

#include "vmemm.c"

int vmemm_get_irq(void);

#if LINUX_VERSION_CODE >=  0x020410
  MODULE_LICENSE("GPL");
#endif
#if LINUX_VERSION_CODE >=  0x020600
MODULE_AUTHOR("Hidetada Baba");
#endif


static int girq;
unsigned long tioa,tiob,tir;

#if LINUX_VERSION_CODE >= 0x020600
struct pci_dev* vmemm_pci_dev;

static int vmemm_pci_probe(struct pci_dev *dev, const struct pci_device_id *id);
static void vmemm_pci_remove(struct pci_dev *dev);

static struct pci_driver vmemm_pci_driver = {
  .id_table = vmemm_device_id_table,
  .probe = vmemm_pci_probe,
  .remove = vmemm_pci_remove,
};
static volatile int probflag;
#else
int detect_pci_device(unsigned vendor,unsigned device,unsigned long *tioa,
		      unsigned long *tiob, unsigned long *tir);
#endif

#if LINUX_VERSION_CODE >= 0x020600
EXPORT_SYMBOL(vmemm_set_amsr);
EXPORT_SYMBOL(vmemm_vread16);
EXPORT_SYMBOL(vmemm_vread32);
EXPORT_SYMBOL(vmemm_vwrite16);
EXPORT_SYMBOL(vmemm_vwrite32);
EXPORT_SYMBOL(vmemm_get_irq);
EXPORT_SYMBOL(vmemm_define_intlevel);
EXPORT_SYMBOL(vmemm_enable_interrupt);
EXPORT_SYMBOL(vmemm_disable_interrupt);
EXPORT_SYMBOL(vmemm_check_interrupt);
EXPORT_SYMBOL(vmemm_dma_vread32_start);
EXPORT_SYMBOL(vmemm_dma_vread32_store);
#endif

#if LINUX_VERSION_CODE >= 0x020600
static int vmemm_init_module(void)
#else
int init_module(void)
#endif
{
  int ret, err;

  ret = 0;
#if LINUX_VERSION_CODE >= 0x020600
  probflag = 0;
  vmemm_pci_driver.name = "VMEMM";
  vmemm_pci_dev = NULL;
  err = pci_register_driver(&vmemm_pci_driver);
  if(vmemm_pci_dev == NULL || err < 0){
    printk("VMEMM Can't find.\n");
    return -ENODEV;
  }
  /* Register again to avoid APIC's IRQ change */
  schedule_timeout(5);
  probflag = 1;
  pci_unregister_driver(&vmemm_pci_driver);
  err = pci_register_driver(&vmemm_pci_driver);
#else
  ret = detect_pci_device(VMEMM_VENDOR_ID,VMEMM_DEVICE_ID,&tioa,&tiob,&tir);
  if(ret){
    printk("VMEMM Can't find.\n");
    return ret;
    }
#endif
  printk("VMEMM found at 0x%04lx 0x%04lx on irq %lu.\n",tioa,tiob,tir);
  
  if(vmemm_init_register(tir,tioa,tiob) == -1){
    return -ENODEV;
  }
  
  girq = tir;
  
  return 0;
}

#if LINUX_VERSION_CODE >= 0x020600
static void vmemm_cleanup_module(void)
#else
void cleanup_module(void)
#endif
{

#if LINUX_VERSION_CODE >= 0x020600
  pci_unregister_driver(&vmemm_pci_driver);
#endif
}

#if LINUX_VERSION_CODE <= 0x020600
int detect_pci_device(unsigned vendor,unsigned device,unsigned long *tioa,
		      unsigned long *tiob, unsigned long *tir){
    struct pci_dev *dev;

    if (!pcibios_present()){
      printk("VMEMM: unable to find PCI bios.\n");
      return -ENODEV;
    }

    dev = NULL;
    dev = pci_find_device(vendor, device, dev);

    if(dev == NULL){
      return -ENODEV;
    }

#if LINUX_VERSION_CODE >=  0x020400
    *tioa = dev->resource[0].start & PCI_BASE_ADDRESS_IO_MASK;
    *tiob = dev->resource[2].start & PCI_BASE_ADDRESS_IO_MASK;
    *tir  = dev->irq;
#else
    *tioa = dev->base_address[0] & PCI_BASE_ADDRESS_IO_MASK;
    *tiob = dev->base_address[2] & PCI_BASE_ADDRESS_IO_MASK;
    *tir  = dev->irq;
#endif

    return 0;
}
#endif

int vmemm_get_irq(void){
  return girq;
}

#if LINUX_VERSION_CODE >= 0x020600
static int vmemm_pci_probe(struct pci_dev *dev, const struct pci_device_id *id){
  int ret;

  vmemm_pci_dev = dev;

  if(probflag){
    tioa = dev->resource[0].start & PCI_BASE_ADDRESS_IO_MASK;
    tiob = dev->resource[2].start & PCI_BASE_ADDRESS_IO_MASK;
    tir  = dev->irq;
  }

  ret = pci_enable_device(dev);
  return ret;
}

static void vmemm_pci_remove(struct pci_dev *dev){
}


module_init(vmemm_init_module);
module_exit(vmemm_cleanup_module);
#endif
