/* v2718.h
 * Header for V2718
 *
 * Hidetada Baba (RIKEN)
 * baba@rarfaxp.riken.jp
 * Feb 18, 2006
 *
 */


/* Common */
#define VME_PAGE                        0x1000
#define A32                             0x09
#define A24                             0x39
#define A16                             0x29
#define A32BLK                          0x0b
#define A24BLK                          0x3b
#define A16BLK                          

/* Register */

/* Size */
#define V2718_MIN_DMA_SIZE              80
#define V2718_MAX_MINOR                 256

#define V2718_MAX                       8

#define V2718_RXFIFO_SZ                 8192

#define V2718_CSR_SIZE                  0x100
#define V2718_PLX_SIZE                  0x100
#define V2718_DMA_SIZE                  0x20000

/* Value */
#define V2718_R16_HEADER                3
#define V2718_R32_HEADER                3
#define V2718_W16_HEADER                4
#define V2718_W32_HEADER                5
#define V2718_R32DMA_HEADER             4
#define V2718_CHKIRQ_HEADER             1
#define V2718_ACKIRQ_HEADER             3
#define V2718_INIT1_HEADER              1
#define V2718_INIT2_HEADER              2
#define V2718_READREG_HEADER            1
#define V2718_SETINPUTCONF_HEADER       2
#define V2718_SETOUTPUTCONF_HEADER      2
#define V2718_SETOUTPUTREG_HEADER       2

#define V2718_READREG_VALUE             0x00004080
#define V2718_INIT1_VALUE               0x00004081
#define V2718_INIT2_VALUE               0x00ff0086 
#define V2718_CHKIRQ_VALUE              0x00004085
#define V2718_SETINPUTCONF_VALUE1       0x0000008b
#define V2718_SETINPUTCONF_VALUE2       0xffff0091
#define V2718_SETINPUTCONF_VALUE3       0x00000093
#define V2718_SET_OUTPUT_MULTI          0x0000008c
#define V2718_CLR_OUTPUT_MULTI          0x00000092
#define V2718_SET_LED_POL               0x0000008d
#define V2718_CLR_LED_POL               0x00000093
#define V2718_SET_OUTPUT_REG            0x0000008a
#define V2718_CLR_OUTPUT_REG            0x00000090
#define V2718_ACKIRQ_BIT1               0x0000c098
#define V2718_ACKIRQ_BIT2               0x00000000
#define V2718_RD_BIT                    0xc000
#define V2718_WR_BIT                    0x8000
#define V2718_A32_BIT                   0x0000
#define V2718_A24_BIT                   0x3000
#define V2718_A16_BIT                   0x2000
#define V2718_SINGLE_BIT                0x0981
#define V2718_BLOCK_BIT                 0x0b84
#define V2718_D32_BIT                   0x0020
#define V2718_D16_BIT                   0x0010
#define V2718_DMADONE_BIT               0x00000010
// 1=3<<(16+ch*2), 2=1<<(26+ch), 3=1<<(16+ch)
/* PCI Device */
#define V2718_VENDOR_ID                 PCI_VENDOR_ID_PLX
#define V2718_DEVICE_ID                 0x9054
#define V2718_PCI_SUBDEVICE_ID          0x3057

#define V2718_PCI_SIZE_8                0x0001
#define V2718_PCI_SIZE_16               0x0002
#define V2718_PCI_SIZE_32               0x0003

#define V2718_MAGIC                     '8'

#define V2718_IOCTL_RESET               _IO(V2718_MAGIC, 0)
#define V2718_IOCTL_COMM                _IOWR(V2718_MAGIC, 1, a2818_comm_t)
#define V2718_IOCTL_REG_WR              _IOW(V2718_MAGIC, 2, a2818_reg_t)
#define V2718_IOCTL_REG_RD              _IOWR(V2718_MAGIC, 3, a2818_reg_t)
#define V2718_IOCTL_IRQ_WAIT            _IOW(V2718_MAGIC, 4, a2818_intr_t)
#define V2718_IOCTL_SEND                _IOWR(V2718_MAGIC, 5, a2818_comm_t)
#define V2718_IOCTL_RECV                _IOWR(V2718_MAGIC, 6, int)

#define V2718_PCI_ID                    0x0000
#define V2718_PCI_CSR                   0x0004
#define V2718_PCI_CLASS                 0x0008
#define V2718_PCI_MISC0                 0x000C
#define V2718_PCI_BS                    0x0010
#define V2718_PCI_MISC1                 0x003C


/*
        V2718 Registers offsets
*/
#define V2718_TXFIFO                    0x0000
#define V2718_RXFIFO                    0x0004
#define V2718_IOCTL                     0x0008
#define V2718_LNKRST                    1
#define V2718_INTDIS                    0x0002
#define V2718_SERVICE                   0x0004
#define V2718_VINTDIS                   0x0008
#define V2718_STATUS                    0x000c
#define V2718_RXFIFO_EMPTY              1
#define V2718_TXFIFO_FULL               0x02
#define V2718_LINK_FAIL                 0x100
#define V2718_FWDLD                     0x10
#define V2718_FLENA                     0x14
#define V2718_TRSTAT                    0x18
#define V2718_FWREL                     0x1C
#define V2718_DEBUG                     0x20
#define V2718_IRQSTAT0                  0x24
#define V2718_IRQSTAT1                  0x28
#define V2718_IRQSLAVES                 0x2C
#define V2718_IRQMASK0_SET              0x30
#define V2718_IRQMASK0_CLR              0x34
#define V2718_IRQMASK1_SET              0x38
#define V2718_IRQMASK1_CLR              0x3C
#define V2718_IOCTL_SET                 0xA0
#define V2718_IOCTL_CLR                 0xA4

/*
        PLX9054 Registers, offsets
*/
#define V2718_PLX_INTCSR                0x68
#define V2718_INTCSR_PCI_INT_ENA        0x00000100
#define V2718_INTCSR_LOC_INT_ENA        0x00000800
#define V2718_INTCSR_LOC_INT_ACT        0x00008000
#define V2718_INTCSR_DMA0_INT_ENA       0x00040000
#define V2718_INTCSR_DMA0_INT_ACT       0x00200000
#define V2718_INTCSR_DMA1_INT_ENA       0x00080000
#define V2718_INTCSR_DMA1_INT_ACT       0x00400000
#define V2718_PLX_CNTRL                 0x6C
#define V2718_CNTRL_CONF_RELOAD         0x20000000
#define V2718_CNTRL_SW_RESET            0x40000000
#define V2718_PLX_DMAMODE0              0x80
#define V2718_PLX_DMAMODE1              0x94
#define V2718_DMAMODE_DW16              0x00000001
#define V2718_DMAMODE_DW32              0x00000002
#define V2718_DMAMODE_READY_ENA         0x00000040
#define V2718_DMAMODE_BTERM_ENA         0x00000080
#define V2718_DMAMODE_BURST_ENA         0x00000100
#define V2718_DMAMODE_SG_ENA            0x00000200
#define V2718_DMAMODE_DONE_INT_ENA      0x00000400
#define V2718_DMAMODE_LOC_ADR_HOLD      0x00000800
#define V2718_DMAMODE_EOT_ENA           0x00004000
#define V2718_DMAMODE_FAST_TERM         0x00008000
#define V2718_DMAMODE_INT_PCI           0x00020000
#define V2718_PLX_DMAPADR0              0x84
#define V2718_PLX_DMAPADR1              0x98
#define V2718_PLX_DMALADR0              0x88
#define V2718_PLX_DMALADR1              0x9C
#define V2718_PLX_DMASIZE0              0x8C
#define V2718_PLX_DMASIZE1              0xA0
#define V2718_PLX_DMADPR0               0x90
#define V2718_PLX_DMADPR1               0xA4
#define V2718_PLX_DMACSR                0xA8
#define V2718_DMACSR_ENA_0              0x00000001
#define V2718_DMACSR_START_0            0x00000002
#define V2718_DMACSR_ABORT_0            0x00000004
#define V2718_DMACSR_CLRINT_0           0x00000008
#define V2718_DMACSR_DONE_0             0x00000010
#define V2718_DMACSR_ENA_1              0x00000100
#define V2718_DMACSR_START_1            0x00000200
#define V2718_DMACSR_ABORT_1            0x00000400
#define V2718_DMACSR_CLRINT_1           0x00000800
#define V2718_DMACSR_DONE_1             0x00001000

/*
  V2718 internal registers
*/

#define V2718_INTREG_STATUS             0x00
#define V2718_INTREG_VME_CTRL           0x01
#define V2718_INTREG_FW_REV             0x02
#define V2718_INTREG_FW_DWNLD           0x03
#define V2718_INTREG_FL_ENA             0x04
#define V2718_INTREG_IRQ_STAT           0x05
#define V2718_INTREG_IRQ_MASK           0x06
#define V2718_INTREG_IN_REG             0x08
#define V2718_INTREG_OUT_REG_S          0x0a
#define V2718_INTREG_IN_MUX_S           0x0b
#define V2718_INTREG_OUT_MUX_S          0x0c
#define V2718_INTREG_LED_POL_S          0x0d
#define V2718_INTREG_OUT_REG_C          0x10
#define V2718_INTREG_IN_MUX_C           0x11
#define V2718_INTREG_OUT_MUX_C          0x12
#define V2718_INTREG_LED_POL_C          0x13
#define V2718_INTREG_PULSEA_0           0x16
#define V2718_INTREG_PULSEA_1           0x17
#define V2718_INTREG_PULSEB_0           0x19
#define V2718_INTREG_PULSEB_1           0x1a
#define V2718_INTREG_SCALER0            0x1c
#define V2718_INTREG_SCALER1            0x1d
#define V2718_INTREG_DISP_ADL           0x20
#define V2718_INTREG_DISP_ADH           0x21
#define V2718_INTREG_DISP_DTL           0x22
#define V2718_INTREG_DISP_DTH           0x23
#define V2718_INTREG_PC1                0x24
#define V2718_INTREG_PC2                0x25
#define V2718_INTREG_LM_ADL             0x28
#define V2718_INTREG_LM_ADH             0x29
#define V2718_INTREG_LM_C               0x2c

#if LINUX_VERSION_CODE >= 0x020600
static const struct pci_device_id v2718_device_id_table[] = {
  {PCI_DEVICE(V2718_VENDOR_ID, V2718_DEVICE_ID), .driver_data = 0,},
  { }
};
#endif
