/* v2718.c
 * CAEN V2718 PCI-VME
 *
 * Hidetada Baba (RIKEN)
 * baba@ribf.riken.jp
 * May 29, 2008
 *
 */

#include <linux/version.h>
#if LINUX_VERSION_CODE >=  0x020600
#if defined(USE_MODVERSIONS) && USE_MODVERSIONS
#  define MODVERSIONS
#  include <config/modversions.h>
#endif
#endif

#include <linux/module.h>
#include <linux/kernel.h>
#if LINUX_VERSION_CODE >=  0x020600
#include <linux/init.h>
#endif
#include <linux/ioctl.h>
#include <linux/sched.h>
#if LINUX_VERSION_CODE <  0x020600
#include <linux/config.h>
#endif
#include <linux/pci.h>
#include <linux/errno.h>
#include <asm/io.h>
#include <asm/delay.h>

#if LINUX_VERSION_CODE <  0x020400
#include <linux/malloc.h>
#endif

#include "v2718.c"

#if LINUX_VERSION_CODE >=  0x020410
MODULE_LICENSE("GPL");
#endif
#if LINUX_VERSION_CODE >=  0x020600
MODULE_AUTHOR("Hidetada Baba");
#endif

int v2718_get_irq(void);

#if LINUX_VERSION_CODE >= 0x020600
struct pci_dev* v2718_pci_dev;

static int v2718_pci_probe(struct pci_dev *dev, const struct pci_device_id *id);
static void v2718_pci_remove(struct pci_dev *dev);

static struct pci_driver v2718_pci_driver = {
  .id_table = v2718_device_id_table,
  .probe = v2718_pci_probe,
  .remove = v2718_pci_remove,
};
static volatile int probflag;
#else
int detect_pci_device(unsigned vendor,unsigned device,struct pci_config *config,int *devn);
#endif

#if LINUX_VERSION_CODE >= 0x020600
EXPORT_SYMBOL(v2718_set_amsr);
EXPORT_SYMBOL(v2718_vread16);
EXPORT_SYMBOL(v2718_vread32);
EXPORT_SYMBOL(v2718_vwrite16);
EXPORT_SYMBOL(v2718_vwrite32);
EXPORT_SYMBOL(v2718_get_irq);
EXPORT_SYMBOL(v2718_define_intlevel);
EXPORT_SYMBOL(v2718_enable_interrupt);
EXPORT_SYMBOL(v2718_disable_interrupt);
EXPORT_SYMBOL(v2718_check_interrupt);
EXPORT_SYMBOL(v2718_dma_vread32_start);
EXPORT_SYMBOL(v2718_dma_vread32_store);
#endif


#if LINUX_VERSION_CODE >= 0x020600
static int v2718_init_module(void)
#else
int init_module(void)
#endif
{
  int ret, err;

  devicen = 0;
  
  printk("V2718: init_module\n");

  ret = 0;
#if LINUX_VERSION_CODE >= 0x020600
  v2718_pci_driver.name = "V2718";
  v2718_pci_dev = NULL;
  probflag = 0;
  err = pci_register_driver(&v2718_pci_driver);
  if(v2718_pci_dev == NULL){
    printk("V2718 Can't find.\n");
    return -ENODEV;
  }
  /* Register again to avoid APIC's IRQ change */
  schedule_timeout(5);
  probflag = 1;
  pci_unregister_driver(&v2718_pci_driver);
  err = pci_register_driver(&v2718_pci_driver);
  devicen = 1;
#else
  ret = detect_pci_device(V2718_VENDOR_ID,V2718_DEVICE_ID,(struct pci_config *)&v2718config,(int *)&devicen);
  if(ret){
    printk("V2718 : Can't find PLX9054.\n");
    return ret;
  }
#endif
  printk("V2718 found at 0x%08lx 0x%08lx 0x%08lx on irq %d.\n",
	 (unsigned long)v2718config[0].addr[0],
	 (unsigned long)v2718config[0].addr[1],
	 (unsigned long)v2718config[0].addr[2], v2718config[0].irq);
  if(v2718_init_register(0) == -1){
    return -ENODEV;
  }
  
  return 0;
}

#if LINUX_VERSION_CODE >= 0x020600
static void v2718_cleanup_module(void)
#else
void cleanup_module(void)
#endif
{
  //v2718_check_interrupt();
  
  kfree(vreg[0].dma_buff);
  vfree(vreg[0].csr);
  vfree(vreg[0].plx);

#if LINUX_VERSION_CODE >= 0x020600
  pci_unregister_driver(&v2718_pci_driver);
#endif

}

#if LINUX_VERSION_CODE < 0x020600
int detect_pci_device(unsigned vendor,unsigned device,struct pci_config *v2718config,int *devicen){
  struct pci_dev *dev;
    int i, n;
    unsigned short ss_id;

    if (!pcibios_present()){
      printk("V2718: Unable to find PCI bios.\n");
      return -ENODEV;
    }

    dev = NULL;
    n = 0;
    dev = pci_find_device(vendor, device, dev);
    if(dev == NULL){
      printk("V2718: Can't find PLX9054\n");
      return -ENODEV;
    }
    
    pci_read_config_word(dev, PCI_SUBSYSTEM_ID, &ss_id);
    if(ss_id == V2718_PCI_SUBDEVICE_ID){
      n++;
    }
    if(!n){
      printk("V2718: Can't fine A2818\n");
      return -ENODEV;
    }

#if LINUX_VERSION_CODE >=  0x020400
    for(i=0;i<3;i++){
      v2718config[0].addr[i] = 
	dev->resource[i].start & PCI_BASE_ADDRESS_IO_MASK;
    }
    v2718config[0].irq = dev->irq;
#else
    for(i=0;i<3;i++){
      v2718config[0].addr[i] = 
	dev->base_address[i] & PCI_BASE_ADDRESS_IO_MASK;
    }
    v2718config[0].irq = dev->irq;
#endif

    if(n==0){
      return -ENODEV;
    }
    
    *devicen = n;
    
    return 0;
}
#endif

int v2718_get_irq(void){
  return v2718config[0].irq;
}

int v2718_get_irq_i(int dn){
  return v2718_get_irq();
}

#if LINUX_VERSION_CODE >= 0x020600
static int v2718_pci_probe(struct pci_dev *dev, const struct pci_device_id *id){
  int i,j, ret;

  v2718_pci_dev = dev;

  if(probflag){
    j = 0;
    for(i=0;i<3;i++){
      v2718config[j].addr[i] = dev->resource[i].start & PCI_BASE_ADDRESS_IO_MASK;
    }
    v2718config[j].irq = dev->irq;
  }

  ret = pci_enable_device(dev);
  return ret;
}

static void v2718_pci_remove(struct pci_dev *dev){
}

module_init(v2718_init_module);
module_exit(v2718_cleanup_module);
#endif
