/*
 * Tundra Universe
 * Use with vmisft driver (vme_universe.o)
 * 
 * VME Access Module
 * Hidetada Baba
 * 2005/11/28
 */

#include <linux/version.h>
#if LINUX_VERSION_CODE >=  0x020600
#if defined(USE_MODVERSIONS) && USE_MODVERSIONS
#  define MODVERSIONS
#  include <config/modversions.h>
#endif
#endif

#include <linux/module.h>
#include <linux/kernel.h>
#if LINUX_VERSION_CODE >=  0x020600
#include <linux/init.h>
#endif
#include <linux/ioctl.h>
#include <linux/sched.h>
#if LINUX_VERSION_CODE <  0x020600
#include <linux/config.h>
#endif
#include <linux/pci.h>
#include <linux/errno.h>
#include <asm/io.h>
#include <asm/delay.h>

#if LINUX_VERSION_CODE <  0x020400
#include <linux/malloc.h>
#endif

#if LINUX_VERSION_CODE >=  0x020410
MODULE_LICENSE("GPL");
#endif
#if LINUX_VERSION_CODE >=  0x020600
MODULE_AUTHOR("Hidetada Baba");
#endif

#if LINUX_VERSION_CODE <  0x020400
#include <linux/malloc.h>
#endif

#include "univ.c"
int univ_get_irq(void);


#if LINUX_VERSION_CODE >= 0x020600
EXPORT_SYMBOL(univ_set_amsr);
EXPORT_SYMBOL(univ_vread16);
EXPORT_SYMBOL(univ_vread32);
EXPORT_SYMBOL(univ_vwrite16);
EXPORT_SYMBOL(univ_vwrite32);
EXPORT_SYMBOL(univ_map_read16);
EXPORT_SYMBOL(univ_map_read32);
EXPORT_SYMBOL(univ_map_write16);
EXPORT_SYMBOL(univ_map_write32);
EXPORT_SYMBOL(univ_get_irq);
EXPORT_SYMBOL(univ_define_intlevel);
EXPORT_SYMBOL(univ_enable_interrupt);
EXPORT_SYMBOL(univ_disable_interrupt);
EXPORT_SYMBOL(univ_check_interrupt);
EXPORT_SYMBOL(univ_dma_vread32_start);
EXPORT_SYMBOL(univ_dma_vread32_store);
EXPORT_SYMBOL(univ_init_window);
EXPORT_SYMBOL(univ_end_window);
EXPORT_SYMBOL(univ_init_dma);
EXPORT_SYMBOL(univ_end_dma);
EXPORT_SYMBOL(univ_dma_read);
EXPORT_SYMBOL(univ_read_intvector);
#endif

#if LINUX_VERSION_CODE >= 0x020600
static int univ_init_module(void)
#else
int init_module(void)
#endif
{

  printk("bb-universe : registerd\n");

  univ_init_register();

  return 0;
}

#if LINUX_VERSION_CODE >= 0x020600
static void univ_cleanup_module(void)
#else
void cleanup_module(void)
#endif
{

  kfree(vreg.dma_buff);

}

int univ_get_irq(void){
  return univconfig.irq;
}

#if LINUX_VERSION_CODE >= 0x020600
module_init(univ_init_module);
module_exit(univ_cleanup_module);
#endif
