/*
 * univ
 * PCI-VME
 * 
 * Hidetada Baba
 * Aug 8, 2005
 */

//#define DEBUG

#define VMEADDR 0x100a
#define SIZE    2
#define AM      0x09
#define FLAGS   0x40000000

#include "univ.h"

int univ_init_register(void);
void univ_set_amsr(unsigned char am);
void univ_vread16(unsigned int addr,short *data);
void univ_vread32(unsigned int addr,int *data);
void univ_vwrite16(unsigned int addr,short *data);
void univ_vwrite32(unsigned int addr,int *data);
void univ_dma_vread32_start(unsigned int addr, int size);
int univ_dma_vread32_store(char *data, int size);
int univ_check_dma(void);
void univ_init_dma(unsigned long vaddr, unsigned int size, int n);
void univ_end_dma(int n);
int univ_dma_read(char *ptr, int size, int n);
void univ_define_intlevel(int level);
void univ_enable_interrupt(void);
void univ_disable_interrupt(void);
int univ_check_interrupt(void);
int univ_read_intvector(void);

struct pci_config {
  unsigned char irq;
}univconfig;

struct vpci_reg{
  char *csr;
  char *dma_buff;
}vreg;


volatile static int intlevel;
volatile static short intleveln = 0;
size_t ps = VME_PAGE;

#define MAXWINDOW 8
#define MAXDMAPTR 20

vme_bus_handle_t bus;
struct vme_master_handle_t *handle;

struct vmectl_window_t twindow;
vme_master_handle_t *tmaster_p;
char *tmapptr;

struct vmectl_window_t window[MAXDMAPTR];
vme_master_handle_t *master_p[MAXDMAPTR];
char *vmeptr[MAXDMAPTR];
char *mapptr[MAXDMAPTR];


vme_dma_handle_t *dma_p[MAXDMAPTR];
char *dmaptr[MAXDMAPTR], *dmamapptr[MAXDMAPTR];
struct vmectl_dma_t dma[MAXDMAPTR];


//volatile unsigned long long int RDTSC(void)
//{
// unsigned int h,l;
//  
// /* read Pentium cycle counter */
//    __asm__(".byte 0x0f,0x31"
//          :"=a" (l),
//           "=d" (h));
//
//  return ((unsigned long long int)h<<32)|l;
//}


int univ_init_register(void){

  vreg.dma_buff = kmalloc(UNIV_DMA_SIZE,GFP_KERNEL|GFP_DMA);
  if(vreg.dma_buff <= 0){
	printk("Can't DAM Buffer was allocated.\n");
	return -1;
  }
  
  univ_set_amsr(A32);
  intlevel = 0;

  return 0;
}


void univ_init_window(unsigned int addr, unsigned int size, int am, int n){
  unsigned long mapaddr, off, mapsize;

  window[n].vaddr = addr;
  window[n].size = size;
  window[n].flags = UNIV_CTL_PWEN;
  window[n].paddr = NULL;
  window[n].am = am;

  master_p[n] =  (vme_master_handle_t *)&window[n].id;
  vme_master_window_create(bus, master_p[n], window[n].vaddr,
			   window[n].am, window[n].size,
			   window[n].flags, window[n].paddr);
  window[n].paddr = vme_master_window_phys_addr(bus, window[n].id);
  off = (unsigned long)window[n].paddr % ps;
  mapaddr = (unsigned long)window[n].paddr - off;
  mapsize = window[n].size + off;
  mapsize += (mapsize % ps) ? ps - (mapsize % ps) : 0;
  //mapptr[n] = ioremap_nocache(mapaddr, mapsize);
  mapptr[n] = ioremap(mapaddr, mapsize);
  vmeptr[n] = mapptr[n] + off;

  //printk("univ_init_window[%d] / mapptr=%p / vmeptr=%p / size=%u\n",
  //n, mapptr[n], vmeptr[n], size);

}

void univ_end_window(int n){
  vfree(mapptr[n]);
  vme_master_window_release(bus, *master_p[n]);

  //printk("univ_end_window[%d] master_p=%p\n", n, master_p[n]);
}

void univ_map_read16(unsigned int off, short *data, int n){
  *data = readw(vmeptr[n]+off);
}	

void univ_map_read32(unsigned int off, int *data, int n){
  *data = readl(vmeptr[n]+off);
}	

void univ_map_write16(unsigned int off, short *data, int n){
  writew(*data, vmeptr[n]+off);
}	

void univ_map_write32(unsigned int off, int *data, int n){
  writel(*data, vmeptr[n]+off);
}


void univ_set_amsr(unsigned char am){
  twindow.am = (int)am;
}

char *univ_set_vmewindow(unsigned int addr, unsigned int size, int flags){
  unsigned long tmapaddr, toff, tmapsize;

  twindow.vaddr = addr;
  twindow.size = size;
  twindow.flags = flags;
  twindow.paddr = NULL;

  tmaster_p =  (vme_master_handle_t *)&twindow.id;
  vme_master_window_create(bus, tmaster_p, twindow.vaddr,
		  twindow.am, twindow.size, twindow.flags, twindow.paddr);
  twindow.paddr = vme_master_window_phys_addr(bus, twindow.id);
  toff = (unsigned long)twindow.paddr % ps;
  tmapaddr = (unsigned long)twindow.paddr - toff;
  tmapsize = twindow.size + toff;
  tmapsize += (tmapsize % ps) ? ps - (tmapsize % ps) : 0;
  //tmapptr = ioremap_nocache(tmapaddr, tmapsize);
  tmapptr = ioremap(tmapaddr, tmapsize);

  return tmapptr + toff;
}

void univ_unset_vmewindow(void){
  vfree(tmapptr);
  vme_master_window_release(bus, *tmaster_p);
}

void univ_vread16(unsigned int addr,short *data){
  char *ptr;
  
  ptr = univ_set_vmewindow(addr, 2, UNIV_CTL_PWEN);
  *data = readw(ptr);
  univ_unset_vmewindow();
	
}

void univ_vread32(unsigned int addr,int *data){
  char *ptr;

  ptr = univ_set_vmewindow(addr, 4, UNIV_CTL_PWEN);
  *data = readl(ptr);
  univ_unset_vmewindow();
}

void univ_vwrite16(unsigned int addr,short *data){
  char *ptr;

  ptr = univ_set_vmewindow(addr, 2, UNIV_CTL_PWEN);
  writew(*data, ptr);
  univ_unset_vmewindow();
}

void univ_vwrite32(unsigned int addr,int *data){
  char *ptr;

  ptr = univ_set_vmewindow(addr, 4, UNIV_CTL_PWEN);
  writel(*data, ptr);
  univ_unset_vmewindow();
}

void univ_dma_vread32(unsigned int addr,int *data){
}

char *univ_dma_addr(void){
  return vreg.dma_buff;
}

void univ_dma_vread32_start(unsigned int addr,int size){
  //univ_init_dma(addr,univ_DMA_READ,univ_DMA_LONGWORD,size);
}

int univ_dma_vread32_store(char *data, int size){
  int ret;

  if(univ_check_dma()){
    ret = 1;
  }else{
    ret = 0;
    return ret;
  }

  memcpy(data,vreg.dma_buff,size);

  return ret;
}

int univ_check_dma(void){
  //return readb(vreg.csr + univ_DMA_COMMAND) & univ_DMA_DONE;
  return 1;
}

 int univ_get_dma_status(void){
  //return readb(vreg[dn].csr + univ_LOCAL_STATUS);
  return 1;
 }

 void univ_define_intlevel(int level){
  intleveln = (short)level;
  intlevel = 1<<level;
}

void univ_enable_interrupt(void){
  //vme_interrupt_clear(bus, interrupt);
}
  
void univ_disable_interrupt(void){
  //vme_interrupt_vector(bus, interrupt, &vector);
  
}

int univ_check_interrupt(void){
  //vme_interrupt_asserted(bus, interrupt);
  //  if((readb(vreg[0].csr + univ_INT_CTRL) & univ_IS_INTERRUPT)
  //   == univ_IS_INTERRUPT){
  //if((readb(vreg[0].csr + univ_INT_STATUS) & intlevel[0]) == intlevel[0]){
  //return 1;
  //}
  //}
  return 0;
}

int univ_read_intvector(void){
  //vme_interrupt_vector(bus, interrupt, &vector);

  return 0;
}


 

void *mmp(unsigned long paddr, size_t size, int n){
  unsigned long dmapaddr, doff, dmapsize;
  doff = paddr % ps;
  dmapaddr = paddr - doff;
  dmapsize = size + doff;
  dmapsize += (dmapsize % ps) ? ps - (dmapsize % ps) : 0;
  
  //dmamapptr[n] = ioremap_nocache(dmapaddr, dmapsize);
  dmamapptr[n] = ioremap(dmapaddr, dmapsize);
  
  return dmamapptr[n] + doff;
}


int univ_dma_window(unsigned int size, int n){
  int status;
  dma[n].size = size;
  dma[n].flags = 0;
  dma[n].paddr = NULL;
  
  dma_p[n] = (vme_dma_handle_t *) & dma[n].id;
  status = vme_dma_buffer_create(bus, dma_p[n], dma[n].size,
				 dma[n].flags, dma[n].paddr);
  dma[n].paddr = vme_dma_buffer_phys_addr(bus, dma[n].id);
  dmaptr[n] = mmp((unsigned long)dma[n].paddr, dma[n].size, n);

  return 0;
}


void univ_init_dma(unsigned long vaddr, unsigned int size, int n){
  univ_dma_window(size, n);
  
  dma[n].vaddr = vaddr;
  dma[n].offset = 0;
  dma[n].am = 0x0b;
}

void univ_end_dma(int n){
  vfree(dmamapptr[n]);
  vme_dma_buffer_release(bus, *dma_p[n]);
}

int univ_dma_read(char *ptr, int size, int n){
  unsigned int csize;

  csize = size - 
    vme_dma_read2(bus, *dma_p[n], dma[n].offset, dma[n].vaddr, dma[n].am,
		  size, dma[n].flags);
  memcpy(ptr, dmaptr[n], csize);

  return csize;
}
