/*
 * Tundra Universe
 * Use with vmisft driver (vme_univmerse.o)
 * 
 * VME Access Module
 * Hidetada Baba
 * 2005/11/28
 */

#include <linux/version.h>
#if LINUX_VERSION_CODE >=  0x020600
#if defined(USE_MODVERSIONS) && USE_MODVERSIONS
#  define MODVERSIONS
#  include <config/modversions.h>
#endif
#endif

#include <linux/module.h>
#include <linux/kernel.h>
#if LINUX_VERSION_CODE >=  0x020600
#include <linux/init.h>
#endif
#include <linux/ioctl.h>
#include <linux/sched.h>
#if LINUX_VERSION_CODE <  0x020600
#include <linux/config.h>
#endif
#include <linux/pci.h>
#include <linux/errno.h>
#include <asm/io.h>
#include <asm/delay.h>

#if LINUX_VERSION_CODE <  0x020400
#include <linux/malloc.h>
#endif

#if LINUX_VERSION_CODE >=  0x020410
MODULE_LICENSE("GPL");
#endif
#if LINUX_VERSION_CODE >=  0x020600
MODULE_AUTHOR("Hidetada Baba");
#endif

#if LINUX_VERSION_CODE <  0x020400
#include <linux/malloc.h>
#endif

#include "univ.c"
int univ_get_irq(void);


#if LINUX_VERSION_CODE >= 0x020600
EXPORT_SYMBOL(univ_set_amsr);
EXPORT_SYMBOL(univ_vread16);
EXPORT_SYMBOL(univ_vread32);
EXPORT_SYMBOL(univ_vwrite16);
EXPORT_SYMBOL(univ_vwrite32);
EXPORT_SYMBOL(univ_map_read16);
EXPORT_SYMBOL(univ_map_read32);
EXPORT_SYMBOL(univ_map_write16);
EXPORT_SYMBOL(univ_map_write32);
EXPORT_SYMBOL(univ_get_irq);
EXPORT_SYMBOL(univ_define_intlevel);
EXPORT_SYMBOL(univ_enable_interrupt);
EXPORT_SYMBOL(univ_disable_interrupt);
EXPORT_SYMBOL(univ_check_interrupt);
EXPORT_SYMBOL(univ_dma_vread32_start);
EXPORT_SYMBOL(univ_dma_vread32_store);
EXPORT_SYMBOL(univ_init_window);
EXPORT_SYMBOL(univ_end_window);
EXPORT_SYMBOL(univ_init_dma);
EXPORT_SYMBOL(univ_end_dma);
EXPORT_SYMBOL(univ_dma_read);
EXPORT_SYMBOL(univ_read_intvector);
#endif



/* Local device */
#define BOARDID  0x0100
#define INTSTAT  0x0104
#define INTMASK  0x0108
#define INTPIN   0x010c
#define WDTRST   0x0110
#define SWAPMODE 0x0114
#define PMCMODE  0x0118
#define WDTMODE  0x011c


#if LINUX_VERSION_CODE >= 0x020600
static int univ_init_module(void)
#else
int init_module(void)
#endif
{

  printk("bb-sva041 : registerd for SVA041\n");

  univ_init_register();

  /* Init SVA041 Local Device */
  outw(0x55aa, PMCMODE);   // remove protect
  outw(0x01, SWAPMODE);    // set big endian
  printk("SVA041 BoardID = %04x\n", inw(BOARDID));
  outw(0x0000, PMCMODE);   // protect

  return 0;
}

#if LINUX_VERSION_CODE >= 0x020600
static void univ_cleanup_module(void)
#else
void cleanup_module(void)
#endif
{

  kfree(vreg.dma_buff);

}

int univ_get_irq(void){
  return univconfig.irq;
}

#if LINUX_VERSION_CODE >= 0x020600
module_init(univ_init_module);
module_exit(univ_cleanup_module);
#endif
