/* sbs620.h
 * Header for SBS620
 *
 * H.Baba (Rikkyo Univ.)
 * Jun 26, 2003
 *
 */

/* VENDOR ID */
#define SBS620_VENDOR_ID      0x108a
#define SBS620_DEVICE_ID      0x0010

/* Common */
#define VME_PAGE             0x1000
#define A32                  0x09
#define A24                  0x39
#define A32BLK               0x0b
#define A24BLK               0x3b
#define SBS620_BUS_IO        0x01
#define SBS620_BUS_RAM       0x02
#define SBS620_DUAL_RAM      0x03
#define SBS620_SWAP_NONE     0x00
#define SBS620_SWAP_BYTE     0x01
#define SBS620_SWAP_WORD     0x02
#define SBS620_DMA_SIZE      0x4000
#define SBS620_DMA_TRANSFER_SIZE 144
#define SBS620_DMA_PACKET_SIZE 256

/* SBS620 */
#define SBS620_CSRBASE        0x0
#define SBS620_CSR_SIZE       32
#define SBS620_MAP_SIZE       0x10000
#define SBS620_REMOTE_SIZE    0x2000000
#define SBS620_PCI_OFFSET     0x8000
#define SBS620_DMA_OFFSET     0xc000

/* CSR Register */
#define SBS620_LOCAL_COMMAND     0x00
#define SBS620_INT_CTRL          0x01
#define SBS620_LOCAL_STATUS      0x02
#define SBS620_INT_STATUS        0x03
#define SBS620_PCI_CTRL          0x04
#define SBS620_REMOTE_COMMAND1   0x08
#define SBS620_REMOTE_COMMAND2   0x09
#define SBS620_ADAPTER_ID        0x0c
#define SBS620_REMOTE_AM         0x0d
#define SBS620_IACK_LOW          0x0E
#define SBS620_IACK_HIGH         0x0F
#define SBS620_DMA_COMMAND       0x10
#define SBS620_DMA_REMAINDER_CNT 0x11
#define SBS620_DMA_REMOTE_REMAINDER_CNT 0x18
#define SBS620_DMA_PACKET_CNT_0_7   0x12
#define SBS620_DMA_PACKET_CNT_8_15  0x13
#define SBS620_DMA_PCI_ADDR_2_7     0x14
#define SBS620_DMA_PCI_ADDR_8_15    0x15
#define SBS620_DMA_PCI_ADDR_16_23   0x16
#define SBS620_DMA_VME_ADDR_16_23   0x1a
#define SBS620_DMA_VME_ADDR_24_31   0x1b
#define SBS620_DMA_VME_ADDR_0_7     0x1c
#define SBS620_DMA_VME_ADDR_8_15    0x1d

/* Bit */
#define SBS620_CLEAR_STATUS_ERR  0x80
#define SBS620_POWER             0x01
#define SBS620_REMOTE_RESET      0x80
#define SBS620_ENABLE_INTERRUPT  0x40
#define SBS620_DISABLE_INTERRUPT 0x00
#define SBS620_IS_INTERRUPT      0x80
#define SBS620_CLEAR_INTERRUPT   0x40
#define SBS620_DMA_CLEAR         0x00
#define SBS620_DMA_STARTDMA      0x80
#define SBS620_DMA_WRITE         0x20
#define SBS620_DMA_READ          0x00
#define SBS620_DMA_LONGWORD      0x10
#define SBS620_DMA_SHORTWORD     0x00
#define SBS620_DMA_INT_DONE      0x04
#define SBS620_DMA_DONE          0x02
#define SBS620_DMA_ACTIVE        0x01
#define SBS620_DMA_PAUSE_ON      0x80
#define SBS620_DMA_BLOCK_MODE    0x20
#define SBS620_DMA_DIS_INT_PASS  0x10

/* Mask */
#define SBS620_BASE_MASK         0xfffff000
#define SBS620_OFFSET_MASK       0x0fff
#define SBS620_DMA_BASE_MASK     0xfffff000
#define SBS620_DMA_OFFSET_MASK   0x0fff

/* Shift */
#define SBS620_AM_MASK           0x003f
#define SBS620_AM_SHIFT          6
#define SBS620_FUNC_MASK         0x0003
#define SBS620_FUNC_SHIFT        4
#define SBS620_SWAP_MASK         0x0007
#define SBS620_SWAP_SHIFT        1
#define SBS620_DMA_SWAP_MASK     0x0003
#define SBS620_DMA_SWAP_SHIFT    1

#if LINUX_VERSION_CODE >= 0x020600
static const struct pci_device_id sbs620_device_id_table[] = {
  {PCI_DEVICE(SBS620_VENDOR_ID, SBS620_DEVICE_ID), .driver_data = 0,},
  { }
};
#endif
