/* bb-k2915.c
   K3922 + K2915 CAMAC Access Module
*/


#include <linux/version.h>
#if LINUX_VERSION_CODE >=  0x020600
#if defined(USE_MODVERSIONS) && USE_MODVERSIONS
#  define MODVERSIONS
#  include <config/modversions.h>
#endif
#endif

#include <linux/module.h>
#include <linux/kernel.h>
#if LINUX_VERSION_CODE >=  0x020600
#include <linux/init.h>
#endif
#include <linux/ioctl.h>
#include <linux/sched.h>
#if LINUX_VERSION_CODE <  0x020600
#include <linux/config.h>
#endif
#include <linux/pci.h>
#include <linux/errno.h>
#include <asm/io.h>
#include <asm/delay.h>

#if LINUX_VERSION_CODE <  0x020400
#include <linux/malloc.h>
#endif

#include "k2915.c"
#define cc_basea 0
#define cc_baseb 1

#if LINUX_VERSION_CODE >=  0x020410
  MODULE_LICENSE("GPL");
#endif
#if LINUX_VERSION_CODE >=  0x020600
MODULE_AUTHOR("Hidetada Baba");
#endif

static int girq;
int k2915_get_irq(void);
unsigned long tioa,tiob,tir;

#if LINUX_VERSION_CODE >= 0x020600
struct pci_dev* k2915_pci_dev;

static int k2915_pci_probe(struct pci_dev *dev, const struct pci_device_id *id);
static void k2915_pci_remove(struct pci_dev *dev);

static struct pci_driver k2915_pci_driver = {
  .id_table = k2915_device_id_table,
  .probe = k2915_pci_probe,
  .remove = k2915_pci_remove,
};
static volatile int probflag;
#else
int detect_pci_device(unsigned vendor,unsigned device,unsigned long *tioa,
		      unsigned long *tiob, unsigned long *tir);

#endif

#if LINUX_VERSION_CODE >= 0x020600
EXPORT_SYMBOL(k2915_init_register);
EXPORT_SYMBOL(k2915_check_done);
EXPORT_SYMBOL(k2915_check_emp_fifo);
EXPORT_SYMBOL(k2915_check_full_fifo);
EXPORT_SYMBOL(k2915_check_lam);         
EXPORT_SYMBOL(k2915_read_lam);               
EXPORT_SYMBOL(k2915_control);                
EXPORT_SYMBOL(k2915_read16);                 
EXPORT_SYMBOL(k2915_read24);                  
EXPORT_SYMBOL(k2915_write16);
EXPORT_SYMBOL(k2915_write24);
EXPORT_SYMBOL(k2915_block_read16);
EXPORT_SYMBOL(k2915_block_read24);
EXPORT_SYMBOL(k2915_dma_block_read16);
EXPORT_SYMBOL(k2915_dma_block_read24);
EXPORT_SYMBOL(k2915_crate_reset);        
EXPORT_SYMBOL(k2915_rfs_enable_interrupt);
EXPORT_SYMBOL(k2915_rfs_disable_interrupt);
EXPORT_SYMBOL(k2915_pci_enable_interrupt);
EXPORT_SYMBOL(k2915_pci_clear_interrupt);
EXPORT_SYMBOL(k2915_crate_enable_lam);     
EXPORT_SYMBOL(k2915_crate_disable_lam);      
EXPORT_SYMBOL(k2915_crate_define_lam);      
EXPORT_SYMBOL(k2915_crate_z);         
EXPORT_SYMBOL(k2915_crate_c);
EXPORT_SYMBOL(k2915_crate_seti);
EXPORT_SYMBOL(k2915_crate_deli);
EXPORT_SYMBOL(k2915_get_csrdata);
EXPORT_SYMBOL(k2915_get_bmcsdata);
EXPORT_SYMBOL(k2915_get_irq);
EXPORT_SYMBOL(k2915_chkq);
#endif

#if LINUX_VERSION_CODE >= 0x020600
static int k2915_init_module(void)
#else
int init_module(void)
#endif
{
  int ret, err;

  ret = 0;
#if LINUX_VERSION_CODE >= 0x020600
  probflag = 0;
  k2915_pci_driver.name = "K2915";
  k2915_pci_dev = NULL;
  err = pci_register_driver(&k2915_pci_driver);
  if(k2915_pci_dev == NULL || err < 0){
    printk("K2915 Can't find.\n");
    return -ENODEV;
  }
  schedule_timeout(5);
  probflag = 1;
  pci_unregister_driver(&k2915_pci_driver);
  err = pci_register_driver(&k2915_pci_driver);
#else
    ret = detect_pci_device(CC_VENDOR_ID,CC_DEVICE_ID,&tioa,&tiob,&tir);
    if(ret){
      printk("K2915 Can't find.\n");
      return ret;
    }
#endif
    printk("K2915 found at ioport 0x%04lx 0x%04lx on irq %lu.\n",tioa,tiob,tir);

    k2915_init_register(tir,tioa,tiob);

    girq = tir;

    return 0;
}

#if LINUX_VERSION_CODE >= 0x020600
static void k2915_cleanup_module(void)
#else
void cleanup_module(void)
#endif
{
#if LINUX_VERSION_CODE >= 0x020600
  pci_unregister_driver(&k2915_pci_driver);
#endif
}

#if LINUX_VERSION_CODE < 0x020600
int detect_pci_device(unsigned vendor,unsigned device,unsigned long *tioa,
		      unsigned long *tiob, unsigned long *tir){
    struct pci_dev *dev;

    if (!pcibios_present()){
      printk("CC: unable to find PCI bios.\n");
      return -ENODEV;
    }

    dev = NULL;
    dev = pci_find_device(vendor, device, dev);

    if(dev == NULL){
      return -ENODEV;
    }

#if LINUX_VERSION_CODE >=  0x020400
    *tioa = dev->resource[cc_basea].start & PCI_BASE_ADDRESS_IO_MASK;
    *tiob = dev->resource[cc_baseb].start & PCI_BASE_ADDRESS_IO_MASK;
    *tir  = dev->irq;
#else
    *tioa = dev->base_address[cc_basea] & PCI_BASE_ADDRESS_IO_MASK;
    *tiob = dev->base_address[cc_baseb] & PCI_BASE_ADDRESS_IO_MASK;
    *tir  = dev->irq;
#endif

    return 0;
}
#endif

int k2915_get_irq(void){
  return girq;
}

#if LINUX_VERSION_CODE >= 0x020600
static int k2915_pci_probe(struct pci_dev *dev, const struct pci_device_id *id){
  int ret;

  k2915_pci_dev = dev;

  if(probflag){
    tioa = dev->resource[0].start & PCI_BASE_ADDRESS_IO_MASK;
    tiob = dev->resource[1].start & PCI_BASE_ADDRESS_IO_MASK;
    tir  = dev->irq;
  }
  ret = pci_enable_device(dev);

  return ret;
}

static void k2915_pci_remove(struct pci_dev *dev){
}


module_init(k2915_init_module);
module_exit(k2915_cleanup_module);
#endif
