/* bb-ccnet.c
 * last modified : 08/10/15 14:39:24 
 *
 * TOYO CC/NET CAMAC Access Module
 * Origiranl version = pcc.c by Yasu-san
 *
 * Hidetada Baba (RIKEN)
 * baba@ribf.riken.jp
 *
 */


#include <linux/version.h>
#if LINUX_VERSION_CODE >=  0x020600
#if defined(USE_MODVERSIONS) && USE_MODVERSIONS
#define MODVERSIONS
#include <config/modversions.h>
#endif
#endif

#include <linux/module.h>
#include <linux/kernel.h>
#if LINUX_VERSION_CODE >=  0x020600
#include <linux/init.h>
#endif
#include <linux/ioctl.h>
#include <linux/sched.h>
#if LINUX_VERSION_CODE <  0x020600
#include <linux/config.h>
#endif
#include <linux/pci.h>
#include <linux/errno.h>
#include <asm/io.h>
#include <asm/delay.h>

#if LINUX_VERSION_CODE <  0x020400
#include <linux/malloc.h>
#endif

#include "pcc.h"

#if LINUX_VERSION_CODE >=  0x020410
MODULE_LICENSE("GPL");
#endif
#if LINUX_VERSION_CODE >=  0x020600
MODULE_AUTHOR("Hidetada Baba");
#endif

struct pcc_device{
  char *io_base;
  unsigned int irq;
  char *name;
#if LINUX_VERSION_CODE >= 0x020600
  wait_queue_head_t waitqTx;
  wait_queue_head_t waitqRx;
  wait_queue_head_t waitqInt;
#else
  struct wait_queue *waitqTx;
  struct wait_queue *waitqRx;
  struct wait_queue *waitqInt;
#endif
  struct pccreg pccreg;
  int statusRxInt, statusTxInt, statusIntInt;
volatile  int int_write_counter;
volatile  int int_read_counter;
volatile  int int_ifrm_counter;
volatile  int usr_write_counter;
volatile  int usr_read_counter;
volatile  int usr_ifrm_counter;
  int read_flag;
  int dma_flag;
};

static int girq;
static struct pcc_device pccdev;

#if LINUX_VERSION_CODE >= 0x020600
static const struct pci_device_id ccnet_device_id_table[] = {
  {PCI_DEVICE(PCI_VENDOR_ID_PCC, PCI_DEVICE_ID_PCC), .driver_data = 0,},
  { }
};
#endif


int ccnet_get_irq(void);
#if LINUX_VERSION_CODE >= 0x020600
struct pci_dev* ccnet_pci_dev;

static int ccnet_pci_probe(struct pci_dev *dev, const struct pci_device_id *id);
static void ccnet_pci_remove(struct pci_dev *dev);

static struct pci_driver ccnet_pci_driver = {
  .id_table = ccnet_device_id_table,
  .probe = ccnet_pci_probe,
  .remove = ccnet_pci_remove,
};
static volatile int probflag;
#else
int detect_pci_device(unsigned vendor,unsigned device);
#endif

#include "ccnet.c"

#if LINUX_VERSION_CODE >= 0x020600
EXPORT_SYMBOL(ccnet_init_register);
EXPORT_SYMBOL(ccnet_check_done);
EXPORT_SYMBOL(ccnet_check_emp_fifo);
EXPORT_SYMBOL(ccnet_check_full_fifo);
EXPORT_SYMBOL(ccnet_check_lam);         
EXPORT_SYMBOL(ccnet_read_lam);               
EXPORT_SYMBOL(ccnet_control);                
EXPORT_SYMBOL(ccnet_read16);                 
EXPORT_SYMBOL(ccnet_read24);                  
EXPORT_SYMBOL(ccnet_write16);
EXPORT_SYMBOL(ccnet_write24);
EXPORT_SYMBOL(ccnet_block_read16);
EXPORT_SYMBOL(ccnet_block_read24);
EXPORT_SYMBOL(ccnet_dma_block_read16);
EXPORT_SYMBOL(ccnet_dma_block_read24);
EXPORT_SYMBOL(ccnet_crate_reset);        
EXPORT_SYMBOL(ccnet_rfs_enable_interrupt);
EXPORT_SYMBOL(ccnet_rfs_disable_interrupt);
EXPORT_SYMBOL(ccnet_pci_enable_interrupt);
EXPORT_SYMBOL(ccnet_pci_clear_interrupt);
EXPORT_SYMBOL(ccnet_crate_enable_lam);     
EXPORT_SYMBOL(ccnet_crate_disable_lam);      
EXPORT_SYMBOL(ccnet_crate_define_lam);      
EXPORT_SYMBOL(ccnet_crate_z);         
EXPORT_SYMBOL(ccnet_crate_c);
EXPORT_SYMBOL(ccnet_crate_seti);
EXPORT_SYMBOL(ccnet_crate_deli);
EXPORT_SYMBOL(ccnet_get_csrdata);
EXPORT_SYMBOL(ccnet_get_bmcsdata);
EXPORT_SYMBOL(ccnet_get_irq);
EXPORT_SYMBOL(ccnet_chkq);
EXPORT_SYMBOL(ccnet_exec);
EXPORT_SYMBOL(ccnet_exec_dma);
EXPORT_SYMBOL(ccnet_exec_pio);
EXPORT_SYMBOL(ccnet_clear_fifo);
#endif


#if LINUX_VERSION_CODE >= 0x020600
static int ccnet_init_module(void)
#else
int init_module(void)
#endif
{
  int ret, err;

  ret = 0;
#if LINUX_VERSION_CODE >= 0x020600
  probflag = 0;
  ccnet_pci_driver.name = "CCNET";
  ccnet_pci_dev = NULL;
  err = pci_register_driver(&ccnet_pci_driver);
  if(ccnet_pci_dev == NULL || err < 0){
    printk("CCNET Can't find.\n");
    return -ENODEV;
  }
  /* Register again to avoid APIC's IRQ change */
  schedule_timeout(5);
  probflag = 1;
  pci_unregister_driver(&ccnet_pci_driver);
  err = pci_register_driver(&ccnet_pci_driver);
#else
  ret = detect_pci_device(PCI_VENDOR_ID_PCC, PCI_DEVICE_ID_PCC);
  if(ret){
    printk("CCNET Can't find.\n");
      return ret;
  }
#endif
  printk("CCNET found at ioport 0x%p on irq %d.\n",pccdev.io_base, pccdev.irq);

  if(ccnet_init_register()){
    printk("CCNET: Error in init_register\n");
    return -ENODEV;
  }

  girq = pccdev.irq;
  ccnet_check_lam();

  return 0;
}


#if LINUX_VERSION_CODE >= 0x020600
static void ccnet_cleanup_module(void)
#else
void cleanup_module(void)
#endif
{
#if LINUX_VERSION_CODE >= 0x020600
  pci_unregister_driver(&ccnet_pci_driver);
#endif
}

#if LINUX_VERSION_CODE < 0x020600
int detect_pci_device(unsigned vendor,unsigned device){
    struct pci_dev *dev;

    if (!pcibios_present()){
      printk("CCNET: unable to find PCI bios.\n");
      return -ENODEV;
    }

    dev = NULL;
    dev = pci_find_device(vendor, device, dev);

    if(dev == NULL){
      return -ENODEV;
    }

#if LINUX_VERSION_CODE <= 0x020600
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0)
    pci_enable_device(dev);
    pccdev.io_base = (char *)pci_resource_start(dev, 0);
#else
    pccdev.io_base = (char *)(dev->base_address[0] & PCI_BASE_ADDRESS_MEM_MASK);
#endif
#endif

    pccdev.irq = dev->irq;

    pccdev.pccreg.TxData1 = (int)(pccdev.io_base + TXDATA1);
    pccdev.pccreg.TxData2 = (int)(pccdev.io_base + TXDATA2);
    pccdev.pccreg.TxControl = (int)(pccdev.io_base + TXCONTROL);
    pccdev.pccreg.TxStatus = (int)(pccdev.io_base + TXSTATUS);
    pccdev.pccreg.TxAddress = (int)(pccdev.io_base + TXADDRESS);
    pccdev.pccreg.TxPresetCount = (int)(pccdev.io_base + TXPRESETCOUNT);
    pccdev.pccreg.TxActualCount = (int)(pccdev.io_base + TXACTUALCOUNT);
    pccdev.pccreg.TxFifoCount = (int)(pccdev.io_base + TXFIFOCOUNT);
    pccdev.pccreg.RxData1 = (int)(pccdev.io_base + RXDATA1);
    pccdev.pccreg.RxData2 = (int)(pccdev.io_base + RXDATA2);
    pccdev.pccreg.RxControl = (int)(pccdev.io_base + RXCONTROL);
    pccdev.pccreg.RxStatus = (int)(pccdev.io_base + RXSTATUS);
    pccdev.pccreg.RxAddress = (int)(pccdev.io_base + RXADDRESS);
    pccdev.pccreg.RxPresetCount = (int)(pccdev.io_base + RXPRESETCOUNT);
    pccdev.pccreg.RxActualCount = (int)(pccdev.io_base + RXACTUALCOUNT);
    pccdev.pccreg.RxFifoCount = (int)(pccdev.io_base + RXFIFOCOUNT);
    pccdev.pccreg.System = (int)(pccdev.io_base + SYSTEM);
    pccdev.pccreg.IntData1 = (int)(pccdev.io_base + INTDATA1);
    pccdev.pccreg.IntData2 = (int)(pccdev.io_base + INTDATA2);
    pccdev.pccreg.IntControl = (int)(pccdev.io_base + INTCONTROL);
    pccdev.pccreg.IntStatus = (int)(pccdev.io_base + INTSTATUS);
    pccdev.pccreg.IntFifoCount = (int)(pccdev.io_base + INTFIFOCOUNT);

    return 0;
}
#endif

int ccnet_get_irq(void){
  return girq;
}


#if LINUX_VERSION_CODE >= 0x020600
static int ccnet_pci_probe(struct pci_dev *dev, const struct pci_device_id *id){
  int ret;

  ccnet_pci_dev = dev;

  if(probflag){
    pccdev.io_base = (char *)(dev->resource[0].start & PCI_BASE_ADDRESS_IO_MASK);
    pccdev.irq = dev->irq;

    pccdev.pccreg.TxData1 = (int)(pccdev.io_base + TXDATA1);
    pccdev.pccreg.TxData2 = (int)(pccdev.io_base + TXDATA2);
    pccdev.pccreg.TxControl = (int)(pccdev.io_base + TXCONTROL);
    pccdev.pccreg.TxStatus = (int)(pccdev.io_base + TXSTATUS);
    pccdev.pccreg.TxAddress = (int)(pccdev.io_base + TXADDRESS);
    pccdev.pccreg.TxPresetCount = (int)(pccdev.io_base + TXPRESETCOUNT);
    pccdev.pccreg.TxActualCount = (int)(pccdev.io_base + TXACTUALCOUNT);
    pccdev.pccreg.TxFifoCount = (int)(pccdev.io_base + TXFIFOCOUNT);
    pccdev.pccreg.RxData1 = (int)(pccdev.io_base + RXDATA1);
    pccdev.pccreg.RxData2 = (int)(pccdev.io_base + RXDATA2);
    pccdev.pccreg.RxControl = (int)(pccdev.io_base + RXCONTROL);
    pccdev.pccreg.RxStatus = (int)(pccdev.io_base + RXSTATUS);
    pccdev.pccreg.RxAddress = (int)(pccdev.io_base + RXADDRESS);
    pccdev.pccreg.RxPresetCount = (int)(pccdev.io_base + RXPRESETCOUNT);
    pccdev.pccreg.RxActualCount = (int)(pccdev.io_base + RXACTUALCOUNT);
    pccdev.pccreg.RxFifoCount = (int)(pccdev.io_base + RXFIFOCOUNT);
    pccdev.pccreg.System = (int)(pccdev.io_base + SYSTEM);
    pccdev.pccreg.IntData1 = (int)(pccdev.io_base + INTDATA1);
    pccdev.pccreg.IntData2 = (int)(pccdev.io_base + INTDATA2);
    pccdev.pccreg.IntControl = (int)(pccdev.io_base + INTCONTROL);
    pccdev.pccreg.IntStatus = (int)(pccdev.io_base + INTSTATUS);
    pccdev.pccreg.IntFifoCount = (int)(pccdev.io_base + INTFIFOCOUNT);
  }
  ret = pci_enable_device(dev);

  return ret;
}

static void ccnet_pci_remove(struct pci_dev *dev){
}


module_init(ccnet_init_module);
module_exit(ccnet_cleanup_module);
#endif
