/* cc7700.h
 *
 * Copy from cc_2915.h
 * H.baba
 * Feb 24, 2002
 */

#define CC_VENDOR_ID 0x0001
#define CC_DEVICE_ID 0xcc77

#define CSR         ( 0x00 )  /* Control/Status Register (CSR & MCR) */
#define CNAF        ( 0x04 )  /* CAMAC Crate/Command Register */
#define TCR         ( 0x00 )  /* Transfer Count Register */
#define SRR         ( 0x0c )  /* GO Register */

#define FIFO        ( 0x08 )  /* Data FIFO Register */
#define MWA         ( 0x00 )  /* Not use */
#define MWTC        ( 0x00 )  /* Not use */
#define MRA         ( 0x00 )  /* Not use */
#define MRTC        ( 0x00 )  /* Not use */
#define ICS         ( 0x00 )  /* Not use */
#define BMCS        ( 0x00 )  /* Not use */

/* Macros */
#define CNAFGEN(c,n,a,f) (0x00073fff & (c<<16 | (n-1)<<9 | a <<5 | f))
#define NAFGEN(n,a,f) ( 0x3fff & ((n-1)<<9 | a <<5 | f) )
#define CLR                       0

/* Camac Driver Status */
#define CC_K_READY                0
#define CC_K_BUSY                 1
#define CC_K_TIMEOUT_LAM          6000 /* units = jiffies = .01 sec */

/* Number of Crates and so on ... */
#define CC_K_MAX_BRANCH           1
#define CC_K_MAX_CRATE            8

#define CCIOC_WAIT_LAM            1
#define CCIOC_RESET               2
#define CCIOC_CHK_BRANCH          3
#define CCIOC_SET_BRANCH          4
#define CCIOC_SET_CRATE           5
#define CCIOC_ENABLE_LAM          6
#define CCIOC_DISABLE_LAM         7
#define CCIOC_REG_DUMP            8
#define CCIOC_SINGLE              9
#define CCIOC_SETUP_DMA          10
#define CCIOC_CMD_STAT           11
#define CCIOC_PPOLL              12
#define CCIOC_ENABLE_INT         13
#define CCIOC_DISABLE_INT        14


/* Control/Status Register(CSR) */
#define RST_INFC         0x10000000
#define NOQ              0x00000001
#define NOX              0x00000002
#define XQ_MASK          0x00030000
#define CSR_MASK         0x0000354E

#define CLR_DNI          0x00000010
#define CLR_PCII         0x00000020
#define DONE_IENA        0x00000040
#define DONE             0x00000010  /* CC/7700 */
#define RFS_IENA         0x00000100
#define RFS              0x00000040  /* CC/7700 */
#define PCI_IENA         0x00000400
#define PCI_IRQ          0x00000800

#define GO               0x00000001
#define ERR              0x80000000  /* Error */
#define SINGLE16         0x00002000  /* Word Size 16bit */
#define SINGLE24         0x00000000  /* Word Size 24bit */     
#define WORD_MASK        0x0000154E  /* Word Size Mask */
#define RFS_MASK         0x0000304E  /* RFS and PCI IENA Mask */
#define NAF_TIMEOUT      0x00080000  /* NAF transfer timeout */
#define PBUS_TIMEOUT     0x00040000  /* Parallel bus timeout */

/* for CC/7700 */
#define CC_C             0x00000001  /* Clear */
#define CC_Z             0x00000002  /* Initialize */
#define CC_I             0x00000004  /* Inhibit */
#define CC_EI            0x00000008  /* Enable Interrupt */
#define CC_LINT          0x00000080  /* LAM Internal */

/* Latency Timer Register(LTR) */
#define LTR_SET          0xF8

/* CAMAC Crate/Command Register(CNAF) */
#define CRATE_MASK       0x000F0000  /* CrateNumber Mask for CNAF */
#define CC_NAFRK_F08     0x00000008  /* F = 8 */
#define CC_NAFRK_F16     0x00000010  /* F = 16 */

/* Bus Master Control/Status Register */
#define FIFO_RESET       0x06000000  /* Reset Data FIFO Register */
#define ADDON_RESET      0x01000000  /* Addon Reset Register */
#define IN_FIFO_EMPTY    0x00000020  /* Inbound  FIFO Empty */
#define IN_FIFO_FULL     0x00000008  /* Inbound  FIFO Empty */
#define OUT_FIFO_EMPTY   0x00000004  /* Outbound FIFO Full */
#define OUT_FIFO_FULL    0x00000001  /* Outbound FIFO Full */
#define BMCS_IN          0x00000010  /* Inbound  FIFO */
#define BMCS_OUT         0x00000002  /* Outbound FIFO */

#define WTT_ENA          0x00000400  /* DMA Write Transfer Enable */
#define RDT_ENA          0x00004000  /* DMA Read Transfer Enable */
#define SINGLE           0x00000000  /* Single Transfer Mode */
#define QSTOP            0x00000002  /* Q-Stop Block Transfer Mode */
#define QIGNORE          0x00000004  /* Q-Ignore Block Transfer Mode */
#define QREPEAT          0x00000006  /* Q-Repeat Block Transfer Mode */
#define QSCAN            0x00000008  /* Q-Scan Block Transfer Mode */
#define PP               0x0000000A  /* Parallel Poll Mode */
#define TRANSFER_MASK    0x0000000E  /* Transfer Mode Mask*/
#define ABT_DIS          0x00001000  /* Abort Disable */
 
/* CC status Register field */
#define CC_MASK 0x000384
#define GEN_Z   0x01
#define GEN_C   0x02
#define INHIBIT 0x04
#define SRE     0x100

/* Driver Error Status */
#define E_CC_DMA        10001   /* DMA Transfer Error */ 

/* Driver LOOP Timer Parameters */
#define MAX_FIFO_TRY            50  /* Max try times FIFO ready */ 
#define MAX_DONE_TRY           100  /* Max try times DONE ready */ 
#define MAX_DMA_TRY        0x7ffff  /* Max try times DONE ready */ 

/* Data Acquisition */
#define DAQGOON 0x00  /* Data Acquisition continue */
#define DAQEND  0xee  /* Data Acquisition finish */


#if LINUX_VERSION_CODE >= 0x020600
static const struct pci_device_id cc77_device_id_table[] = {
  {PCI_DEVICE(CC_VENDOR_ID, CC_DEVICE_ID), .driver_data = 0,},
  { }
};
#endif
