/* bbcc77.c
   CC/7700 + CC/PCI CAMAC Access Module
*/


#include <linux/version.h>
#if LINUX_VERSION_CODE >=  0x020600
#if defined(USE_MODVERSIONS) && USE_MODVERSIONS
#  define MODVERSIONS
#  include <config/modversions.h>
#endif
#endif

#include <linux/module.h>
#include <linux/kernel.h>
#if LINUX_VERSION_CODE >=  0x020600
#include <linux/init.h>
#endif
#include <linux/ioctl.h>
#include <linux/sched.h>
#if LINUX_VERSION_CODE <  0x020600
#include <linux/config.h>
#endif
#include <linux/pci.h>
#include <linux/errno.h>
#include <asm/io.h>
#include <asm/delay.h>

#if LINUX_VERSION_CODE <  0x020400
#include <linux/malloc.h>
#endif

#if LINUX_VERSION_CODE >=  0x020410
MODULE_LICENSE("GPL");
#endif
#if LINUX_VERSION_CODE >=  0x020600
MODULE_AUTHOR("Hidetada Baba");
#endif


#include "cc7700.c"
#define cc_basea 0
#define cc_baseb 0


int cc77_get_irq(void);
#if LINUX_VERSION_CODE >= 0x020600
struct pci_dev* cc77_pci_dev;

static int cc77_pci_probe(struct pci_dev *dev, const struct pci_device_id *id);
static void cc77_pci_remove(struct pci_dev *dev);

static struct pci_driver cc77_pci_driver = {
  .id_table = cc77_device_id_table,
  .probe = cc77_pci_probe,
  .remove = cc77_pci_remove,
};
static volatile int probflag;
#else
int detect_pci_device(unsigned vendor,unsigned device,unsigned long *tioa,
		      unsigned long *tiob, unsigned int *tir);

#endif

#if LINUX_VERSION_CODE >= 0x020600
EXPORT_SYMBOL(cc77_init_register);
EXPORT_SYMBOL(cc77_check_done);
EXPORT_SYMBOL(cc77_check_emp_fifo);
EXPORT_SYMBOL(cc77_check_full_fifo);
EXPORT_SYMBOL(cc77_check_lam);         
EXPORT_SYMBOL(cc77_read_lam);               
EXPORT_SYMBOL(cc77_control);                
EXPORT_SYMBOL(cc77_read16);                 
EXPORT_SYMBOL(cc77_read24);                  
EXPORT_SYMBOL(cc77_write16);
EXPORT_SYMBOL(cc77_write24);
EXPORT_SYMBOL(cc77_block_read16);
EXPORT_SYMBOL(cc77_block_read24);
EXPORT_SYMBOL(cc77_dma_block_read16);
EXPORT_SYMBOL(cc77_dma_block_read24);
EXPORT_SYMBOL(cc77_crate_reset);        
EXPORT_SYMBOL(cc77_rfs_enable_interrupt);
EXPORT_SYMBOL(cc77_rfs_disable_interrupt);
EXPORT_SYMBOL(cc77_pci_enable_interrupt);
EXPORT_SYMBOL(cc77_pci_clear_interrupt);
EXPORT_SYMBOL(cc77_crate_enable_lam);     
EXPORT_SYMBOL(cc77_crate_disable_lam);      
EXPORT_SYMBOL(cc77_crate_define_lam);      
EXPORT_SYMBOL(cc77_crate_z);         
EXPORT_SYMBOL(cc77_crate_c);
EXPORT_SYMBOL(cc77_crate_seti);
EXPORT_SYMBOL(cc77_crate_deli);
EXPORT_SYMBOL(cc77_get_csrdata);
EXPORT_SYMBOL(cc77_get_bmcsdata);
EXPORT_SYMBOL(cc77_get_irq);
EXPORT_SYMBOL(cc77_chkq);
#endif

static int girq;

#if LINUX_VERSION_CODE >= 0x020600
resource_size_t tioa, tiob;
#else
unsigned long tioa, tiob;
#endif
unsigned int tir;

#if LINUX_VERSION_CODE >= 0x020600
static int cc77_init_module(void)
#else
int init_module(void)
#endif
{
  int ret, err;

  ret = 0;
  tir = 0;

#if LINUX_VERSION_CODE >= 0x020600
  probflag = 0;
  cc77_pci_driver.name = "CC77";
  cc77_pci_dev = NULL;
  err = pci_register_driver(&cc77_pci_driver);
  if(cc77_pci_dev == NULL || err < 0){
    printk("CC7700 Can't find.\n");
    return -ENODEV;
  }

  /* Register again to avoid APIC's IRQ change */
  schedule_timeout(5);
  probflag = 1;
  pci_unregister_driver(&cc77_pci_driver);
  err = pci_register_driver(&cc77_pci_driver);
#else
  ret = detect_pci_device(CC_VENDOR_ID,CC_DEVICE_ID,&tioa,&tiob,&tir);
  if(ret){
    printk("CC/7700 Can't find.\n");
    return ret;
  }
#endif
  printk("CC/7700 found at ioport 0x%p 0x%p on irq %u.\n",
	 (void *)tioa, (void *)tiob,tir);
  cc77_init_register(tir, tioa, tiob);

  girq = tir;

  return 0;
}

#if LINUX_VERSION_CODE >= 0x020600
static void cc77_cleanup_module(void)
#else
void cleanup_module(void)
#endif
{
#if LINUX_VERSION_CODE >= 0x020600
  pci_unregister_driver(&cc77_pci_driver);
#endif
}


#if LINUX_VERSION_CODE < 0x020600
int detect_pci_device(unsigned vendor,unsigned device,unsigned long *tioa,
		      unsigned long *tiob, unsigned int *tir){
    struct pci_dev *dev;

    if (!pcibios_present()){
      printk("CC: unable to find PCI bios.\n");
      return -ENODEV;
    }

    dev = NULL;

    dev = pci_find_device(vendor, device, dev);

    if(dev == NULL){
      return -ENODEV;
    }

#if LINUX_VERSION_CODE >=  0x020400
    *tioa = dev->resource[cc_basea].start & PCI_BASE_ADDRESS_IO_MASK;
    *tiob = dev->resource[cc_baseb].start & PCI_BASE_ADDRESS_IO_MASK;
    *tir  = dev->irq;
#else
    *tioa = dev->base_address[cc_basea] & PCI_BASE_ADDRESS_IO_MASK;
    *tiob = dev->base_address[cc_baseb] & PCI_BASE_ADDRESS_IO_MASK;
    *tir  = dev->irq;
#endif

    return 0;
}
#endif

int cc77_get_irq(void){
  return girq;
}

#if LINUX_VERSION_CODE >= 0x020600
static int cc77_pci_probe(struct pci_dev *dev, const struct pci_device_id *id){
  int ret;

  if(!dev) return 0;

  cc77_pci_dev = dev;

  if(probflag){
    tioa = dev->resource[1].start & PCI_BASE_ADDRESS_IO_MASK;
    tiob = dev->resource[0].start & PCI_BASE_ADDRESS_IO_MASK;
    
    if(tiob == 0){
      tiob = tioa;
    }

    tir  = dev->irq;
  }

  ret = pci_enable_device(dev);

  return ret;
}

static void cc77_pci_remove(struct pci_dev *dev){
}


module_init(cc77_init_module);
module_exit(cc77_cleanup_module);
#endif
