/*
 * Advanet Advme8001
 * VME Access Module
 * Hidetada Baba (RIKEN)
 * 
 * Jun 2, 2008
 *
 */


#include <linux/version.h>
#if LINUX_VERSION_CODE >=  0x020600
#if defined(USE_MODVERSIONS) && USE_MODVERSIONS
#  define MODVERSIONS
#  include <config/modversions.h>
#endif
#endif

#include <linux/module.h>
#include <linux/kernel.h>
#if LINUX_VERSION_CODE >=  0x020600
#include <linux/init.h>
#endif
#include <linux/ioctl.h>
#include <linux/sched.h>
#if LINUX_VERSION_CODE <  0x020600
#include <linux/config.h>
#endif
#include <linux/pci.h>
#include <linux/errno.h>
#include <asm/io.h>
#include <asm/delay.h>

#if LINUX_VERSION_CODE <  0x020400
#include <linux/malloc.h>
#endif

#if LINUX_VERSION_CODE >=  0x020410
MODULE_LICENSE("GPL");
#endif
#if LINUX_VERSION_CODE >=  0x020600
MODULE_AUTHOR("Hidetada Baba");
#endif

#include "advme.c"


int advme_get_irq(void);
struct pci_dev* advme_pci_dev;

#if LINUX_VERSION_CODE >= 0x020600
static int advme_pci_probe(struct pci_dev *dev, const struct pci_device_id *id);
static void advme_pci_remove(struct pci_dev *dev);

static struct pci_driver advme_pci_driver = {
  .id_table = advme_device_id_table,
  .probe = advme_pci_probe,
  .remove = advme_pci_remove,
};
static volatile int probflag;
#else
int detect_pci_device(unsigned vendor,unsigned device,resource_size_t *tioa,
		      resource_size_t *tiob, unsigned int *tir);
#endif

#if LINUX_VERSION_CODE >= 0x020600
EXPORT_SYMBOL(advme_set_amsr);
EXPORT_SYMBOL(advme_vread16);
EXPORT_SYMBOL(advme_vread32);
EXPORT_SYMBOL(advme_vwrite16);
EXPORT_SYMBOL(advme_vwrite32);
EXPORT_SYMBOL(advme_get_irq);
EXPORT_SYMBOL(advme_define_intlevel);
EXPORT_SYMBOL(advme_enable_interrupt);
EXPORT_SYMBOL(advme_disable_interrupt);
EXPORT_SYMBOL(advme_check_interrupt);
EXPORT_SYMBOL(advme_dma_vread32_start);
EXPORT_SYMBOL(advme_dma_vread32_store);
#endif

static int girq;
resource_size_t tioa,tiob;
unsigned int tir;

#if LINUX_VERSION_CODE >= 0x020600
static int advme_init_module(void)
#else
int init_module(void)
#endif
{
  int ret, err;

  ret = 0;
#if LINUX_VERSION_CODE >= 0x020600
  probflag = 0;
  advme_pci_driver.name = "ADVME";
  advme_pci_dev = NULL;
  err = pci_register_driver(&advme_pci_driver);
  if(advme_pci_dev == NULL || err < 0){
    printk("ADVME Can't find.\n");
    return -ENODEV;
  }

  /* Register again to avoid APIC's IRQ change */
  schedule_timeout(5);
  probflag = 1;
  pci_unregister_driver(&advme_pci_driver);
  err = pci_register_driver(&advme_pci_driver);
#else
  ret = detect_pci_device(ADVME_VENDOR_ID,ADVME_DEVICE_ID,&tioa,&tiob,&tir);
  if(ret){
    printk("ADVME Can't find.\n");
    return ret;
  }
#endif
  printk("ADVME found at 0x%p 0x%p on irq %u.\n",(void *)tioa,(void *)tiob,tir);
    
  if(advme_init_register(tir,tioa) == -1){
    return -ENODEV;
  }
  
  girq = tir;
  
  return 0;
}

#if LINUX_VERSION_CODE >= 0x020600
static void advme_cleanup_module(void)
#else
void cleanup_module(void)
#endif
{
  vfree(vreg->lcr);

#if LINUX_VERSION_CODE >= 0x020600
  pci_unregister_driver(&advme_pci_driver);
#endif
  
}

#if LINUX_VERSION_CODE < 0x020600
int detect_pci_device(unsigned vendor,unsigned device,resource_size_t *tioa,
		      resource_size_t *tiob, unsigned int *tir){
    struct pci_dev *dev;

    if (!pcibios_present()){
      printk("ADVME: unable to find PCI bios.\n");
      return -ENODEV;
    }

    dev = NULL;
    dev = pci_find_device(vendor, device, dev);

    if(dev == NULL){
      return -ENODEV;
    }

#if LINUX_VERSION_CODE >=  0x020400
    *tioa = dev->resource[0].start & PCI_BASE_ADDRESS_IO_MASK;
    *tiob = dev->resource[1].start & PCI_BASE_ADDRESS_IO_MASK;
    *tir  = dev->irq;
#else
    *tioa = dev->base_address[0] & PCI_BASE_ADDRESS_IO_MASK;
    *tiob = dev->base_address[1] & PCI_BASE_ADDRESS_IO_MASK;
    *tir  = dev->irq;
#endif

    return 0;
}
#endif

int advme_get_irq(void){
  return girq;
}

#if LINUX_VERSION_CODE >= 0x020600
static int advme_pci_probe(struct pci_dev *dev, const struct pci_device_id *id){
  int ret;

  advme_pci_dev = dev;

  if(probflag){
    tioa = dev->resource[0].start & PCI_BASE_ADDRESS_IO_MASK;
    tiob = dev->resource[1].start & PCI_BASE_ADDRESS_IO_MASK;
    tir  = dev->irq;
  }

  ret = pci_enable_device(dev);

  return ret;
}

static void advme_pci_remove(struct pci_dev *dev){
}


module_init(advme_init_module);
module_exit(advme_cleanup_module);
#endif
