/* advme.h
 * Header for ADVME
 *
 * Jun 14, 2002
 * H.Baba
 *
 */

/* VENDOR ID */
#define ADVME_VENDOR_ID      0x10E3
#define ADVME_DEVICE_ID      0x0000

/* Common */
#define VME_PAGE             0x1000
#define A32                  0x09
#define A24                  0x39
#define A16                  0x29

/* Bit */
#define ADVME_SYSFAIL_BIT 0xc0000000

#define ADVME_UNI_LSI0_BS  0xf0000000
#define ADVME_UNI_LSI0_BD  0xf2000000
#define ADVME_REMOTE_SIZE  0x02000000

/* CTL */
#define ADVME_CTL_EN     0x80000000
#define ADVME_CTL_PWDI   0x00000000
#define ADVME_CTL_PWEN   0x40000000
#define ADVME_CTL_D8     0x00000000
#define ADVME_CTL_D16    0x00400000
#define ADVME_CTL_D32    0x00800000
#define ADVME_CTL_A16    0x00000000
#define ADVME_CTL_A24    0x00010000
#define ADVME_CTL_A32    0x00020000
#define ADVME_CTL_CR     0x00050000
#define ADVME_CTL_USER1  0x00060000
#define ADVME_CTL_USER2  0x00070000
#define ADVME_CTL_DATA   0x00000000
#define ADVME_CTL_PROG   0x00004000
#define ADVME_CTL_USER   0x00000000
#define ADVME_CTL_SUPER  0x00001000
#define ADVME_CTL_NOBLT  0x00000000
#define ADVME_CTL_BLT    0x00000100
#define ADVME_CTL_MEM    0x00000000
#define ADVME_CTL_IO     0x00000001

/* ADVME */
#define ADVME_LCRBASE       0x0
#define ADVME_MAP_SIZE      0x1000

#define ADVME_IRQ_VOWN    0x0001
#define ADVME_IRQ_VIRQ1   0x0002
#define ADVME_IRQ_VIRQ2   0x0004
#define ADVME_IRQ_VIRQ3   0x0008
#define ADVME_IRQ_VIRQ4   0x0010
#define ADVME_IRQ_VIRQ5   0x0020
#define ADVME_IRQ_VIRQ6   0x0040
#define ADVME_IRQ_VIRQ7   0x0080
#define ADVME_IRQ_DMA     0x0100
#define ADVME_IRQ_LERR    0x0200
#define ADVME_IRQ_VERR    0x0400
#define ADVME_IRQ_res     0x0800
#define ADVME_IRQ_IACK    0x1000
#define ADVME_IRQ_SWINT   0x2000
#define ADVME_IRQ_SYSFAIL 0x4000
#define ADVME_IRQ_ACFAIL  0x8000

#define ADVME_SEEK_SET 0
#define ADVME_SEEK_CUR 1
#define ADVME_CONFIG_REG_SPACE 0xA0000000
#define ADVME_PCI_SIZE_8      0x0001
#define ADVME_PCI_SIZE_16     0x0002
#define ADVME_PCI_SIZE_32     0x0003
#define ADVME_IOCTL_SET_CTL   0xF001
#define ADVME_IOCTL_SET_BS    0xF002
#define ADVME_IOCTL_SET_BD    0xF003
#define ADVME_IOCTL_SET_TO    0xF004
#define ADVME_IOCTL_PCI_SIZE  0xF005
#define ADVME_IOCTL_SET_MODE  0xF006
#define ADVME_IOCTL_SET_WINT  0xF007
#define ADVME_PCI_ID          0x0000
#define ADVME_PCI_CSR         0x0004
#define ADVME_PCI_CLASS	      0x0008
#define ADVME_PCI_MISC0       0x000C
#define ADVME_PCI_BS	      0x0010
#define ADVME_PCI_MISC1       0x003C
#define ADVME_LSI0_CTL	      0x0100
#define ADVME_LSI0_BS	      0x0104
#define ADVME_LSI0_BD         0x0108
#define ADVME_LSI0_TO	      0x010C
#define ADVME_LSI1_CTL	      0x0114
#define ADVME_LSI1_BS	      0x0118
#define ADVME_LSI1_BD	      0x011C
#define ADVME_LSI1_TO	      0x0120
#define ADVME_LSI2_CTL	      0x0128
#define ADVME_LSI2_BS	      0x012C
#define ADVME_LSI2_BD	      0x0130
#define ADVME_LSI2_TO	      0x0134
#define ADVME_LSI3_CTL	      0x013C
#define ADVME_LSI3_BS	      0x0140
#define ADVME_LSI3_BD	      0x0144
#define ADVME_LSI3_TO	      0x0148
#define ADVME_SCYC_CTL	      0x0170
#define ADVME_SCYC_ADDR       0x0174
#define ADVME_SCYC_EN	      0x0178
#define ADVME_SCYC_CMP	      0x017C
#define ADVME_SCYC_SWP	      0x0180
#define ADVME_LMISC	      0x0184
#define ADVME_SLSI	      0x0188
#define ADVME_L_CMDERR	      0x018C
#define ADVME_LAERR	      0x0190
#define ADVME_DCTL	      0x0200
#define ADVME_DTBC	      0x0204
#define ADVME_DLA	      0x0208
#define ADVME_DVA	      0x0210
#define ADVME_DCPP	      0x0218
#define ADVME_DGCS	      0x0220
#define ADVME_D_LLUE	      0x0224
#define ADVME_LINT_EN	      0x0300
#define ADVME_LINT_STAT	      0x0304
#define ADVME_LINT_MAP0	      0x0308
#define ADVME_LINT_MAP1	      0x030C
#define ADVME_VINT_EN	      0x0310
#define ADVME_VINT_STAT	      0x0314
#define ADVME_VINT_MAP0	      0x0318
#define ADVME_VINT_MAP1	      0x031C
#define ADVME_STATID	      0x0320
#define ADVME_V1_STATID	      0x0324
#define ADVME_V2_STATID	      0x0328
#define ADVME_V3_STATID	      0x032C
#define ADVME_V4_STATID	      0x0330
#define ADVME_V5_STATID	      0x0334
#define ADVME_V6_STATID	      0x0338
#define ADVME_V7_STATID	      0x033C
#define ADVME_MAST_CTL	      0x0400
#define ADVME_MISC_CTL	      0x0404
#define ADVME_MISC_STAT	      0x0408
#define ADVME_USER_AM	      0x040C
#define ADVME_VSI0_CTL	      0x0F00
#define ADVME_VSI0_BS	      0x0F04
#define ADVME_VSI0_BD	      0x0F08
#define ADVME_VSI0_TO	      0x0F0C
#define ADVME_VSI1_CTL	      0x0F14
#define ADVME_VSI1_BS	      0x0F18
#define ADVME_VSI1_BD	      0x0F1C
#define ADVME_VSI1_TO	      0x0F20
#define ADVME_VSI2_CTL	      0x0F28
#define ADVME_VSI2_BS	      0x0F2C
#define ADVME_VSI2_BD	      0x0F30
#define ADVME_VSI2_TO	      0x0F34
#define ADVME_VSI3_CTL	      0x0F3C
#define ADVME_VSI3_BS	      0x0F40
#define ADVME_VSI3_BD	      0x0F44
#define ADVME_VSI3_TO	      0x0F48
#define ADVME_VRAI_CTL	      0x0F70
#define ADVME_VRAI_BS	      0x0F74
#define ADVME_VCSR_CTL	      0x0F80
#define ADVME_VCSR_TO	      0x0F84
#define ADVME_V_AMERR	      0x0F88
#define ADVME_VAERR	      0x0F8C
#define ADVME_VCSR_CLR	      0x0FF4
#define ADVME_VCSR_SET	      0x0FF8
#define ADVME_VCSR_BS         0x0FFC


/* Bit */
#define ADVME_LINT_MAP0_BIT    0x22222220
#define ADVME_LINT_STAT_CLEAR  0x000000fe
#define ADVME_LINT_EN_BIT      0x000000fe
#define ADVME_LINT_DIS_BIT     0x00000000


#if LINUX_VERSION_CODE >= 0x020600
static const struct pci_device_id advme_device_id_table[] = {
  {PCI_DEVICE(ADVME_VENDOR_ID, ADVME_DEVICE_ID), .driver_data = 0,},
  { }
};
#endif
