/*
 * Advanet Advme8001
 * PCI-VME
 * 
 * H.baba
 * Feb 9, 2003
 */

#include "advme.h"

int advme_init_register(int irq, unsigned int lcr);
int advme_enable_advme(void);
void advme_clr_sysfail(void);
void advme_set_amsr(char am);
void advme_set_vmeaddr(unsigned int addr);
void advme_vread16(unsigned int addr,short *data);
void advme_vread32(unsigned int addr,int *data);
void advme_vwrite16(unsigned int addr,short *data);
void advme_vwrite32(unsigned int addr,int *data);
void advme_define_intlevel(int level);
void advme_enable_interrupt(void);
void advme_disable_interrupt(void);
int advme_check_interrupt(void);
int advme_read_intvector(void);
void advme_dma_vread32_start(unsigned int addr,int size);
int advme_dma_vread32_store(char *data,int size);

struct vpci_struct{
  unsigned int irq;
  unsigned int lcr_addr;
};

struct vpci_struct vpci_table[] ={
  {0, 0}
};

struct vpci_reg{
  char *lcr;
  char *csr;
  char *remote;
};

struct vpci_reg vreg[]={
  {0, 0, 0}
};

char *usrptr;
volatile static int intlevel;
volatile static short intleveln;


int advme_init_register(int irq,unsigned int lcr){

  vpci_table->irq = (unsigned int)irq;
  vpci_table->lcr_addr = (unsigned int)lcr;
  vreg->lcr = ioremap(lcr,ADVME_MAP_SIZE);

  /*
    writel(0x00800000,vreg->lcr+ADVME_LSI0_CTL);
    writel(0x00800000,vreg->lcr+ADVME_LSI1_CTL);
    writel(0x00800000,vreg->lcr+ADVME_LSI2_CTL);
    writel(0x00800000,vreg->lcr+ADVME_LSI3_CTL);
    writel(0x15060000,vreg->lcr+ADVME_MISC_CTL);
    writel(0x00000000,vreg->lcr+ADVME_LINT_EN);
    writel(0x0000FFFF,vreg->lcr+ADVME_LINT_STAT);
  */

  advme_set_amsr(A32);
  writel(ADVME_UNI_LSI0_BS,vreg->lcr + ADVME_LSI0_BS);
  writel(ADVME_UNI_LSI0_BD,vreg->lcr + ADVME_LSI0_BD);
  vreg->remote = (char *)ioremap(ADVME_UNI_LSI0_BS,ADVME_REMOTE_SIZE);

  writel(ADVME_LINT_MAP0_BIT,vreg->lcr + ADVME_LINT_MAP0);

  return 0;
}

void advme_set_amsr(char am){
  unsigned int ctl = 0,ad = 0;

  if(am == A16){
    ad = ADVME_CTL_A16;
  }else if(am == A24){
    ad = ADVME_CTL_A24;
  }else if(am == A32){
    ad = ADVME_CTL_A32;
  }
  ctl = ADVME_CTL_EN | ADVME_CTL_D32 | ad;
  writel(ctl,vreg->lcr + ADVME_LSI0_CTL);
}

void advme_set_vmeaddr(unsigned int addr){
  writel(addr,vreg->lcr + ADVME_LSI0_TO);
}

void advme_clr_sysfail(void){
  writel(ADVME_SYSFAIL_BIT,vreg->lcr + ADVME_VCSR_CLR);
}


void advme_vread16(unsigned int addr,short *data){
  unsigned short off,tdata;

  off = addr & (VME_PAGE-1);
  addr -= off;
  advme_set_vmeaddr(addr);
  tdata = readw(vreg->remote+off);
  *data = (0xff00 & (tdata << 8)) | (0x00ff & (tdata >> 8));
}

void advme_vread32(unsigned int addr,int *data){
  unsigned short off;
  unsigned int tdata;

  off = addr & (VME_PAGE-1);
  addr -= off;
  advme_set_vmeaddr(addr);
  tdata = readl(vreg->remote+off);
  *data = (0xff000000 & (tdata << 24)) | (0x00ff0000 & (tdata << 8))
    | (0x0000ff00 & (tdata >> 8)) | (0x000000ff & (tdata >> 24));
}

void advme_vwrite16(unsigned int addr,short *data){
  unsigned short off,tdata;

  off = addr & (VME_PAGE-1);
  addr -= off;
  advme_set_vmeaddr(addr);

  tdata = (0xff00 & (*data << 8)) | (0x00ff & (*data >> 8));
  writew(tdata,vreg->remote+off);
}

void advme_vwrite32(unsigned int addr,int *data){
  unsigned short off;
  unsigned int tdata;

  off = addr & (VME_PAGE-1);
  addr -= off;

  advme_set_vmeaddr(addr);

  tdata = (0xff000000 & (*data << 24)) | (0x00ff0000 & (*data << 8))
    | (0x0000ff00 & (*data >> 8)) | (0x000000ff & (*data >> 24));
  writel(tdata,vreg->remote+off);
}

void advme_define_intlevel(int level){
  intleveln = (short)level;
  intlevel = 1<<level;
}

void advme_enable_interrupt(void){
  writel(ADVME_LINT_STAT_CLEAR,vreg->lcr + ADVME_LINT_STAT);
  writel(ADVME_LINT_EN_BIT,vreg->lcr + ADVME_LINT_EN);
}
  
void advme_disable_interrupt(void){
  writel(ADVME_LINT_DIS_BIT,vreg->lcr + ADVME_LINT_EN);
  writel(ADVME_LINT_STAT_CLEAR,vreg->lcr + ADVME_LINT_STAT);
}

int advme_check_interrupt(void){
  if(readl(vreg->lcr + ADVME_LINT_STAT) & intlevel){
    return 1;
  }
  return 0;
}

int advme_read_intvector(void){
  return readl(vreg->lcr + ADVME_STATID + intleveln*4);
}

void advme_dma_vread32_start(unsigned int addr,int size){
}

int advme_dma_vread32_store(char *data,int size){
  return 0;
}

