/* analyzer
   Nov 5,2002

   Using Shared Memory
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/sem.h>
#include <netinet/in.h>
#include <netdb.h>
#include <signal.h>

#include "./common.h"
#ifndef BLKSIZE
#define BLKSIZE 0x4000
#endif

int listsock,listlen,shmid,semid;
unsigned int blocknum;
struct sockaddr_in listsaddr,listcaddr;
unsigned char data[BLKSIZE];
char *shmp;
int blksize = BLKSIZE;

#if defined(__GNU_LIBRARY__) && !defined(_SEM_SEMUN_UNDEFINED)
#else
union semun {
  int val;                        /* value for SETVAL */
  struct semid_ds *buf;           /* buffer for IPC_STAT & IPC_SET */
  unsigned short *array;          /* array for GETALL & SETALL */
  struct seminfo *__buf;          /* buffer for IPC_INFO */
};
#endif

/* union semun semunion; */

struct sembuf semb;
union semun semunion;

/* Semaphore Interface */
void semaphore_p(void){
  semb.sem_op = -1;
  semop(semid,&semb,1);
}
void semaphore_v(void){
  semb.sem_op = 1;
  semop(semid,&semb,1);
}

/* List Data */
void listThread(void){
  /* List Data Socket */
  while(1){
    recvfrom(listsock,data,blksize,0,(struct sockaddr *)&listcaddr,&listlen);
    semaphore_p();
    memcpy(shmp,data,blksize);
    if(blocknum == 0xffffff00){
      blocknum = 0;
    }else if(data[0] == 0x0a){
      blocknum = 0xffffffff;
    }else{
      blocknum++;
    }
    memcpy(shmp+blksize,(char *)&blocknum,4);
    semaphore_v();
  }
}

/* Signal */
void intsig(void){
  close(listsock);
  shmdt(shmp);
  shmctl(shmid,IPC_RMID,0);
  semctl(semid,0,IPC_RMID,semunion);
  exit(0);
}


int main(int argc,char *argv[]){

  blocknum = 0;
  semb.sem_num = 0;
  semb.sem_flg = SEM_UNDO;

  /* Signal */
  signal(SIGINT,(void *)intsig);

  if(argc == 2){
    if(strcmp(argv[1],"-D") == 0){
      daemon(0,1);
    }
  }

  /* Shared Memory */
  if((shmid = shmget(SHMKEY,blksize+4,IPC_CREAT|0777)) == -1){
    perror("Can't create shared memory.\n");
    exit(1);
  }
  shmp = shmat(shmid,0,0);

  /* Semaphore */
  if((semid = semget(SEMKEY,1,IPC_CREAT|0666)) == -1){
    perror("Can't create semaphore.\n");
    shmdt(shmp);
    shmctl(shmid,IPC_RMID,0);
    exit(1);
  }
  semunion.val = 1;
  if(semctl(semid,0,SETVAL,semunion) == -1){
    perror("Can't control semaphore.\n");
    shmdt(shmp);
    shmctl(shmid,IPC_RMID,0);
    semctl(semid,0,IPC_RMID,semunion);
    exit(1);
  }    

  memset(data,0,blksize);
  memset(shmp,0,blksize+4);
  /*
    bzero((char *)&data,blksize);
    bzero(shmp,blksize+4);
  */

  if((listsock = socket(PF_INET,SOCK_DGRAM,0)) < 0){
    perror("Can't make listsock.\n");
    shmdt(shmp);
    shmctl(shmid,IPC_RMID,0);
    semctl(semid,0,IPC_RMID,semunion);
    exit(1);
  }
  bzero((char *)&listsaddr,sizeof(listsaddr));
  listsaddr.sin_family = AF_INET;
  listsaddr.sin_addr.s_addr = INADDR_ANY;
  listsaddr.sin_port = htons(ANAPORT);
  if(bind(listsock,(struct sockaddr *)&listsaddr,sizeof(listsaddr)) < 0){
    perror("Can't bind listsocket.\n");
    exit(1);
  }
  listlen = sizeof(listcaddr);
  listThread();

  return 0;
}
