#include <stdio.h>
#include <unistd.h>
#include <pthread.h>
#include <string.h>
#include <netdb.h>
#include <stdlib.h>

#include "bbtcp.h"

const int rport = 30718;
int sock;
struct sockaddr_in saddr, caddr;

void udprecv(void){
  unsigned char data[256];
  int magic;
  unsigned char ip[4];
  int clen, sz;
  struct sockaddr_in caddr;
  struct hostent *host;

  while(1){
    sz = recvfrom(sock, (char *)data, sizeof(data), 0,
	     (struct sockaddr *)&caddr, (socklen_t*)&clen);
    getipfromsockaddr(caddr, ip);
    memcpy((char *)&magic, data, 4);
    if(magic == 0xf7000000){
      printf("------------------\n");
      printf("IP   = %u.%u.%u.%u\n", ip[0],ip[1],ip[2],ip[3]);
      printf("Ver  = %c%c\n", data[8],data[9]);
      printf("MAC  = %02X-%02X-%02X-%02X-%02X-%02X\n",
	     data[24],data[25],data[26],data[27],
	     data[28],data[29]);
      
      host = gethostbyaddr(&caddr.sin_addr.s_addr,
			   sizeof(caddr.sin_addr.s_addr), AF_INET);
      printf("Host = %s\n", host->h_name);
      printf("------------------\n\n");
    }
    
  }
}


int main(int argc, char *argv[]){
  pthread_t udpthread;
  char com[4];
  unsigned int t = 1;

  sock = mkbroadsend(rport, &saddr);
  pthread_create(&udpthread, NULL, (void *)udprecv, NULL);
  pthread_detach(udpthread);

  com[0] = 0x00;
  com[1] = 0x00;
  com[2] = 0x00;
  com[3] = 0xf6;
  sendto(sock, com, 4, 0, (struct sockaddr *)&saddr, sizeof(saddr));

  if(argc > 1){
    t = strtoul(argv[1], NULL, 0);
    printf("Wait %u seconds\n", t);
  }

  sleep(t);


  return 0;
}

