/* last modified : 15/02/03 18:12:19 
 *
 * gto/skelgto/libskelgto.c
 *
 * library for Skelton GTO
 *
 * H.B. (2015)
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>

#include "bbtcp.h"
#include "libskelgto.h"

#define PORT_GTO        10001

const char com_read     = 0x40;
const char com_reset    = 0x41;
const char com_eepread  = 0x42;
const char com_eepwrite = 0x60;
const char com_flush    = 0xc0;
const char com_write    = 0x80;  // com_write | addr
const char com_mask     = 0xc0;
const char com_user     = 0x00;
const char com_unmask   = 0x3f;

static int sock = 0;

int gto_open(char *hostname){
  if(sock) return sock;
  if((sock = mktcpsend(hostname, PORT_GTO)) == 0){
    return 0;
  }
  return sock;
}

void gto_close(void){
  if(sock) close(sock);
  sock = 0;
}

int gto_com(char com[2]){
  if(!sock) return 0;
  return send(sock, com, 2, 0);
}

int gto_flush(void){
  char c[2] = {com_flush, com_flush};
  return gto_com(c);
}

int gto_recv_tout(char *data, int tout){
  struct timeval t;
  fd_set fdset;
  
  t.tv_sec = tout;
  t.tv_usec = 0;

  FD_ZERO(&fdset);
  FD_SET(sock, &fdset);

  if(select(sock+1, &fdset, NULL, NULL, &t) != 0){
    if(FD_ISSET(sock, &fdset)){
      return recv(sock, data, SKELGTO_SIZEOF_VAL, MSG_WAITALL);
    }else{
      return 0;
    }
  }
    
  return 0;
}

int gto_read(char *data){
  char c[2] = {0};

  c[0] = com_read;
  if(gto_com(c)){
    return recv(sock, data, SKELGTO_SIZEOF_VAL, MSG_WAITALL);
  }else{
    return 0;
  }
}

int gto_uread(char addr, char *data){
  char c[2] = {0};

  c[0] = com_user | (addr & com_unmask);
  if(gto_com(c)){
    return recv(sock, data, SKELGTO_SIZEOF_VAL, MSG_WAITALL);
  }else{
    return 0;
  }
}

void gto_dumpdata(char *data){
  int i;
  for(i=0;i<64;i++){
    printf("0x%02x ", (unsigned char)data[i]);
    if(i%8 == 7){
      printf("\n");
    }
  }
  printf("\n");
}

void gto_dumpcdata(char *data){
  int i;
  for(i=0;i<64;i++){
    printf("%c ", data[i]);
    if(i%8 == 7){
      printf("\n");
    }
  }
  printf("\n");
}

int gto_eepread(void){
  char c[2] = {com_eepread, 0};

  return gto_com(c);
}

int gto_eepwrite(void){
  char c[2] = {com_eepwrite, 0};

  return gto_com(c);
}

int gto_reset(void){
  char c[2] = {com_reset, 0};
  
  return gto_com(c);
}


int gto_vwrite(char com, char addr, char val){
  char c[2];

  c[0] = (com & com_mask) | (addr & com_unmask);
  c[1] = val;

  return gto_com(c);
}

int gto_vwrite16(char com, char addr, short val){
  char cval, i, ret;

  for(i=0;i<2;i++){
    cval = (val>>(i*8)) & 0xff;
    ret = gto_vwrite(com, addr+i, cval);
    if(!ret) return 0;
  }

  return 1;
}

int gto_vwrite24(char com, char addr, int val){
  char cval, i, ret;

  for(i=0;i<3;i++){
    cval = (val>>(i*8)) & 0xff;
    ret = gto_vwrite(com, addr+i, cval);
    if(!ret) return 0;
  }

  return 1;
}

int gto_vwrite32(char com, char addr, int val){
  char cval, i, ret;

  for(i=0;i<4;i++){
    cval = (val>>(i*8)) & 0xff;
    ret = gto_vwrite(com, addr+i, cval);
    if(!ret) return 0;
  }

  return 1;
}

int gto_vwrite64(char com, char addr, long long int val){
  char cval, i, ret;

  for(i=0;i<8;i++){
    cval = (val>>(i*8)) & 0xff;
    ret = gto_vwrite(com, addr+i, cval);
    if(!ret) return 0;
  }

  return 1;
}

		  
int gto_write(char addr, char val){

  return gto_vwrite(com_write, addr, val);
}

int gto_write16(char addr, short val){

  return gto_vwrite16(com_write, addr, val);
}

int gto_write24(char addr, int val){

  return gto_vwrite24(com_write, addr, val);
}

int gto_write32(char addr, int val){
  return gto_vwrite32(com_write, addr, val);
}

int gto_write64(char addr, long long int val){
  return gto_vwrite64(com_write, addr, val);
}

int gto_uwrite(char addr, char val){

  return gto_vwrite(com_user, addr, val);
}

int gto_uwrite16(char addr, short val){

  return gto_vwrite16(com_user, addr, val);
}

int gto_uwrite24(char addr, int val){

  return gto_vwrite24(com_user, addr, val);
}

int gto_uwrite32(char addr, int val){
  return gto_vwrite32(com_user, addr, val);
}

