/* functions */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#include "libskelgto.h"
#include "cmdtsgtofunc.h"
#include "cmdtsgto.h"

extern COMMAND comlist[];

char data[64] = {0};
char t[256] = {0};

const char *ofstr[] = {"off\0", "on\0"};


char *findparam(char ena, SDGTOADV *adv){
  int i = 0;

  while(adv[i].param){
    if(ena == adv[i].val){
      return adv[i].param;
    }
    i++;
  }
  
  return NULL;
}

int chkupper(char c){
  if(isupper(c)){
    return 1;
  }else{
    return 0;
  }
}

int chkone(char c){
  if(c == '1'){
    return 1;
  }
  return 0;
}

int chkval(char *arg, SDGTOADV *adv){
  int i=0;
  while(adv[i].param){
    if(!strcmp(adv[i].param, arg)){
      return adv[i].val;
    }
    i++;
  }

  return -1;
}

char chkadv(char *arg, SDGTOADV *adv, SDGTOADV *radv){
  int i=0;
  while(adv[i].param){
    if(!strcmp(adv[i].param, arg)){
      memcpy((char *)radv, (char *)(adv+i), sizeof(SDGTOADV));
      return 1;
    }
    i++;
  }
  radv->param = NULL;
  radv->addr = -1;
  radv->val = -1;
  radv->disable = -1;
  return -1;
}

int noop(void){
  return gto_read(data);
}

int status(void){

  gto_read(data);


  printf("*** Status ***\n");

  printf("\n\n");

  return 1;
}

int readparam(void){
  gto_read(data);
  gto_dumpdata(data);
  //gto_dumpcdata(data);
  return 1;
}

int init(void){
  printf("Initialize\n");
  return gto_reset();
}

int eepr(void){
  printf("Parameters from EEPROM\n");
  gto_eepread();

  gto_read(data);
  gto_dumpdata(data);
  //gto_dumpcdata(data);
  return 1;
}

int eepw(void){
  printf("Current parameters to EEPROM\n");
  return gto_eepwrite();
}

int ts(void){
  unsigned long long int v;
  gto_uread(0, data);
  //gto_dumpdata(data);
  memcpy((char *)&v, data, sizeof(v));
  if(v & 0x8000000000000000LL){
    v = v & 0x00ffffffffffffffLL;
    printf("TS = 0x%016llx / %llu\n", v, v);
  }else{
    printf("no trigger\n");
  }
  
  return 1;
}

int all(void){
  unsigned long long int v;
  unsigned int scr, gscr;
  gto_uread(0, data);
  //gto_dumpdata(data);
  memcpy((char *)&v, data, sizeof(v));
  if(v & 0x8000000000000000LL){
    v = v & 0x00ffffffffffffffLL;
    printf("TS = 0x%016llx / %llu\n", v, v);
  }else{
    printf("no trigger\n");
  }
  memcpy((char *)&scr, data+8, 4);
  memcpy((char *)&gscr, data+12, 4);
  
  printf("Trigger all scaler      = %d\n", scr);
  printf("Trigger accepted scaler = %d\n", gscr);
  printf("(%d trigger signals are lost)\n", scr - gscr);
  
  return 1;
}

int pulse(char *args[]){
  unsigned char val;

  if(!args[0]) return 0;

  val = (unsigned char)strtol(args[0], NULL, 0);
  
  gto_uwrite(uadr_pulse, val);

  return 1;
}


int level(char *args[]){
  unsigned char val;

  if(!args[0]) return 0;

  val = (unsigned char)strtol(args[0], NULL, 0);
  
  gto_uwrite(uadr_level, val);

  return 1;
}

int reset(void){
  gto_uwrite(uadr_reset, 1);
  return 1;
}

int clear(void){
  gto_uwrite(uadr_clear, 1);
  return 1;
}

int scrclr(void){
  gto_uwrite(uadr_scrclr, 1);
  return 1;
}

int test(char *args[]){
  char v;

  if(!args[0]) return 0;

  if((v = (char)chkval(args[0], testadv)) < 0){
    return 0;
  }
  gto_uwrite(uadr_test, v);
  printf("Test LED %s\n", args[0]);

  return 1;
}

int help(void){
  int i;
  printf(" cmdselgto HOSTNAME COM [params] ...\n\n");
  printf(" COM = ");
  i = 0;
  while(comlist[i].com != NULL){
    printf(" %-8s : %s ", comlist[i].com, comlist[i].doc);
    if(comlist[i].param != NULL){
      printf("(%s)", comlist[i].param);
    }
    printf("\n       ");
    i++;
  }
  printf("\n");

  return 1;
}
