/*
 * last modified : 18/03/07 10:30:54 
 *
 * Hidetada Baba (RIKEN)
 *
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "libskelgto.h"
#include "cmdtsgtofunc.h"

COMMAND comlist[] = {
  {"status",    status,    "Read status", NULL},
  {"read",      readparam, "Read parameters (for debug)", NULL},
  {"init",      init,      "Initialize all parameters to default value", NULL},
  {"eepr",      eepr,      "Load parameters from EEPROM", NULL},
  {"eepw",      eepw,      "Save current parameters to EEPROM", NULL},
  {"ts",        ts,        "Get current ts value", NULL},
  {"all",       all,       "Get all TS / Scaler information", NULL},
  {"pulse",     pulse,     "Pulse output (8bit pattern)", "0xXX"},
  {"level",     level,     "Pulse output (8bit pattern)", "0xXX"},
  {"reset",     reset,     "Reset TS clock counter", NULL},
  {"clear",     clear,     "Clear latched TimeStamp", NULL},
  {"scrclr",    scrclr,    "Clear Scaler Values", NULL},
  {"test",      test,      "Test LED", "on/off"},
  {"noop",      noop,      "Dummy access to GTO", NULL},
  {"help",      help,      "Help", NULL},
  {NULL,        NULL,      NULL,   NULL} };

void quit(void){
  gto_close();
}

int main(int argc, char *argv[]){
  int i;

  if(argc < 3){
    help();
    return 0;
  }

  if(!gto_open(argv[1])){
    printf("Cannot connect %s\n", argv[1]);
    return 0;
  }

  gto_flush();

  i=0;
  while(comlist[i].com != NULL){
    if(!strcmp(comlist[i].com, argv[2])){
      if(!comlist[i].func(argv+3)){
	printf("Invalid argument %s\n\n", argv[3]);
	help();
      }
      break;
    }
    i++;
  }

  if(comlist[i].com == NULL){
    printf("Invalid function %s\n\n", argv[2]);
    help();
  }else{
    noop();
  }

  quit();

  return 0;
}
